/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectGenerate2D;
import ivorius.pandorasbox.effects.Vec3d;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.utils.PBNBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;

public class PBEffectGenDome
extends PBEffectGenerate2D {
    public Block block;
    public Block fillBlock;

    public PBEffectGenDome() {
    }

    public PBEffectGenDome(int time, double range, int unifiedSeed, Block block, Block fillBlock) {
        super(time, range, 2, unifiedSeed);
        this.block = block;
        this.fillBlock = fillBlock;
    }

    @Override
    public void generateOnSurface(Level world, PandorasBoxEntity box, Vec3d effectCenter, RandomSource random, BlockPos pos, double dist, int pass) {
        int domeHeightY = Mth.m_14165_((double)this.range);
        for (int y = -domeHeightY; y <= domeHeightY; ++y) {
            BlockPos shiftedPos = pos.m_6630_(y);
            if (pass == 0) {
                if (!PBEffectGenDome.isSpherePart((double)shiftedPos.m_123341_() + 0.5, (double)shiftedPos.m_123342_() + 0.5, (double)shiftedPos.m_123343_() + 0.5, effectCenter.f_82479_, effectCenter.f_82480_, effectCenter.f_82481_, this.range - 1.5, this.range) || !world.m_8055_(shiftedPos).m_60710_((LevelReader)world, shiftedPos)) continue;
                PBEffectGenDome.setBlockVarying(world, shiftedPos, this.block, this.unifiedSeed);
                continue;
            }
            if (pass != 1 || this.fillBlock == null || !PBEffectGenDome.isSpherePart((double)shiftedPos.m_123341_() + 0.5, (double)shiftedPos.m_123342_() + 0.5, (double)shiftedPos.m_123343_() + 0.5, effectCenter.f_82479_, effectCenter.f_82480_, effectCenter.f_82481_, 0.0, this.range - 1.5) || !world.m_8055_(shiftedPos).m_60710_((LevelReader)world, shiftedPos)) continue;
            PBEffectGenDome.setBlockVarying(world, shiftedPos, this.fillBlock, this.unifiedSeed);
        }
    }

    public static boolean isSpherePart(double x, double y, double z, double centerX, double centerY, double centerZ, double distStart, double distEnd) {
        double xDist = centerX - x;
        double yDist = centerY - y;
        double zDist = centerZ - z;
        double rangeSQ = xDist * xDist + yDist * yDist + zDist * zDist;
        return rangeSQ >= distStart * distStart && rangeSQ < distEnd * distEnd;
    }

    @Override
    public void writeToNBT(CompoundTag compound) {
        super.writeToNBT(compound);
        compound.m_128359_("block", PBNBTHelper.storeBlockString(this.block));
        if (this.fillBlock != null) {
            compound.m_128359_("fillBlock", PBNBTHelper.storeBlockString(this.fillBlock));
        }
    }

    @Override
    public void readFromNBT(CompoundTag compound) {
        super.readFromNBT(compound);
        this.block = PBNBTHelper.getBlock(compound.m_128461_("block"));
        this.fillBlock = PBNBTHelper.getBlock(compound.m_128461_("fillBlock"));
    }
}

