/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectGenerate2D;
import ivorius.pandorasbox.effects.Vec3d;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class PBEffectGenHeightNoise
extends PBEffectGenerate2D {
    public int minShift;
    public int maxShift;
    public int minTowerSize;
    public int maxTowerSize;
    public int blockSize;

    public PBEffectGenHeightNoise() {
    }

    public PBEffectGenHeightNoise(int time, double range, int unifiedSeed, int minShift, int maxShift, int minTowerSize, int maxTowerSize, int blockSize) {
        super(time, range, 1, unifiedSeed);
        this.minShift = minShift;
        this.maxShift = maxShift;
        this.minTowerSize = minTowerSize;
        this.maxTowerSize = maxTowerSize;
        this.blockSize = blockSize;
    }

    @Override
    public void generateOnSurface(Level world, PandorasBoxEntity entity, Vec3d effectCenter, RandomSource random, BlockPos pos, double range, int pass) {
        if (world instanceof ServerLevel) {
            int randomX = pos.m_123341_() - pos.m_123341_() % this.blockSize;
            int randomZ = pos.m_123343_() - pos.m_123343_() % this.blockSize;
            Random usedRandom = new Random(new Random(randomX).nextLong() ^ new Random(randomZ).nextLong());
            int shift = this.minShift + usedRandom.nextInt(this.maxShift - this.minShift + 1);
            int towerSize = this.minTowerSize + usedRandom.nextInt(this.maxTowerSize - this.minTowerSize + 1);
            int towerMinY = pos.m_123342_() - towerSize / 2;
            int minEffectY = towerMinY + Math.min(0, shift);
            int maxEffectY = towerMinY + towerSize + Math.max(0, shift);
            List entityList = world.m_45976_(Player.class, new AABB((double)pos.m_123341_() - 2.0, (double)(minEffectY - 4), (double)pos.m_123343_() - 3.0, (double)pos.m_123341_() + 4.0, (double)(maxEffectY + 4), (double)pos.m_123343_() + 4.0));
            if (entityList.size() == 0) {
                int y;
                BlockState[] states = new BlockState[towerSize];
                for (y = 0; y < towerSize; ++y) {
                    states[y] = world.m_8055_(pos.m_6630_(towerMinY));
                }
                for (y = 0; y < towerSize; ++y) {
                    PBEffectGenHeightNoise.setBlockSafe(world, pos.m_6630_(towerMinY), states[y]);
                }
            }
        }
    }

    @Override
    public void writeToNBT(CompoundTag compound) {
        super.writeToNBT(compound);
        compound.m_128405_("minShift", this.minShift);
        compound.m_128405_("maxShift", this.maxShift);
        compound.m_128405_("minTowerSize", this.minTowerSize);
        compound.m_128405_("maxTowerSize", this.maxTowerSize);
        compound.m_128405_("blockSize", this.blockSize);
    }

    @Override
    public void readFromNBT(CompoundTag compound) {
        super.readFromNBT(compound);
        this.minShift = compound.m_128451_("minShift");
        this.maxShift = compound.m_128451_("maxShift");
        this.minTowerSize = compound.m_128451_("minTowerSize");
        this.maxTowerSize = compound.m_128451_("maxTowerSize");
        this.blockSize = compound.m_128451_("blockSize");
    }
}

