/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.BlockPositions;
import ivorius.pandorasbox.effects.PBEffectGenerate;
import ivorius.pandorasbox.effects.Vec3d;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.utils.PBNBTHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class PBEffectGenLavaCages
extends PBEffectGenerate {
    public Block lavaBlock;
    public Block fillBlock;
    public Block cageBlock;
    public Block floorBlock;
    public Integer heightOffset = null;
    public Integer wallDist = null;

    public PBEffectGenLavaCages() {
    }

    public PBEffectGenLavaCages(int time, double range, int unifiedSeed, Block lavaBlock, Block cageBlock, Block fillBlock, Block floorBlock) {
        super(time, range, 1, unifiedSeed);
        this.lavaBlock = lavaBlock;
        this.cageBlock = cageBlock;
        this.fillBlock = fillBlock;
        this.floorBlock = floorBlock;
    }

    @Override
    public void generateOnBlock(Level world, PandorasBoxEntity entity, Vec3d effectCenter, RandomSource random, int pass, BlockPos pos, double range) {
        List outerList;
        if (this.heightOffset == null) {
            this.heightOffset = random.m_188503_(10) + 2;
        }
        if (this.wallDist == null) {
            this.wallDist = random.m_188503_(5) + 2;
        }
        if (!world.m_5776_() && !world.m_46575_(pos, (Entity)entity) && (outerList = world.m_45976_(Player.class, BlockPositions.expandToAABB(pos, 3.5, 3.5, 3.5))).size() > 0) {
            for (Player player : outerList) {
                int playerY = player.m_20183_().m_123342_();
                int playerX = player.m_20183_().m_123341_();
                int playerZ = player.m_20183_().m_123343_();
                int floor = playerY - 1;
                int ceil = playerY + this.heightOffset;
                this.createFloorOrCeil(world, playerX, floor, playerZ, this.wallDist);
                this.createFloorOrCeil(world, playerX, ceil, playerZ, this.wallDist);
                this.createWalls(world, playerX, playerY, ceil, playerZ, this.wallDist);
                this.fill(world, playerX, playerY, ceil, playerZ, this.wallDist);
            }
        }
    }

    public void createFloorOrCeil(Level world, int originX, int y, int originZ, int offset) {
        for (int x = originX - offset; x <= originX + offset; ++x) {
            for (int z = originZ - offset; z <= originZ + offset; ++z) {
                PBEffectGenLavaCages.setBlockVaryingUnsafeSrc(world, new BlockPos(x, y, z), this.floorBlock, this.unifiedSeed);
            }
        }
    }

    public void createWalls(Level world, int originX, int originY, int ceilheight, int originZ, int offset) {
        for (int x = originX - offset; x <= originX + offset; ++x) {
            for (int y = originY; y < ceilheight; ++y) {
                for (int z = originZ - offset; z <= originZ + offset; ++z) {
                    if (x != originX - offset && x != originX + offset && z != originZ - offset && z != originZ + offset) continue;
                    PBEffectGenLavaCages.setBlockVarying(world, new BlockPos(x, y, z), this.cageBlock, this.unifiedSeed);
                }
            }
        }
    }

    public void fill(Level world, int originX, int originY, int ceilheight, int originZ, int offset) {
        boolean fill = this.fillBlock != null;
        for (int x = originX - --offset; x <= originX + offset; ++x) {
            for (int y = originY; y < ceilheight - 1; ++y) {
                for (int z = originZ - offset; z <= originZ + offset; ++z) {
                    PBEffectGenLavaCages.setBlockVarying(world, new BlockPos(x, y, z), fill ? this.fillBlock : this.lavaBlock, this.unifiedSeed);
                }
            }
        }
    }

    @Override
    public void writeToNBT(CompoundTag compound) {
        super.writeToNBT(compound);
        if (this.lavaBlock != null) {
            compound.m_128359_("lavaBlock", PBNBTHelper.storeBlockString(this.lavaBlock));
        }
        if (this.fillBlock != null) {
            compound.m_128359_("fillBlock", PBNBTHelper.storeBlockString(this.fillBlock));
        }
        compound.m_128359_("cageBlock", PBNBTHelper.storeBlockString(this.cageBlock));
    }

    @Override
    public void readFromNBT(CompoundTag compound) {
        super.readFromNBT(compound);
        this.lavaBlock = PBNBTHelper.getBlock(compound.m_128461_("lavaBlock"));
        this.fillBlock = PBNBTHelper.getBlock(compound.m_128461_("fillBlock"));
        this.cageBlock = PBNBTHelper.getBlock(compound.m_128461_("cageBlock"));
    }
}

