/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectGenStructure;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.math.IvMathHelper;
import ivorius.pandorasbox.utils.PBNBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.commands.SetBlockCommand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class PBEffectGenPool
extends PBEffectGenStructure {
    public Block block;
    public Block platformBlock;

    public PBEffectGenPool() {
    }

    public PBEffectGenPool(int time, int maxX, int maxZ, int maxY, int startY, int unifiedSeed, Block block, Block platformBlock) {
        super(time, maxX, maxZ, maxY, startY, unifiedSeed, false);
        this.block = block;
        this.platformBlock = platformBlock;
    }

    @Override
    public void buildStructure(Level world, PandorasBoxEntity entity, BlockPos currentPos, RandomSource random, float prevRatio, float newRatio, int length, int width, int height, int originY, int originX, int originZ) {
        if (this.platformBlock == null) {
            this.platformBlock = Blocks.f_50333_;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        if (currentPos.m_123342_() == originY) {
            PBEffectGenPool.setBlockSafe((Level)serverLevel, currentPos, this.platformBlock.m_49966_());
        } else if (IvMathHelper.compareOffsets(currentPos.m_123341_(), originX, length) || IvMathHelper.compareOffsets(currentPos.m_123343_(), originZ, width)) {
            PBEffectGenPool.setBlockSafe((Level)serverLevel, currentPos, this.platformBlock.m_49966_());
        } else if (currentPos.m_123342_() < originY + height) {
            PBEffectGenPool.setBlockSafe((Level)serverLevel, currentPos, this.block.m_49966_());
        } else {
            PBEffectGenPool.setBlockToAirSafe(world, currentPos);
        }
    }

    @Override
    public void writeToNBT(CompoundTag compound) {
        super.writeToNBT(compound);
        compound.m_128359_("block", PBNBTHelper.storeBlockString(this.block));
        if (this.platformBlock != null) {
            compound.m_128359_("platformBlock", PBNBTHelper.storeBlockString(this.platformBlock));
        }
    }

    @Override
    public void readFromNBT(CompoundTag compound) {
        super.readFromNBT(compound);
        this.block = PBNBTHelper.getBlock(compound.m_128461_("block"));
        this.platformBlock = PBNBTHelper.getBlock(compound.m_128461_("platformBlock"));
    }

    static enum Mode {
        REPLACE((p_198450_0_, p_198450_1_, p_198450_2_, p_198450_3_) -> p_198450_2_);

        public final SetBlockCommand.Filter filter;

        private Mode(SetBlockCommand.Filter p_i47985_3_) {
            this.filter = p_i47985_3_;
        }
    }
}

