/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectGenerate;
import ivorius.pandorasbox.effects.Vec3d;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.utils.PBNBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class PBEffectGenReplace
extends PBEffectGenerate {
    public Block[] blocks;
    public Block[] blocksToReplace;

    public PBEffectGenReplace() {
    }

    public PBEffectGenReplace(int time, double range, int unifiedSeed, Block[] blocks, Block[] blocksToReplace) {
        super(time, range, 1, unifiedSeed);
        this.blocks = blocks;
        this.blocksToReplace = blocksToReplace;
    }

    @Override
    public void generateOnBlock(Level world, PandorasBoxEntity entity, Vec3d effectCenter, RandomSource random, int pass, BlockPos pos, double range) {
        if (world instanceof ServerLevel) {
            Block newBlock = this.blocks[random.m_188503_(this.blocks.length)];
            Block prevBlock = world.m_8055_(pos).m_60734_();
            boolean replace = false;
            for (Block block : this.blocksToReplace) {
                if (prevBlock != block) continue;
                replace = true;
            }
            if (replace) {
                PBEffectGenReplace.setBlockVarying(world, pos, newBlock, this.unifiedSeed);
            }
        }
    }

    @Override
    public void writeToNBT(CompoundTag compound) {
        super.writeToNBT(compound);
        PBNBTHelper.writeNBTBlocks("blocks", this.blocks, compound);
        PBNBTHelper.writeNBTBlocks("blocksToReplace", this.blocksToReplace, compound);
    }

    @Override
    public void readFromNBT(CompoundTag compound) {
        super.readFromNBT(compound);
        this.blocks = PBNBTHelper.readNBTBlocks("blocks", compound);
        this.blocksToReplace = PBNBTHelper.readNBTBlocks("blocksToReplace", compound);
    }
}

