/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.PandorasBoxHelper;
import ivorius.pandorasbox.effects.PBEffectGenerateByStructure;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.utils.PBNBTHelper;
import ivorius.pandorasbox.weighted.WeightedBlock;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class PBEffectGenShapes
extends PBEffectGenerateByStructure {
    public PBEffectGenShapes() {
    }

    public PBEffectGenShapes(int maxTicksAlive) {
        super(maxTicksAlive);
    }

    public void setRandomShapes(RandomSource random, Collection<WeightedBlock> blocks, double range, double minSize, double maxSize, int number, int shape) {
        this.structures = new PBEffectGenerateByStructure.Structure[number];
        for (int i = 0; i < this.structures.length; ++i) {
            StructureShape randomShape = this.createStructure();
            PBEffectGenShapes.applyRandomProperties(randomShape, range, random);
            randomShape.shapeType = shape < 0 ? random.m_188503_(4) : shape;
            randomShape.size = minSize + random.m_188500_() * (maxSize - minSize);
            randomShape.blocks = PandorasBoxHelper.getRandomBlockList(random, blocks);
            this.structures[i] = randomShape;
        }
    }

    public void setShapes(RandomSource random, Block[] blockSelection, double range, double minSize, double maxSize, int number, int shape, int unifiedSeed) {
        this.structures = new PBEffectGenerateByStructure.Structure[number];
        for (int i = 0; i < this.structures.length; ++i) {
            StructureShape randomShape = this.createStructure();
            PBEffectGenShapes.applyRandomProperties(randomShape, range, random);
            randomShape.shapeType = shape < 0 ? random.m_188503_(4) : shape;
            randomShape.size = minSize + random.m_188500_() * (maxSize - minSize);
            randomShape.blocks = (Block[])blockSelection.clone();
            randomShape.unifiedSeed = unifiedSeed;
            this.structures[i] = randomShape;
        }
    }

    @Override
    public void generateStructure(Level world, PandorasBoxEntity entity, RandomSource random, PBEffectGenerateByStructure.Structure structure, BlockPos pos, float newRatio, float prevRatio) {
        block12: {
            double newSize;
            double prevSize;
            StructureShape structureShape;
            block14: {
                block13: {
                    if (!(world instanceof ServerLevel)) break block12;
                    structureShape = (StructureShape)structure;
                    prevSize = structureShape.size * (double)prevRatio;
                    newSize = structureShape.size * (double)newRatio;
                    if (structureShape.shapeType != 0) break block13;
                    int requiredRange = Mth.m_14107_((double)newSize);
                    for (int xPlus = -requiredRange; xPlus <= requiredRange; ++xPlus) {
                        for (int yPlus = -requiredRange; yPlus <= requiredRange; ++yPlus) {
                            for (int zPlus = -requiredRange; zPlus <= requiredRange; ++zPlus) {
                                double dist = Mth.m_14116_((float)(xPlus * xPlus + yPlus * yPlus + zPlus * zPlus));
                                if (!(dist <= newSize)) continue;
                                if (dist > prevSize) {
                                    this.generateOnBlock(world, entity, random, structureShape, pos.m_7918_(structure.x + xPlus, structure.y + yPlus, structure.z + zPlus));
                                    continue;
                                }
                                zPlus = -zPlus;
                            }
                        }
                    }
                    break block12;
                }
                if (structureShape.shapeType != 1) break block14;
                int requiredRange = Mth.m_14107_((double)newSize);
                for (int xPlus = -requiredRange; xPlus <= requiredRange; ++xPlus) {
                    for (int yPlus = -requiredRange; yPlus <= requiredRange; ++yPlus) {
                        for (int zPlus = -requiredRange; zPlus <= requiredRange; ++zPlus) {
                            double xDist = Math.abs(xPlus);
                            double yDist = Math.abs(yPlus);
                            double zDist = Math.abs(zPlus);
                            if (!(xDist <= newSize) || !(yDist <= newSize) || !(zDist <= newSize)) continue;
                            if (xDist > prevSize || yDist > prevSize || zDist > prevSize) {
                                this.generateOnBlock(world, entity, random, structureShape, pos.m_7918_(structure.x + xPlus, structure.y + yPlus, structure.z + zPlus));
                                continue;
                            }
                            zPlus = -zPlus;
                        }
                    }
                }
                break block12;
            }
            if (structureShape.shapeType != 2 && structureShape.shapeType != 3) break block12;
            int requiredRange = Mth.m_14107_((double)newSize);
            int totalHeight = Mth.m_14107_((double)structureShape.size);
            for (int yPlus = -requiredRange; yPlus <= requiredRange; ++yPlus) {
                int yDist = Math.abs(yPlus);
                if (!((double)yDist <= newSize)) continue;
                if ((double)yDist > prevSize) {
                    int levelSize = structureShape.shapeType == 2 ? totalHeight - yDist : yDist + 1;
                    for (int xPlus = -levelSize; xPlus <= levelSize; ++xPlus) {
                        for (int zPlus = -levelSize; zPlus <= levelSize; ++zPlus) {
                            this.generateOnBlock(world, entity, random, structureShape, pos.m_7918_(structure.x + xPlus, structure.y + yPlus, structure.z + zPlus));
                        }
                    }
                    continue;
                }
                yPlus = -yPlus;
            }
        }
    }

    public void generateOnBlock(Level world, PandorasBoxEntity entity, RandomSource random, StructureShape structure, BlockPos pos) {
        Block block = structure.blocks[random.m_188503_(structure.blocks.length)];
        PBEffectGenShapes.setBlockVarying(world, pos, block, structure.unifiedSeed);
    }

    @Override
    public StructureShape createStructure() {
        return new StructureShape();
    }

    public static class StructureShape
    extends PBEffectGenerateByStructure.Structure {
        public Block[] blocks;
        public int shapeType;
        public double size;

        @Override
        public void writeToNBT(CompoundTag compound) {
            super.writeToNBT(compound);
            PBNBTHelper.writeNBTBlocks("blocks", this.blocks, compound);
            compound.m_128405_("shapeType", this.shapeType);
            compound.m_128347_("size", this.size);
        }

        @Override
        public void readFromNBT(CompoundTag compound) {
            super.readFromNBT(compound);
            this.blocks = PBNBTHelper.readNBTBlocks("blocks", compound);
            this.shapeType = compound.m_128451_("shapeType");
            this.size = compound.m_128459_("size");
        }
    }
}

