/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectNormal;
import ivorius.pandorasbox.effects.Vec3d;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public abstract class PBEffectGenStructure
extends PBEffectNormal {
    public int length;
    public int width;
    public int height;
    public int startingYOffset;
    public int unifiedSeed;
    public int x;
    public int y;
    public int z;
    public boolean hasAlreadyStarted = false;
    public boolean grounded = true;
    public BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();

    public PBEffectGenStructure() {
    }

    public PBEffectGenStructure(int maxTicksAlive, int maxX, int maxZ, int maxY, int startY, int unifiedSeed) {
        this(maxTicksAlive, maxX, maxZ, maxY, startY, unifiedSeed, true);
    }

    public PBEffectGenStructure(int maxTicksAlive, int maxX, int maxZ, int maxY, int startY, int unifiedSeed, boolean grounded) {
        super(maxTicksAlive);
        this.length = maxX;
        this.width = maxZ;
        this.height = maxY;
        this.startingYOffset = startY;
        this.grounded = grounded;
        this.unifiedSeed = unifiedSeed;
    }

    @Override
    public void doEffect(Level world, PandorasBoxEntity entity, Vec3d effectCenter, RandomSource random, float prevRatio, float newRatio) {
        if (world.m_5776_()) {
            return;
        }
        world.m_8055_((BlockPos)this.blockPos);
        if (!this.hasAlreadyStarted) {
            this.blockPos.m_122169_(effectCenter.f_82479_, effectCenter.f_82480_, effectCenter.f_82481_);
            BlockState state = world.m_8055_((BlockPos)this.blockPos);
            if (this.grounded) {
                while (state.m_60795_()) {
                    this.blockPos.m_122184_(0, -1, 0);
                    state = world.m_8055_((BlockPos)this.blockPos);
                }
            }
            this.blockPos.m_122184_(0, -this.startingYOffset, 0);
            this.x = this.blockPos.m_123341_() - this.length;
            this.y = this.blockPos.m_123342_();
            this.z = this.blockPos.m_123343_() - this.width;
            this.hasAlreadyStarted = true;
        }
        if (this.y <= this.blockPos.m_123342_() + this.height) {
            if (this.x <= this.blockPos.m_123341_() + this.length) {
                if (this.z <= this.blockPos.m_123343_() + this.width) {
                    this.buildStructure(world, entity, new BlockPos(this.x, this.y, this.z), random, prevRatio, newRatio, this.length, this.width, this.height, this.blockPos.m_123342_(), this.blockPos.m_123341_(), this.blockPos.m_123343_());
                    ++this.z;
                } else {
                    this.z = this.blockPos.m_123343_() - this.width;
                    ++this.x;
                }
            } else {
                this.x = this.blockPos.m_123341_() - this.length;
                ++this.y;
            }
        }
    }

    public abstract void buildStructure(Level var1, PandorasBoxEntity var2, BlockPos var3, RandomSource var4, float var5, float var6, int var7, int var8, int var9, int var10, int var11, int var12);

    @Override
    public void writeToNBT(CompoundTag compound) {
        super.writeToNBT(compound);
        compound.m_128405_("length", this.length);
        compound.m_128405_("width", this.width);
        compound.m_128405_("height", this.height);
        compound.m_128405_("x", this.x);
        compound.m_128405_("y", this.y);
        compound.m_128405_("z", this.z);
        compound.m_128379_("alreadyStarted", this.hasAlreadyStarted);
        compound.m_128379_("grounded", this.grounded);
        compound.m_128405_("startingYOffset", this.startingYOffset);
        compound.m_128405_("centerX", this.blockPos.m_123341_());
        compound.m_128405_("centerY", this.blockPos.m_123342_());
        compound.m_128405_("centerZ", this.blockPos.m_123343_());
    }

    @Override
    public void readFromNBT(CompoundTag compound) {
        super.readFromNBT(compound);
        this.length = compound.m_128451_("length");
        this.width = compound.m_128451_("width");
        this.height = compound.m_128451_("height");
        this.x = compound.m_128451_("x");
        this.y = compound.m_128451_("y");
        this.z = compound.m_128451_("z");
        this.blockPos.m_142451_(compound.m_128451_("centerX"));
        this.blockPos.m_142448_(compound.m_128451_("centerY"));
        this.blockPos.m_142443_(compound.m_128451_("centerZ"));
        this.hasAlreadyStarted = compound.m_128471_("alreadyStarted");
        this.grounded = compound.m_128471_("grounded");
        this.startingYOffset = compound.m_128451_("startingYOffset");
    }
}

