/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.PandorasBox;
import ivorius.pandorasbox.effects.PBEffectGenerateByStructure;
import ivorius.pandorasbox.effects.PBEffectSpawnEntityIDList;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.utils.ArrayListExtensions;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;

public class PBEffectGenTargets
extends PBEffectGenerateByStructure {
    public String entityToSpawn;
    public double range;
    public double targetSize;
    public double entityDensity;

    public PBEffectGenTargets() {
    }

    public PBEffectGenTargets(int maxTicksAlive, String entityToSpawn, double range, double targetSize, double entityDensity) {
        super(maxTicksAlive);
        this.entityToSpawn = entityToSpawn;
        this.range = range;
        this.targetSize = targetSize;
        this.entityDensity = entityDensity;
    }

    public void createTargets(Level world, double x, double y, double z, RandomSource random) {
        List players = world.m_45976_(Player.class, new AABB(x - this.range, y - this.range, z - this.range, x + this.range, y + this.range, z + this.range));
        this.structures = new PBEffectGenerateByStructure.Structure[players.size()];
        for (int i = 0; i < players.size(); ++i) {
            Player player = (Player)players.get(i);
            StructureTarget structureTarget = new StructureTarget();
            structureTarget.x = Mth.m_14107_((double)player.m_20185_());
            structureTarget.y = Mth.m_14107_((double)(player.m_20186_() - 0.5));
            structureTarget.z = Mth.m_14107_((double)player.m_20189_());
            structureTarget.structureStart = random.m_188501_() * 0.3f;
            structureTarget.structureLength = 0.5f + random.m_188501_() * 0.2f;
            structureTarget.colors = new int[Mth.m_14165_((double)this.targetSize) * 2];
            for (int j = 0; j < structureTarget.colors.length; ++j) {
                structureTarget.colors[j] = random.m_188503_(16);
            }
            this.structures[i] = structureTarget;
        }
    }

    @Override
    public void generateStructure(Level world, PandorasBoxEntity entity, RandomSource random, PBEffectGenerateByStructure.Structure structure, BlockPos pos, float newRatio, float prevRatio) {
        if (world instanceof ServerLevel) {
            StructureTarget structureTarget = (StructureTarget)structure;
            double newRange = (double)newRatio * this.targetSize;
            double prevRange = (double)prevRatio * this.targetSize;
            int requiredRange = Mth.m_14165_((double)newRange);
            for (int xP = -requiredRange; xP <= requiredRange; ++xP) {
                for (int zP = -requiredRange; zP <= requiredRange; ++zP) {
                    double dist = Mth.m_14116_((float)(xP * xP + zP * zP));
                    if (dist < newRange && dist >= prevRange) {
                        ArrayListExtensions terracottas = new ArrayListExtensions();
                        terracottas.addAll(PandorasBox.stained_terracotta);
                        PBEffectGenTargets.setBlockSafe(world, new BlockPos(structureTarget.x + xP, structureTarget.y, structureTarget.z + zP), ((Block)terracottas.get(structureTarget.colors[Mth.m_14107_((double)dist)])).m_49966_());
                        double nextDist = Mth.m_14116_((float)(xP * xP + 9 + (zP * zP + 9)));
                        if (nextDist >= this.targetSize && random.m_188500_() < this.entityDensity) {
                            Entity newEntity = PBEffectSpawnEntityIDList.createEntity(world, entity, random, this.entityToSpawn, (double)(structureTarget.x + xP) + 0.5, (double)structureTarget.y + 1.5, (double)(structureTarget.z + zP) + 0.5);
                            assert (newEntity != null);
                            world.m_7967_(newEntity);
                        }
                    }
                    for (int yP = 1; yP <= requiredRange; ++yP) {
                        double dist3D = Mth.m_14116_((float)(xP * xP + zP * zP + yP * yP));
                        if (!(dist3D < newRange) || !(dist3D >= prevRange)) continue;
                        PBEffectGenTargets.setBlockToAirSafe(world, new BlockPos(structureTarget.x + xP, structureTarget.y, structureTarget.z + zP));
                    }
                }
            }
        }
    }

    @Override
    public void writeToNBT(CompoundTag compound) {
        super.writeToNBT(compound);
        compound.m_128359_("entityToSpawn", this.entityToSpawn);
        compound.m_128347_("range", this.range);
        compound.m_128347_("targetSize", this.targetSize);
        compound.m_128347_("entityDensity", this.entityDensity);
    }

    @Override
    public void readFromNBT(CompoundTag compound) {
        super.readFromNBT(compound);
        this.entityToSpawn = compound.m_128461_("entityToSpawn");
        this.range = compound.m_128459_("range");
        this.targetSize = compound.m_128459_("targetSize");
        this.entityDensity = compound.m_128459_("entityDensity");
    }

    @Override
    public StructureTarget createStructure() {
        return new StructureTarget();
    }

    public static class StructureTarget
    extends PBEffectGenerateByStructure.Structure {
        public int[] colors;

        @Override
        public void writeToNBT(CompoundTag compound) {
            super.writeToNBT(compound);
            compound.m_128385_("colors", this.colors);
        }

        @Override
        public void readFromNBT(CompoundTag compound) {
            super.readFromNBT(compound);
            this.colors = compound.m_128465_("colors");
        }
    }
}

