/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectGenDome;
import ivorius.pandorasbox.effects.PBEffectNormal;
import ivorius.pandorasbox.effects.Vec3d;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.utils.PBNBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class PBEffectGenWorldSnake
extends PBEffectNormal {
    public Block[] blocks;
    public int unifiedSeed;
    public double currentX;
    public double currentY;
    public double currentZ;
    public double size;
    public double speed;
    public float dirYaw;
    public float dirPitch;
    public float dirYawAcc;
    public float dirPitchAcc;

    public PBEffectGenWorldSnake() {
    }

    public PBEffectGenWorldSnake(int maxTicksAlive, Block[] blocks, int unifiedSeed, double currentX, double currentY, double currentZ, double size, double speed, float dirYaw, float dirPitch) {
        super(maxTicksAlive);
        this.blocks = blocks;
        this.unifiedSeed = unifiedSeed;
        this.currentX = currentX;
        this.currentY = currentY;
        this.currentZ = currentZ;
        this.size = size;
        this.speed = speed;
        this.dirYaw = dirYaw;
        this.dirPitch = dirPitch;
    }

    @Override
    public void doEffect(Level world, PandorasBoxEntity entity, Vec3d effectCenter, RandomSource random, float prevRatio, float newRatio) {
        if (world instanceof ServerLevel) {
            int requiredRange = Mth.m_14165_((double)this.size);
            float f1 = Mth.m_14089_((float)(-this.dirYaw * ((float)Math.PI / 180) - (float)Math.PI));
            float f2 = Mth.m_14031_((float)(-this.dirYaw * ((float)Math.PI / 180) - (float)Math.PI));
            float f3 = -Mth.m_14089_((float)(-this.dirPitch * ((float)Math.PI / 180)));
            float f4 = Mth.m_14031_((float)(-this.dirPitch * ((float)Math.PI / 180)));
            double dirX = (double)(f2 * f3) * this.speed;
            double dirY = (double)f4 * this.speed;
            double dirZ = (double)(f1 * f3) * this.speed;
            double newX = this.currentX + dirX;
            double newY = this.currentY + dirY;
            double newZ = this.currentZ + dirZ;
            int baseX = Mth.m_14107_((double)newX);
            int baseY = Mth.m_14107_((double)newY);
            int baseZ = Mth.m_14107_((double)newZ);
            for (int x = -requiredRange; x <= requiredRange; ++x) {
                for (int y = -requiredRange; y <= requiredRange; ++y) {
                    for (int z = -requiredRange; z <= requiredRange; ++z) {
                        if (!PBEffectGenDome.isSpherePart((double)(baseX + x) + 0.5, (double)(baseY + y) + 0.5, (double)(baseZ + z) + 0.5, newX, newY, newZ, 0.0, this.size) || PBEffectGenDome.isSpherePart((double)(baseX + x) + 0.5, (double)(baseY + y) + 0.5, (double)(baseZ + z) + 0.5, this.currentX, this.currentY, this.currentZ, 0.0, this.size)) continue;
                        this.generateOnBlock(world, entity, random, new BlockPos(x + baseX, y + baseY, z + baseZ));
                    }
                }
            }
            this.currentX = newX;
            this.currentY = newY;
            this.currentZ = newZ;
            this.dirYaw += this.dirYawAcc;
            this.dirPitch += this.dirPitchAcc;
            this.dirYawAcc += Mth.m_14036_((float)((random.m_188501_() - random.m_188501_()) * 0.5f), (float)-10.0f, (float)10.0f);
            this.dirPitchAcc += Mth.m_14036_((float)((random.m_188501_() - random.m_188501_()) * 0.5f), (float)-10.0f, (float)10.0f);
        }
    }

    public void generateOnBlock(Level world, PandorasBoxEntity entity, RandomSource random, BlockPos pos) {
        PBEffectGenWorldSnake.setBlockVarying(world, pos, this.blocks[random.m_188503_(this.blocks.length)], this.unifiedSeed);
    }

    @Override
    public void writeToNBT(CompoundTag compound) {
        super.writeToNBT(compound);
        PBNBTHelper.writeNBTBlocks("block", this.blocks, compound);
        compound.m_128405_("unifiedSeed", this.unifiedSeed);
        compound.m_128347_("currentX", this.currentX);
        compound.m_128347_("currentY", this.currentY);
        compound.m_128347_("currentZ", this.currentZ);
        compound.m_128347_("size", this.size);
        compound.m_128347_("speed", this.speed);
        compound.m_128350_("dirYaw", this.dirYaw);
        compound.m_128350_("dirPitch", this.dirPitch);
        compound.m_128350_("dirYawAcc", this.dirYawAcc);
        compound.m_128350_("dirPitchAcc", this.dirPitchAcc);
    }

    @Override
    public void readFromNBT(CompoundTag compound) {
        super.readFromNBT(compound);
        this.blocks = PBNBTHelper.readNBTBlocks("block", compound);
        this.unifiedSeed = compound.m_128451_("unifiedSeed");
        this.currentX = compound.m_128459_("currentX");
        this.currentY = compound.m_128459_("currentY");
        this.currentZ = compound.m_128459_("currentZ");
        this.size = compound.m_128459_("size");
        this.speed = compound.m_128459_("speed");
        this.dirYaw = compound.m_128457_("dirYaw");
        this.dirPitch = compound.m_128457_("dirPitch");
        this.dirYawAcc = compound.m_128457_("dirYawAcc");
        this.dirPitchAcc = compound.m_128457_("dirPitchAcc");
    }
}

