/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectGenConvertToNether;
import ivorius.pandorasbox.effects.PBEffectRangeBased;
import ivorius.pandorasbox.effects.Vec3d;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public abstract class PBEffectGenerate
extends PBEffectRangeBased {
    public int unifiedSeed;
    public boolean biomeUnchanged = true;

    public PBEffectGenerate() {
    }

    public PBEffectGenerate(int time, double range, int passes, int unifiedSeed) {
        super(time, range, passes);
        this.unifiedSeed = unifiedSeed;
    }

    public static Vec3i floorAll(double x, double y, double z) {
        return new Vec3i(Mth.m_14107_((double)x), Mth.m_14107_((double)y), Mth.m_14107_((double)z));
    }

    public void changeBiome(ResourceKey<Biome> biomeResourceKey, int pass, Vec3d effectCenter, ServerLevel serverLevel) {
        if (!this.biomeUnchanged) {
            return;
        }
        BoundingBox boundingbox = BoundingBox.m_162375_((Vec3i)PBEffectGenerate.floorAll(this.range + (double)(this.passes - 1) * 5.0 + effectCenter.f_82479_, this.range + (double)(this.passes - 1) * 5.0 + effectCenter.f_82480_, this.range + (double)(this.passes - 1) * 5.0 + effectCenter.f_82481_), (Vec3i)PBEffectGenerate.floorAll(effectCenter.f_82479_ - this.range + (double)(this.passes - 1) * 5.0, effectCenter.f_82480_ - this.range + (double)(this.passes - 1) * 5.0, effectCenter.f_82481_ - this.range + (double)(this.passes - 1) * 5.0));
        ArrayList<ChunkAccess> chunks = new ArrayList<ChunkAccess>();
        for (int k = SectionPos.m_123171_((int)boundingbox.m_162398_()); k <= SectionPos.m_123171_((int)boundingbox.m_162401_()); ++k) {
            for (int l = SectionPos.m_123171_((int)boundingbox.m_162395_()); l <= SectionPos.m_123171_((int)boundingbox.m_162399_()); ++l) {
                ChunkAccess chunkaccess = serverLevel.m_6522_(l, k, ChunkStatus.f_62326_, false);
                chunks.add(chunkaccess);
            }
        }
        for (ChunkAccess chunkAccess : chunks) {
            Registry biomeRegistry = serverLevel.m_9598_().m_175515_(Registries.f_256952_);
            Biome biome = (Biome)biomeRegistry.m_6246_(biomeResourceKey);
            assert (biome != null);
            chunkAccess.m_183442_(PBEffectGenConvertToNether.makeResolver((Holder<Biome>)biomeRegistry.m_263177_((Object)biome)), serverLevel.m_7726_().m_214994_().m_224579_());
            chunkAccess.m_8092_(true);
        }
        serverLevel.m_7726_().f_8325_.m_274524_(chunks);
        this.biomeUnchanged = false;
    }

    @Override
    public void generateInRange(Level world, PandorasBoxEntity entity, RandomSource random, Vec3d effectCenter, double prevRange, double newRange, int pass) {
        int requiredRange = Mth.m_14165_((double)newRange);
        int baseX = Mth.m_14107_((double)effectCenter.f_82479_);
        int baseY = Mth.m_14107_((double)effectCenter.f_82480_);
        int baseZ = Mth.m_14107_((double)effectCenter.f_82481_);
        for (int x = -requiredRange; x <= requiredRange; ++x) {
            for (int y = -requiredRange; y <= requiredRange; ++y) {
                for (int z = -requiredRange; z <= requiredRange; ++z) {
                    double dist = Mth.m_14116_((float)(x * x + y * y + z * z));
                    if (!(dist <= newRange)) continue;
                    if (dist > prevRange) {
                        this.generateOnBlock(world, entity, effectCenter, random, pass, new BlockPos(baseX + x, baseY + y, baseZ + z), dist);
                        continue;
                    }
                    z = -z;
                }
            }
        }
    }

    public abstract void generateOnBlock(Level var1, PandorasBoxEntity var2, Vec3d var3, RandomSource var4, int var5, BlockPos var6, double var7);

    @Override
    public void writeToNBT(CompoundTag compound) {
        super.writeToNBT(compound);
        compound.m_128405_("unifiedSeed", this.unifiedSeed);
        compound.m_128379_("biomeUnchanged", this.biomeUnchanged);
    }

    @Override
    public void readFromNBT(CompoundTag compound) {
        super.readFromNBT(compound);
        this.unifiedSeed = compound.m_128451_("unifiedSeed");
        this.biomeUnchanged = compound.m_128471_("biomeUnchanged");
    }
}

