/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectRangeBased;
import ivorius.pandorasbox.effects.Vec3d;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;

public abstract class PBEffectGenerate2D
extends PBEffectRangeBased {
    public int unifiedSeed;

    public PBEffectGenerate2D() {
    }

    public PBEffectGenerate2D(int time, double range, int passes, int unifiedSeed) {
        super(time, range, passes);
        this.unifiedSeed = unifiedSeed;
    }

    @Override
    public void generateInRange(Level world, PandorasBoxEntity entity, RandomSource random, Vec3d effectCenter, double prevRange, double newRange, int pass) {
        int requiredRange = Mth.m_14107_((double)newRange);
        int baseX = Mth.m_14107_((double)effectCenter.f_82479_);
        int baseY = Mth.m_14107_((double)effectCenter.f_82480_);
        int baseZ = Mth.m_14107_((double)effectCenter.f_82481_);
        for (int x = -requiredRange; x <= requiredRange; ++x) {
            for (int z = -requiredRange; z <= requiredRange; ++z) {
                double dist = Mth.m_14116_((float)(x * x + z * z));
                if (!(dist <= newRange)) continue;
                if (dist > prevRange) {
                    this.generateOnSurface(world, entity, effectCenter, random, new BlockPos(baseX + x, baseY, baseZ + z), dist, pass);
                    continue;
                }
                z = -z;
            }
        }
    }

    public abstract void generateOnSurface(Level var1, PandorasBoxEntity var2, Vec3d var3, RandomSource var4, BlockPos var5, double var6, int var8);

    @Override
    public void writeToNBT(CompoundTag compound) {
        super.writeToNBT(compound);
        compound.m_128405_("unifiedSeed", this.unifiedSeed);
    }

    @Override
    public void readFromNBT(CompoundTag compound) {
        super.readFromNBT(compound);
        this.unifiedSeed = compound.m_128451_("unifiedSeed");
    }
}

