/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectRangeBased;
import ivorius.pandorasbox.effects.Vec3d;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;

public abstract class PBEffectGenerateByFlag
extends PBEffectRangeBased {
    public int unifiedSeed;
    public int[] flags;

    public PBEffectGenerateByFlag() {
    }

    public PBEffectGenerateByFlag(int time, double range, int passes, int unifiedSeed) {
        super(time, range, passes);
        this.unifiedSeed = unifiedSeed;
        this.flags = new int[961];
    }

    @Override
    public void setUpEffect(Level world, PandorasBoxEntity entity, Vec3d effectCenter, RandomSource random) {
        super.setUpEffect(world, entity, effectCenter, random);
        byte requiredRange = (byte)Mth.m_14165_((double)this.range);
        int baseX = Mth.m_14107_((double)effectCenter.f_82479_);
        int baseY = Mth.m_14107_((double)effectCenter.f_82480_);
        int baseZ = Mth.m_14107_((double)effectCenter.f_82481_);
        boolean[] flags = new boolean[31];
        for (byte x = (byte)(-requiredRange); x <= requiredRange; x = (byte)(x + 1)) {
            for (byte z = (byte)(-requiredRange); z <= requiredRange; z = (byte)(z + 1)) {
                for (byte y = (byte)(-requiredRange); y <= requiredRange; y = (byte)(y + 1)) {
                    double dist = Mth.m_14116_((float)(x * x + y * y + z * z));
                    if (!(dist <= this.range)) continue;
                    flags[y + 15] = this.hasFlag(world, entity, random, new BlockPos(baseX + x, baseY + y, baseZ + z));
                }
                this.setAllFlags(x, z, flags);
            }
        }
    }

    public abstract boolean hasFlag(Level var1, PandorasBoxEntity var2, RandomSource var3, BlockPos var4);

    @Override
    public void generateInRange(Level world, PandorasBoxEntity entity, RandomSource random, Vec3d effectCenter, double prevRange, double newRange, int pass) {
        byte requiredRange = (byte)Mth.m_14165_((double)newRange);
        int baseX = Mth.m_14107_((double)effectCenter.f_82479_);
        int baseY = Mth.m_14107_((double)effectCenter.f_82480_);
        int baseZ = Mth.m_14107_((double)effectCenter.f_82481_);
        for (byte x = (byte)(-requiredRange); x <= requiredRange; x = (byte)(x + 1)) {
            for (byte y = (byte)(-requiredRange); y <= requiredRange; y = (byte)(y + 1)) {
                for (byte z = (byte)(-requiredRange); z <= requiredRange; z = (byte)(z + 1)) {
                    double dist = Mth.m_14116_((float)(x * x + y * y + z * z));
                    if (!(dist <= newRange)) continue;
                    if (dist > prevRange) {
                        this.generateOnBlock(world, entity, random, pass, new BlockPos(baseX + x, baseY + y, baseZ + z), dist, this.getFlag(x, y, z));
                        continue;
                    }
                    z = -z;
                }
            }
        }
    }

    public abstract void generateOnBlock(Level var1, PandorasBoxEntity var2, RandomSource var3, int var4, BlockPos var5, double var6, boolean var8);

    public void setAllFlags(byte x, byte z, boolean ... flags) {
        int flagInt = 0;
        for (int i = flags.length - 1; i >= 0; --i) {
            boolean flag = flags[i];
            if (flag) {
                flagInt = (flagInt << 1) + 1;
                continue;
            }
            flagInt <<= 1;
        }
        this.flags[this.getFlagIndex((byte)x, (byte)z)] = flagInt;
    }

    public void setFlag(byte x, byte y, byte z, boolean flag) {
        int index = this.getFlagIndex(x, z);
        int bit = this.getBitOfFlag(y);
        this.flags[index] = flag ? this.flags[index] | bit : this.flags[index] & ~bit;
    }

    public boolean getFlag(byte x, byte y, byte z) {
        int bit;
        int index = this.getFlagIndex(x, z);
        return (this.flags[index] & (bit = this.getBitOfFlag(y))) > 0;
    }

    public int getBitOfFlag(byte y) {
        return 1 << y + 15;
    }

    public int getFlagIndex(byte x, byte z) {
        return (x + 15) * 31 + (z + 15);
    }

    @Override
    public void writeToNBT(CompoundTag compound) {
        super.writeToNBT(compound);
        compound.m_128405_("unifiedSeed", this.unifiedSeed);
        compound.m_128385_("flags", this.flags);
    }

    @Override
    public void readFromNBT(CompoundTag compound) {
        super.readFromNBT(compound);
        this.unifiedSeed = compound.m_128451_("unifiedSeed");
        this.flags = compound.m_128465_("flags");
    }
}

