/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectGenerate;
import ivorius.pandorasbox.effects.Vec3d;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.utils.ArrayListExtensions;
import ivorius.pandorasbox.worldgen.MegaTreeFeature;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;

public abstract class PBEffectGenerateByGenerator<T>
extends PBEffectGenerate {
    public boolean requiresSolidGround;
    public double chancePerBlock;
    public int generatorFlags;
    protected final ArrayListExtensions<T> treeGens = this.initializeGens();

    public PBEffectGenerateByGenerator() {
    }

    public PBEffectGenerateByGenerator(int time, double range, int unifiedSeed, boolean requiresSolidGround, double chancePerBlock, int generatorFlags) {
        super(time, range, 1, unifiedSeed);
        this.requiresSolidGround = requiresSolidGround;
        this.chancePerBlock = chancePerBlock;
        this.generatorFlags = generatorFlags;
    }

    abstract ArrayListExtensions<T> initializeGens();

    @Override
    public void generateOnBlock(Level world, PandorasBoxEntity entity, Vec3d effectCenter, RandomSource random, int pass, BlockPos pos, double range) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            if (random.m_188500_() < this.chancePerBlock) {
                BlockState blockState = world.m_8055_(pos);
                BlockPos posBelow = pos.m_7495_();
                BlockState blockBelowState = world.m_8055_(posBelow);
                if (blockState.m_60795_() && (!this.requiresSolidGround || blockBelowState.m_60796_((BlockGetter)world, posBelow))) {
                    PBEffectGenerateByGenerator.setBlockSafe(world, posBelow, Blocks.f_50493_.m_49966_());
                    T generator = this.getRandomGenerator(this.getGenerators(), this.generatorFlags, random);
                    if (generator instanceof ResourceKey) {
                        ResourceKey key = (ResourceKey)generator;
                        Optional configuredFeatureRegistry = world.m_9598_().m_6632_(Registries.f_256911_);
                        if (configuredFeatureRegistry.isEmpty()) {
                            return;
                        }
                        ConfiguredFeature feature = (ConfiguredFeature)((Registry)configuredFeatureRegistry.get()).m_6246_(key);
                        assert (feature != null);
                        feature.m_224953_((WorldGenLevel)serverWorld, serverWorld.m_7726_().m_8481_(), random, pos);
                    }
                    if (generator instanceof MegaTreeFeature) {
                        MegaTreeFeature feature = (MegaTreeFeature)generator;
                        feature.place(world, random, pos);
                    }
                }
            }
        }
    }

    public abstract List<T> getGenerators();

    public T getRandomGenerator(List<T> generators, int flags, RandomSource random) {
        int totalNumber = 0;
        for (int i = 0; i < generators.size(); ++i) {
            int flag = 1 << i;
            if ((flags & flag) <= 0) continue;
            ++totalNumber;
        }
        int chosenGen = random.m_188503_(totalNumber);
        for (int i = 0; i < generators.size(); ++i) {
            int flag = 1 << i;
            if ((flags & flag) <= 0) continue;
            if (chosenGen == 0) {
                return generators.get(i);
            }
            --chosenGen;
        }
        return null;
    }

    @Override
    public void writeToNBT(CompoundTag compound) {
        super.writeToNBT(compound);
        compound.m_128379_("requiresSolidGround", this.requiresSolidGround);
        compound.m_128347_("chancePerBlock", this.chancePerBlock);
        compound.m_128405_("generatorFlags", this.generatorFlags);
    }

    @Override
    public void readFromNBT(CompoundTag compound) {
        super.readFromNBT(compound);
        this.requiresSolidGround = compound.m_128471_("requiresSolidGround");
        this.chancePerBlock = compound.m_128459_("chancePerBlock");
        this.generatorFlags = compound.m_128451_("generatorFlags");
    }
}

