/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.PandorasBoxHelper;
import ivorius.pandorasbox.effects.PBEffectNormal;
import ivorius.pandorasbox.effects.Vec3d;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;

public abstract class PBEffectGenerateByStructure
extends PBEffectNormal {
    public Structure[] structures;

    public PBEffectGenerateByStructure() {
    }

    public PBEffectGenerateByStructure(int maxTicksAlive) {
        super(maxTicksAlive);
        this.structures = new Structure[0];
    }

    @Override
    public void doEffect(Level world, PandorasBoxEntity entity, Vec3d effectCenter, RandomSource random, float prevRatio, float newRatio) {
        for (Structure structure : this.structures) {
            float newStructureRatio = this.getStructureRatio(newRatio, structure);
            float prevStructureRatio = this.getStructureRatio(prevRatio, structure);
            int baseX = Mth.m_14107_((double)effectCenter.f_82479_);
            int baseY = Mth.m_14107_((double)effectCenter.f_82480_);
            int baseZ = Mth.m_14107_((double)effectCenter.f_82481_);
            if (!(newStructureRatio > prevStructureRatio)) continue;
            this.generateStructure(world, entity, random, structure, new BlockPos(baseX, baseY, baseZ), newStructureRatio, prevStructureRatio);
        }
    }

    private float getStructureRatio(float ratio, Structure structure) {
        return Mth.m_14036_((float)((ratio - structure.structureStart) / structure.structureLength), (float)0.0f, (float)1.0f);
    }

    public abstract void generateStructure(Level var1, PandorasBoxEntity var2, RandomSource var3, Structure var4, BlockPos var5, float var6, float var7);

    @Override
    public void writeToNBT(CompoundTag compound) {
        super.writeToNBT(compound);
        ListTag structureTagList = new ListTag();
        for (Structure structure : this.structures) {
            CompoundTag structureCompound = new CompoundTag();
            structure.writeToNBT(structureCompound);
            structureTagList.add((Object)structureCompound);
        }
        compound.m_128365_("structures", (Tag)structureTagList);
    }

    @Override
    public void readFromNBT(CompoundTag compound) {
        super.readFromNBT(compound);
        ListTag structureTagList = compound.m_128437_("structures", 10);
        this.structures = new Structure[structureTagList.size()];
        for (int i = 0; i < this.structures.length; ++i) {
            this.structures[i] = this.createStructure(structureTagList.m_128728_(i));
        }
    }

    public abstract Structure createStructure();

    public Structure createStructure(CompoundTag compound) {
        Structure structure = this.createStructure();
        structure.readFromNBT(compound);
        return structure;
    }

    public static void applyRandomProperties(Structure structure, double range, RandomSource random) {
        structure.structureLength = random.m_188501_() * 0.8f + 0.1f;
        structure.structureStart = random.m_188501_() * (1.0f - structure.structureLength);
        structure.x = Mth.m_14107_((double)((random.m_188500_() - random.m_188500_()) * range));
        structure.y = Mth.m_14107_((double)((random.m_188500_() - random.m_188500_()) * range));
        structure.z = Mth.m_14107_((double)((random.m_188500_() - random.m_188500_()) * range));
        structure.unifiedSeed = PandorasBoxHelper.getRandomUnifiedSeed(random);
    }

    public static class Structure {
        public float structureStart;
        public float structureLength;
        public int x;
        public int y;
        public int z;
        public int unifiedSeed;

        public Structure() {
        }

        public Structure(float structureStart, float structureLength, int x, int y, int z, int unifiedSeed) {
            this.structureStart = structureStart;
            this.structureLength = structureLength;
            this.x = x;
            this.y = y;
            this.z = z;
            this.unifiedSeed = unifiedSeed;
        }

        public void writeToNBT(CompoundTag compound) {
            compound.m_128350_("structureStart", this.structureStart);
            compound.m_128350_("structureLength", this.structureLength);
            compound.m_128405_("x", this.x);
            compound.m_128405_("y", this.y);
            compound.m_128405_("z", this.z);
            compound.m_128405_("unifiedSeed", this.unifiedSeed);
        }

        public void readFromNBT(CompoundTag compound) {
            this.structureStart = compound.m_128457_("structureStart");
            this.structureLength = compound.m_128457_("structureLength");
            this.x = compound.m_128451_("x");
            this.y = compound.m_128451_("y");
            this.z = compound.m_128451_("z");
            this.unifiedSeed = compound.m_128451_("unifiedSeed");
        }
    }
}

