/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectRegistry;
import ivorius.pandorasbox.effects.Vec3d;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class PBEffectMulti
extends PBEffect {
    public PBEffect[] effects;
    public int[] delays;

    public PBEffectMulti() {
    }

    public PBEffectMulti(PBEffect[] effects, int[] delays) {
        this.effects = effects;
        this.delays = delays;
    }

    @Override
    public void doTick(PandorasBoxEntity entity, Vec3d effectCenter, int ticksAlive) {
        for (int i = 0; i < this.effects.length; ++i) {
            int effectTicks = ticksAlive - this.delays[i];
            this.effects[i].doTick(entity, effectCenter, effectTicks);
        }
    }

    @Override
    public boolean isDone(PandorasBoxEntity entity, int ticksAlive) {
        for (int i = 0; i < this.effects.length; ++i) {
            int effectTicks = ticksAlive - this.delays[i];
            if (this.effects[i].isDone(entity, effectTicks)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void writeToNBT(CompoundTag compound) {
        ListTag list = new ListTag();
        for (int i = 0; i < this.effects.length; ++i) {
            CompoundTag cmp = new CompoundTag();
            cmp.m_128405_("delay", this.delays[i]);
            cmp.m_128359_("pbEffectID", this.effects[i].getEffectID());
            CompoundTag effectCmp = new CompoundTag();
            this.effects[i].writeToNBT(effectCmp);
            cmp.m_128365_("pbEffectCompound", (Tag)effectCmp);
            list.add((Object)cmp);
        }
        compound.m_128365_("effects", (Tag)list);
    }

    @Override
    public void readFromNBT(CompoundTag compound) {
        ListTag list = compound.m_128437_("effects", 10);
        this.effects = new PBEffect[list.size()];
        this.delays = new int[this.effects.length];
        for (int i = 0; i < this.effects.length; ++i) {
            CompoundTag cmp = list.m_128728_(i);
            this.delays[i] = cmp.m_128451_("delay");
            this.effects[i] = PBEffectRegistry.loadEffect(cmp.m_128461_("pbEffectID"), cmp.m_128469_("pbEffectCompound"));
        }
    }

    @Override
    public boolean canGenerateMoreEffectsAfterwards(PandorasBoxEntity entity) {
        for (PBEffect effect : this.effects) {
            if (effect.canGenerateMoreEffectsAfterwards(entity)) continue;
            return false;
        }
        return true;
    }
}

