/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.Vec3d;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;

public abstract class PBEffectNormal
extends PBEffect {
    public int maxTicksAlive;

    public PBEffectNormal() {
    }

    public PBEffectNormal(int maxTicksAlive) {
        this.maxTicksAlive = maxTicksAlive;
    }

    public float getRatioDone(int ticks) {
        if (ticks == this.maxTicksAlive) {
            return 1.0f;
        }
        return (float)ticks / (float)this.maxTicksAlive;
    }

    public abstract void doEffect(Level var1, PandorasBoxEntity var2, Vec3d var3, RandomSource var4, float var5, float var6);

    public void setUpEffect(Level world, PandorasBoxEntity entity, Vec3d effectCenter, RandomSource random) {
    }

    public void finalizeEffect(Level world, PandorasBoxEntity entity, Vec3d effectCenter, RandomSource random) {
    }

    @Override
    public void doTick(PandorasBoxEntity entity, Vec3d effectCenter, int ticksAlive) {
        float prevRatio = this.getRatioDone(ticksAlive);
        float newRatio = this.getRatioDone(ticksAlive + 1);
        if (ticksAlive == 0) {
            this.setUpEffect(entity.m_9236_(), entity, effectCenter, entity.getRandom());
        }
        if (prevRatio >= 0.0f && newRatio <= 1.0f && newRatio > prevRatio) {
            this.doEffect(entity.m_9236_(), entity, effectCenter, entity.getRandom(), prevRatio, newRatio);
        }
        if (ticksAlive == this.maxTicksAlive - 1) {
            this.finalizeEffect(entity.m_9236_(), entity, effectCenter, entity.getRandom());
        }
    }

    @Override
    public boolean isDone(PandorasBoxEntity entity, int ticksAlive) {
        return ticksAlive >= this.maxTicksAlive;
    }

    @Override
    public void writeToNBT(CompoundTag compound) {
        compound.m_128405_("maxTicksAlive", this.maxTicksAlive);
    }

    @Override
    public void readFromNBT(CompoundTag compound) {
        this.maxTicksAlive = compound.m_128451_("maxTicksAlive");
    }

    @Override
    public boolean canGenerateMoreEffectsAfterwards(PandorasBoxEntity entity) {
        return true;
    }
}

