/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectNormal;
import ivorius.pandorasbox.effects.Vec3d;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;

public abstract class PBEffectPositionBased
extends PBEffectNormal {
    public int number;
    public double range;

    public PBEffectPositionBased() {
    }

    public PBEffectPositionBased(int time, int number, double range) {
        super(time);
        this.number = number;
        this.range = range;
    }

    @Override
    public void doEffect(Level world, PandorasBoxEntity entity, Vec3d effectCenter, RandomSource random, float prevRatio, float newRatio) {
        int prev = this.getSpawnNumber(prevRatio);
        int toSpawn = this.getSpawnNumber(newRatio) - prev;
        for (int i = 0; i < toSpawn; ++i) {
            double eX = effectCenter.f_82479_ + (random.m_188500_() - random.m_188500_()) * this.range;
            double eY = effectCenter.f_82480_ + (random.m_188500_() - random.m_188500_()) * 3.0 * 2.0;
            double eZ = effectCenter.f_82481_ + (random.m_188500_() - random.m_188500_()) * this.range;
            this.doEffect(world, entity, random, newRatio, prevRatio, eX, eY, eZ);
        }
    }

    public abstract void doEffect(Level var1, PandorasBoxEntity var2, RandomSource var3, float var4, float var5, double var6, double var8, double var10);

    private int getSpawnNumber(float ratio) {
        return Mth.m_14143_((float)(ratio * (float)this.number));
    }

    @Override
    public void writeToNBT(CompoundTag compound) {
        super.writeToNBT(compound);
        compound.m_128405_("number", this.number);
        compound.m_128347_("range", this.range);
    }

    @Override
    public void readFromNBT(CompoundTag compound) {
        super.readFromNBT(compound);
        this.number = compound.m_128451_("number");
        this.range = compound.m_128459_("range");
    }
}

