/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectNormal;
import ivorius.pandorasbox.effects.Vec3d;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.math.IvMathHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;

public abstract class PBEffectRangeBased
extends PBEffectNormal {
    public double range;
    public int passes;
    public boolean spreadSquared = true;
    public boolean easeInOut = true;

    public PBEffectRangeBased() {
    }

    public PBEffectRangeBased(int maxTicksAlive, double range, int passes) {
        super(maxTicksAlive);
        this.range = range;
        this.passes = passes;
    }

    @Override
    public void doEffect(Level world, PandorasBoxEntity entity, Vec3d effectCenter, RandomSource random, float prevRatio, float newRatio) {
        for (int i = 0; i < this.passes; ++i) {
            double prevRange = this.getRange(prevRatio, i);
            double newRange = this.getRange(newRatio, i);
            this.generateInRange(world, entity, random, effectCenter, prevRange, newRange, i);
        }
    }

    private double getRange(double ratio, int pass) {
        if (this.spreadSquared) {
            ratio = Math.sqrt(ratio);
        }
        if (this.easeInOut) {
            ratio = IvMathHelper.mixEaseInOut(0.0, 1.0, ratio);
        }
        double fullRange = this.range + (double)(this.passes - 1) * 5.0;
        double tempRange = ratio * fullRange - (double)pass * 5.0;
        return Mth.m_14008_((double)tempRange, (double)0.0, (double)this.range);
    }

    public abstract void generateInRange(Level var1, PandorasBoxEntity var2, RandomSource var3, Vec3d var4, double var5, double var7, int var9);

    @Override
    public void writeToNBT(CompoundTag compound) {
        super.writeToNBT(compound);
        compound.m_128347_("range", this.range);
        compound.m_128405_("passes", this.passes);
        compound.m_128379_("spreadSquared", this.spreadSquared);
        compound.m_128379_("easeInOut", this.easeInOut);
    }

    @Override
    public void readFromNBT(CompoundTag compound) {
        super.readFromNBT(compound);
        this.range = compound.m_128459_("range");
        this.passes = compound.m_128451_("passes");
        this.spreadSquared = compound.m_128471_("spreadSquared");
        this.easeInOut = compound.m_128471_("easeInOut");
    }
}

