/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffect;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class PBEffectRegistry {
    private static Hashtable<String, Class<? extends PBEffect>> registeredEffects = new Hashtable();
    public static final List<ResourceLocation> resourceLocationList = new ArrayList<ResourceLocation>();

    public static Class<? extends PBEffect> getEffect(String id) {
        return registeredEffects.get(id);
    }

    public static void register(Class<? extends PBEffect> effect, String id) {
        id = id.toLowerCase();
        resourceLocationList.add(new ResourceLocation("pandorasbox", id));
        registeredEffects.put(id, effect);
    }

    public static Set<String> getAllEffectIDs() {
        return registeredEffects.keySet();
    }

    public static Collection<Class<? extends PBEffect>> getAllEffects() {
        return registeredEffects.values();
    }

    public static void writeEffect(PBEffect effect, CompoundTag compound) {
        if (effect != null) {
            compound.m_128359_("pbEffectID", effect.getEffectID());
            CompoundTag pbEffectCompound = new CompoundTag();
            effect.writeToNBT(pbEffectCompound);
            compound.m_128365_("pbEffectCompound", (Tag)pbEffectCompound);
        }
    }

    public static PBEffect loadEffect(CompoundTag compound) {
        return PBEffectRegistry.loadEffect(compound.m_128461_("pbEffectID"), compound.m_128469_("pbEffectCompound"));
    }

    public static PBEffect loadEffect(String id, CompoundTag compound) {
        Class<? extends PBEffect> clazz = PBEffectRegistry.getEffect(id);
        PBEffect effect = null;
        if (clazz != null) {
            try {
                effect = clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        if (effect != null && compound != null) {
            effect.readFromNBT(compound);
            return effect;
        }
        System.err.println("Pandoras Box: Could not load effect with id '" + id + "'!");
        return null;
    }

    public static String getEffectID(PBEffect effect) {
        Class<?> clazz = effect.getClass();
        for (String id : registeredEffects.keySet()) {
            if (!registeredEffects.get(id).equals(clazz)) continue;
            return id;
        }
        return null;
    }
}

