/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectNormal;
import ivorius.pandorasbox.effects.Vec3d;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public abstract class PBEffectSpawnEntities
extends PBEffectNormal {
    public int number;
    public boolean spawnFromBox;
    public double range;
    public double shiftY;
    public double throwStrengthSideMin;
    public double throwStrengthSideMax;
    public double throwStrengthYMin;
    public double throwStrengthYMax;

    public PBEffectSpawnEntities() {
    }

    public PBEffectSpawnEntities(int time, int number) {
        super(time);
        this.number = number;
    }

    public void setDoesNotSpawnFromBox(double range, double shiftY) {
        this.spawnFromBox = false;
        this.range = range;
        this.shiftY = shiftY;
    }

    public void setDoesSpawnFromBox(double throwStrengthSideMin, double throwStrengthSideMax, double throwStrengthYMin, double throwStrengthYMax) {
        this.spawnFromBox = true;
        this.throwStrengthSideMin = throwStrengthSideMin;
        this.throwStrengthSideMax = throwStrengthSideMax;
        this.throwStrengthYMin = throwStrengthYMin;
        this.throwStrengthYMax = throwStrengthYMax;
    }

    @Override
    public void doEffect(Level world, PandorasBoxEntity box, Vec3d effectCenter, RandomSource random, float prevRatio, float newRatio) {
        if (world instanceof ServerLevel) {
            int prev = this.getSpawnNumber(prevRatio);
            int toSpawn = this.getSpawnNumber(newRatio) - prev;
            for (int i = 0; i < toSpawn; ++i) {
                double eZ;
                double eY;
                double eX;
                if (this.spawnFromBox) {
                    eX = box.m_20185_();
                    eY = box.m_20186_();
                    eZ = box.m_20189_();
                } else {
                    eX = box.m_20185_() + (random.m_188500_() - random.m_188500_()) * this.range;
                    eY = box.m_20186_() + (random.m_188500_() - random.m_188500_()) * 3.0 + this.shiftY;
                    eZ = box.m_20189_() + (random.m_188500_() - random.m_188500_()) * this.range;
                }
                Entity newEntity = this.spawnEntity(world, box, random, prev + i, eX, eY, eZ);
                if (newEntity == null || !this.spawnFromBox || newEntity instanceof LivingEntity) continue;
                float dirSide = random.m_188501_() * 2.0f * 3.1415925f;
                double throwStrengthSide = this.throwStrengthSideMin + random.m_188500_() * (this.throwStrengthSideMax - this.throwStrengthSideMin);
                newEntity.m_5997_((double)Mth.m_14031_((float)dirSide) * throwStrengthSide, this.throwStrengthYMin + random.m_188500_() * (this.throwStrengthYMax - this.throwStrengthYMin), (double)Mth.m_14089_((float)dirSide) * throwStrengthSide);
                newEntity.f_19864_ = true;
            }
        }
    }

    private int getSpawnNumber(float ratio) {
        return Mth.m_14143_((float)(ratio * (float)this.number));
    }

    public abstract Entity spawnEntity(Level var1, PandorasBoxEntity var2, RandomSource var3, int var4, double var5, double var7, double var9);

    @Override
    public void writeToNBT(CompoundTag compound) {
        super.writeToNBT(compound);
        compound.m_128405_("number", this.number);
        compound.m_128379_("spawnFromBox", this.spawnFromBox);
        compound.m_128347_("range", this.range);
        compound.m_128347_("shiftY", this.shiftY);
        compound.m_128347_("throwStrengthSideMin", this.throwStrengthSideMin);
        compound.m_128347_("throwStrengthSideMax", this.throwStrengthSideMax);
        compound.m_128347_("throwStrengthYMin", this.throwStrengthYMin);
        compound.m_128347_("throwStrengthYMax", this.throwStrengthYMax);
    }

    @Override
    public void readFromNBT(CompoundTag compound) {
        super.readFromNBT(compound);
        this.number = compound.m_128451_("number");
        this.spawnFromBox = compound.m_128471_("spawnFromBox");
        this.range = compound.m_128459_("range");
        this.shiftY = compound.m_128459_("shiftY");
        this.throwStrengthSideMin = compound.m_128459_("throwStrengthSideMin");
        this.throwStrengthSideMax = compound.m_128459_("throwStrengthSideMax");
        this.throwStrengthYMin = compound.m_128459_("throwStrengthYMin");
        this.throwStrengthYMax = compound.m_128459_("throwStrengthYMax");
    }
}

