/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.PandorasBoxHelper;
import ivorius.pandorasbox.effects.PBEffectSpawnEntities;
import ivorius.pandorasbox.entitites.PandorasBoxEntity;
import ivorius.pandorasbox.random.PandorasBoxEntityNamer;
import ivorius.pandorasbox.utils.PBNBTHelper;
import ivorius.pandorasbox.utils.StringConverter;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class PBEffectSpawnEntityIDList
extends PBEffectSpawnEntities {
    public String[][] entityIDs;
    public int nameEntities;
    public int equipLevel;
    public int buffLevel;

    public PBEffectSpawnEntityIDList() {
    }

    public PBEffectSpawnEntityIDList(int time, String[] entityIDs, int nameEntities, int equipLevel, int buffLevel) {
        super(time, entityIDs.length);
        this.entityIDs = this.get2DStringArray(entityIDs);
        this.nameEntities = nameEntities;
        this.equipLevel = equipLevel;
        this.buffLevel = buffLevel;
    }

    public PBEffectSpawnEntityIDList(int time, String[][] entityIDs, int nameEntities, int equipLevel, int buffLevel) {
        super(time, entityIDs.length);
        this.entityIDs = entityIDs;
        this.nameEntities = nameEntities;
        this.equipLevel = equipLevel;
        this.buffLevel = buffLevel;
    }

    private String[][] get2DStringArray(String[] strings) {
        String[][] result = new String[strings.length][1];
        for (int i = 0; i < strings.length; ++i) {
            result[i][0] = strings[i];
        }
        return result;
    }

    @Override
    public Entity spawnEntity(Level world, PandorasBoxEntity pbEntity, RandomSource random, int number, double x, double y, double z) {
        if (world.m_5776_()) {
            return null;
        }
        String[] entityTower = this.entityIDs[number];
        Entity previousEntity = null;
        for (String entityID : entityTower) {
            Entity newEntity = PBEffectSpawnEntityIDList.createEntity(world, pbEntity, random, entityID, x, y, z);
            if (newEntity instanceof LivingEntity) {
                PBEffectSpawnEntityIDList.randomizeEntity(random, pbEntity.m_19879_(), (LivingEntity)newEntity, this.nameEntities, this.equipLevel, this.buffLevel);
            }
            if (previousEntity != null) {
                world.m_7967_(previousEntity);
                assert (newEntity != null);
                previousEntity.m_7998_(newEntity, true);
            }
            previousEntity = newEntity;
        }
        if (previousEntity != null) {
            world.m_7967_(previousEntity);
        }
        return previousEntity;
    }

    public static void randomizeEntity(RandomSource random, long namingSeed, LivingEntity entityLiving, int nameEntities, int equipLevel, int buffLevel) {
        if (nameEntities == 1) {
            entityLiving.m_6593_(PandorasBoxEntityNamer.getRandomName(random));
            entityLiving.m_20340_(true);
        } else if (nameEntities == 2) {
            entityLiving.m_6593_(PandorasBoxEntityNamer.getRandomCasualName(random));
        } else if (nameEntities == 3) {
            entityLiving.m_6593_(PandorasBoxEntityNamer.getRandomCasualName(RandomSource.m_216335_((long)namingSeed)));
        }
        if (equipLevel > 0) {
            float itemChancePerSlot = 1.0f - 0.5f / (float)equipLevel;
            float upgradeChancePerSlot = 1.0f - 1.0f / (float)equipLevel;
            for (int i = 0; i < 5; ++i) {
                int itemLevel;
                if (!(random.m_188501_() < itemChancePerSlot)) continue;
                for (itemLevel = 0; random.m_188501_() < upgradeChancePerSlot && itemLevel < equipLevel; ++itemLevel) {
                }
                if (i == 0) {
                    ItemStack itemStack = PandorasBoxHelper.getRandomWeaponItemForLevel(random, itemLevel);
                    if (itemStack == null) {
                        itemStack = ItemStack.f_41583_;
                    }
                    entityLiving.m_8061_(EquipmentSlot.MAINHAND, itemStack);
                    continue;
                }
                if (i == 4 && random.m_188501_() < 0.2f / (float)equipLevel) {
                    entityLiving.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)(random.m_188501_() < 0.1f ? Blocks.f_50144_ : Blocks.f_50133_)));
                    continue;
                }
                EquipmentSlot slot = i == 1 ? EquipmentSlot.LEGS : (i == 2 ? EquipmentSlot.FEET : EquipmentSlot.CHEST);
                Item item = Mob.m_21412_((EquipmentSlot)slot, (int)Math.min(itemLevel, 4));
                if (item != null) {
                    entityLiving.m_8061_(slot, new ItemStack((ItemLike)item));
                    continue;
                }
                System.err.println("Pandora's Box: Item not found for slot '" + slot + "', level '" + itemLevel + "'");
            }
        }
        if (buffLevel > 0) {
            AttributeInstance attackDamage;
            AttributeInstance movementSpeed;
            AttributeInstance knockbackResistance;
            AttributeInstance health = entityLiving.m_21051_(Attributes.f_22276_);
            if (health != null) {
                double healthMultiplierP = random.m_188500_() * (double)buffLevel * 0.25;
                health.m_22125_(new AttributeModifier("Zeus's magic", healthMultiplierP, AttributeModifier.Operation.m_22236_((int)1)));
            }
            if ((knockbackResistance = entityLiving.m_21051_(Attributes.f_22278_)) != null) {
                double knockbackResistanceP = random.m_188500_() * (double)buffLevel * 0.25;
                knockbackResistance.m_22125_(new AttributeModifier("Zeus's magic", knockbackResistanceP, AttributeModifier.Operation.m_22236_((int)1)));
            }
            if ((movementSpeed = entityLiving.m_21051_(Attributes.f_22279_)) != null) {
                double movementSpeedP = random.m_188500_() * (double)buffLevel * 0.08;
                movementSpeed.m_22125_(new AttributeModifier("Zeus's magic", movementSpeedP, AttributeModifier.Operation.m_22236_((int)1)));
            }
            if ((attackDamage = entityLiving.m_21051_(Attributes.f_22281_)) != null) {
                double attackDamageP = random.m_188500_() * (double)buffLevel * 0.25;
                attackDamage.m_22125_(new AttributeModifier("Zeus's magic", attackDamageP, AttributeModifier.Operation.m_22236_((int)1)));
            }
        }
    }

    public static Entity createEntity(Level world, PandorasBoxEntity pbEntity, RandomSource random, String entityID, double x, double y, double z) {
        try {
            if ("pbspecial_XP".equals(entityID)) {
                ExperienceOrb entity = (ExperienceOrb)EntityType.f_20570_.m_20615_(world);
                assert (entity != null);
                entity.f_20770_ = 10;
                return entity;
            }
            if ("pbspecial_wolfTamed".equals(entityID)) {
                Player nearest = PBEffectSpawnEntityIDList.getPlayer(world, pbEntity);
                Wolf wolf = (Wolf)EntityType.f_20499_.m_20615_(world);
                assert (wolf != null);
                wolf.m_7678_(x, y, z, random.m_188501_() * 360.0f, 0.0f);
                if (nearest != null) {
                    ForgeEventFactory.onFinalizeSpawn((Mob)wolf, (ServerLevelAccessor)((ServerLevel)world), (DifficultyInstance)world.m_6436_(BlockPos.m_274561_((double)x, (double)y, (double)z)), (MobSpawnType)MobSpawnType.NATURAL, null, null);
                    wolf.m_21573_().m_26573_();
                    wolf.m_6710_(null);
                    wolf.m_21828_(nearest);
                    wolf.m_9236_().m_7605_((Entity)wolf, (byte)7);
                }
                return wolf;
            }
            if ("pbspecial_ocelotTamed".equals(entityID)) {
                Player nearest = PBEffectSpawnEntityIDList.getPlayer(world, pbEntity);
                Cat ocelot = (Cat)EntityType.f_20553_.m_20615_(world);
                assert (ocelot != null);
                ocelot.m_7678_(x, y, z, random.m_188501_() * 360.0f, 0.0f);
                if (nearest != null) {
                    ForgeEventFactory.onFinalizeSpawn((Mob)ocelot, (ServerLevelAccessor)((ServerLevel)world), (DifficultyInstance)world.m_6436_(BlockPos.m_274561_((double)x, (double)y, (double)z)), (MobSpawnType)MobSpawnType.NATURAL, null, null);
                    ocelot.m_21828_(nearest);
                    world.m_7605_((Entity)ocelot, (byte)7);
                }
                return ocelot;
            }
            if (entityID.startsWith("pbspecial_tnt")) {
                PrimedTnt entitytntprimed = (PrimedTnt)EntityType.f_20515_.m_20615_(world);
                assert (entitytntprimed != null);
                entitytntprimed.m_6034_(x, y, z);
                entitytntprimed.m_32085_(Integer.parseInt(entityID.substring(13)));
                return entitytntprimed;
            }
            if ("pbspecial_invisibleTnt".startsWith(entityID)) {
                PrimedTnt entitytntprimed = (PrimedTnt)EntityType.f_20515_.m_20615_(world);
                assert (entitytntprimed != null);
                entitytntprimed.m_6034_(x, y, z);
                entitytntprimed.m_32085_(Integer.parseInt(entityID.substring(22)));
                entitytntprimed.m_6842_(true);
                return entitytntprimed;
            }
            if ("pbspecial_firework".equals(entityID)) {
                ItemStack stack = new ItemStack((ItemLike)Items.f_42688_);
                stack.m_41700_("Fireworks", (Tag)PBEffectSpawnEntityIDList.createRandomFirework(random));
                FireworkRocketEntity fireworkRocket = (FireworkRocketEntity)EntityType.f_20451_.m_20615_(world);
                assert (fireworkRocket != null);
                fireworkRocket.m_6034_(x, y, z);
                fireworkRocket.m_20088_().m_135381_(PBEffectSpawnEntityIDList.fireworkStackParameter(), (Object)stack);
                return fireworkRocket;
            }
            if ("pbspecial_angryWolf".equals(entityID)) {
                Wolf wolf = (Wolf)EntityType.f_20499_.m_20615_(world);
                assert (wolf != null);
                ForgeEventFactory.onFinalizeSpawn((Mob)wolf, (ServerLevelAccessor)((ServerLevel)world), (DifficultyInstance)world.m_6436_(BlockPos.m_274561_((double)x, (double)y, (double)z)), (MobSpawnType)MobSpawnType.NATURAL, null, null);
                wolf.m_7678_(x, y, z, random.m_188501_() * 360.0f, 0.0f);
                wolf.m_6710_((LivingEntity)world.m_45924_(x, y, z, 40.0, false));
                return wolf;
            }
            if ("pbspecial_superchargedCreeper".equals(entityID)) {
                Creeper creeper = (Creeper)EntityType.f_20558_.m_20615_(world);
                assert (creeper != null);
                ForgeEventFactory.onFinalizeSpawn((Mob)creeper, (ServerLevelAccessor)((ServerLevel)world), (DifficultyInstance)world.m_6436_(BlockPos.m_274561_((double)x, (double)y, (double)z)), (MobSpawnType)MobSpawnType.NATURAL, null, null);
                creeper.m_7678_(x, y, z, random.m_188501_() * 360.0f, 0.0f);
                creeper.m_20088_().m_135381_(PBEffectSpawnEntityIDList.creeperPoweredParameter(), (Object)true);
                return creeper;
            }
            if ("pbspecial_skeletonWither".equals(entityID)) {
                WitherSkeleton skeleton = (WitherSkeleton)EntityType.f_20497_.m_20615_(world);
                assert (skeleton != null);
                ForgeEventFactory.onFinalizeSpawn((Mob)skeleton, (ServerLevelAccessor)((ServerLevel)world), (DifficultyInstance)world.m_6436_(BlockPos.m_274561_((double)x, (double)y, (double)z)), (MobSpawnType)MobSpawnType.NATURAL, null, null);
                skeleton.m_7678_(x, y, z, random.m_188501_() * 360.0f, 0.0f);
                skeleton.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42425_));
                skeleton.m_21051_(Attributes.f_22281_).m_22100_(4.0);
                return skeleton;
            }
            if ("pbspecial_elderGuardian".equals(entityID)) {
                ElderGuardian entity = (ElderGuardian)EntityType.f_20563_.m_20615_(world);
                assert (entity != null);
                ForgeEventFactory.onFinalizeSpawn((Mob)entity, (ServerLevelAccessor)((ServerLevel)world), (DifficultyInstance)world.m_6436_(BlockPos.m_274561_((double)x, (double)y, (double)z)), (MobSpawnType)MobSpawnType.NATURAL, null, null);
                entity.m_7678_(x, y, z, random.m_188501_() * 360.0f, 0.0f);
                return entity;
            }
            entityID = StringConverter.convertCamelCase(entityID);
            EntityType entity = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(entityID));
            assert (entity != null);
            Entity entity1 = entity.m_20615_(world);
            assert (entity1 != null);
            entity1.m_7678_(x, y, z, random.m_188501_() * 360.0f, 0.0f);
            if (entity1 instanceof AbstractPiglin) {
                AbstractPiglin piglin = (AbstractPiglin)entity1;
                piglin.m_34670_(true);
            }
            if (entity1 instanceof Hoglin) {
                Hoglin hoglin = (Hoglin)entity1;
                hoglin.m_34564_(true);
            }
            if (entity1 instanceof Mob) {
                Mob mob = (Mob)entity1;
                ForgeEventFactory.onFinalizeSpawn((Mob)mob, (ServerLevelAccessor)((ServerLevel)world), (DifficultyInstance)world.m_6436_(BlockPos.m_274561_((double)x, (double)y, (double)z)), (MobSpawnType)MobSpawnType.NATURAL, null, null);
            }
            return entity1;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static EntityDataAccessor<Boolean> creeperPoweredParameter() throws IllegalAccessException {
        return (EntityDataAccessor)ObfuscationReflectionHelper.findField(Creeper.class, (String)"f_32274_").get(null);
    }

    private static EntityDataAccessor<ItemStack> fireworkStackParameter() throws IllegalAccessException {
        return (EntityDataAccessor)ObfuscationReflectionHelper.findField(FireworkRocketEntity.class, (String)"f_37019_").get(null);
    }

    public static CompoundTag createRandomFirework(RandomSource random) {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_("Explosions", (Tag)PBEffectSpawnEntityIDList.createRandomFireworkExplosions(random, random.m_188503_(20) != 0 ? 1 : 1 + random.m_188503_(2)));
        compound.m_128344_("Flight", (byte)(random.m_188503_(15) != 0 ? 1 : 2 + random.m_188503_(2)));
        return compound;
    }

    public static ListTag createRandomFireworkExplosions(RandomSource random, int number) {
        ListTag list = new ListTag();
        for (int i = 0; i < number; ++i) {
            list.add((Object)PBEffectSpawnEntityIDList.createRandomFireworkExplosion(random));
        }
        return list;
    }

    public static CompoundTag createRandomFireworkExplosion(RandomSource random) {
        CompoundTag fireworkCompound = new CompoundTag();
        fireworkCompound.m_128379_("Flicker", random.m_188503_(20) == 0);
        fireworkCompound.m_128379_("Trail", random.m_188503_(30) == 0);
        fireworkCompound.m_128344_("Type", (byte)(random.m_188503_(10) != 0 ? 0 : random.m_188503_(4) + 1));
        int[] colors = new int[random.m_188503_(15) != 0 ? 1 : random.m_188503_(2) + 2];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = DyeColor.m_41053_((int)random.m_188503_(16)).ordinal();
        }
        fireworkCompound.m_128385_("Colors", colors);
        if (random.m_188503_(25) == 0) {
            int[] fadeColors = new int[random.m_188503_(2) + 1];
            for (int i = 0; i < fadeColors.length; ++i) {
                fadeColors[i] = DyeColor.m_41053_((int)random.m_188503_(16)).ordinal();
            }
            fireworkCompound.m_128385_("FadeColors", fadeColors);
        }
        return fireworkCompound;
    }

    @Override
    public void writeToNBT(CompoundTag compound) {
        super.writeToNBT(compound);
        PBNBTHelper.writeNBTStrings2D("entityIDs", this.entityIDs, compound);
        compound.m_128405_("nameEntities", this.nameEntities);
        compound.m_128405_("equipLevel", this.equipLevel);
        compound.m_128405_("buffLevel", this.buffLevel);
    }

    @Override
    public void readFromNBT(CompoundTag compound) {
        super.readFromNBT(compound);
        this.entityIDs = PBNBTHelper.readNBTStrings2D("entityIDs", compound);
        this.nameEntities = compound.m_128451_("nameEntities");
        this.equipLevel = compound.m_128451_("equipLevel");
        this.buffLevel = compound.m_128451_("buffLevel");
    }
}

