/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.entitites;

import ivorius.pandorasbox.PBConfig;
import ivorius.pandorasbox.effectcreators.PBECDuplicateBox;
import ivorius.pandorasbox.effectcreators.PBECRegistry;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectRegistry;
import ivorius.pandorasbox.effects.Vec3d;
import ivorius.pandorasbox.network.PartialUpdateHandler;
import ivorius.pandorasbox.random.DConstant;
import ivorius.pandorasbox.random.IConstant;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

public class PandorasBoxEntity
extends Entity
implements IEntityAdditionalSpawnData,
PartialUpdateHandler {
    public static final float BOX_UPSCALE_SPEED = 0.02f;
    private static final EntityDataAccessor<Integer> BOX_DEATH_TICKS = SynchedEntityData.m_135353_(PandorasBoxEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected int timeBoxWaiting;
    protected int effectTicksExisted;
    protected boolean canGenerateMoreEffectsAfterwards = true;
    protected PBEffect boxEffect;
    protected boolean floatUp = false;
    protected float floatAwayProgress = -1.0f;
    public static final EntityDataSerializer<PBEffect> PBEFFECT_SERIALIZER = new EntityDataSerializer<PBEffect>(){

        public void write(FriendlyByteBuf p_135025_, PBEffect p_135026_) {
            CompoundTag compound = new CompoundTag();
            CompoundTag effectCompound = new CompoundTag();
            PBEffectRegistry.writeEffect(p_135026_, effectCompound);
            compound.m_128365_("boxEffect", (Tag)effectCompound);
            p_135025_.m_130079_(compound);
        }

        public PBEffect read(FriendlyByteBuf p_135024_) {
            return PBEffectRegistry.loadEffect(p_135024_.m_130260_().m_128469_("boxEffect"));
        }

        public PBEffect copy(PBEffect p_192717_1_) {
            return p_192717_1_;
        }
    };
    protected float scaleInProgress = 1.0f;
    private static final EntityDataAccessor<PBEffect> DATA_EFFECT_ID = SynchedEntityData.m_135353_(PandorasBoxEntity.class, PBEFFECT_SERIALIZER);
    protected Vec3d effectCenter = new Vec3d(0.0, 0.0, 0.0);

    public PandorasBoxEntity(EntityType<? extends PandorasBoxEntity> p_i50172_1_, Level p_i50172_2_) {
        super(p_i50172_1_, p_i50172_2_);
    }

    public int getTimeBoxWaiting() {
        return this.timeBoxWaiting;
    }

    public boolean m_7337_(Entity p_241849_1_) {
        return false;
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public void setTimeBoxWaiting(int timeBoxWaiting) {
        this.timeBoxWaiting = timeBoxWaiting;
    }

    public int getEffectTicksExisted() {
        return this.effectTicksExisted;
    }

    public void setEffectTicksExisted(int effectTicksExisted) {
        this.effectTicksExisted = effectTicksExisted;
    }

    public boolean canGenerateMoreEffectsAfterwards() {
        return this.canGenerateMoreEffectsAfterwards;
    }

    public void setCanGenerateMoreEffectsAfterwards(boolean canGenerateMoreEffectsAfterwards) {
        this.canGenerateMoreEffectsAfterwards = canGenerateMoreEffectsAfterwards;
    }

    public boolean floatUp() {
        return this.floatUp;
    }

    public void setFloatUp(boolean floatUp) {
        this.floatUp = floatUp;
    }

    public float getFloatAwayProgress() {
        return this.floatAwayProgress;
    }

    public void setFloatAwayProgress(float floatAwayProgress) {
        this.floatAwayProgress = floatAwayProgress;
    }

    public Vec3d getEffectCenter() {
        return this.effectCenter;
    }

    public void setEffectCenter(double x, double y, double z) {
        this.effectCenter = new Vec3d(x, y, z);
    }

    public float getCurrentScale() {
        return this.scaleInProgress;
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(BOX_DEATH_TICKS, (Object)-1);
        this.m_20088_().m_135372_(DATA_EFFECT_ID, (Object)new PBECDuplicateBox(new IConstant(0), new DConstant(0.5)).constructEffect(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.f_19796_));
    }

    public void m_8119_() {
        Level level = this.m_9236_();
        super.m_8119_();
        if (this.timeBoxWaiting == 0 && this.getDeathTicks() < 0) {
            PBEffect effect = this.getBoxEffect();
            if (effect == null) {
                if (level instanceof ServerLevel) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            } else if (effect.isDone(this, this.effectTicksExisted)) {
                if (level instanceof ServerLevel) {
                    boolean isCompletelyDone = true;
                    if (this.canGenerateMoreEffectsAfterwards && effect.canGenerateMoreEffectsAfterwards(this) && (double)this.f_19796_.m_188501_() < PBConfig.boxLongevity) {
                        this.startNewEffect();
                        isCompletelyDone = false;
                    }
                    if (isCompletelyDone) {
                        this.startFadingOut();
                    }
                }
            } else {
                if (this.effectTicksExisted == 0) {
                    this.setEffectCenter(this.m_20185_(), this.m_20186_(), this.m_20189_());
                }
                effect.doTick(this, this.effectCenter, this.effectTicksExisted);
            }
        }
        if (this.timeBoxWaiting == 0) {
            this.m_20256_(this.m_20184_().m_82490_(0.5));
        } else {
            this.m_20256_(this.m_20184_().m_82490_(0.95));
        }
        if (this.floatAwayProgress >= 0.0f && this.floatAwayProgress < 1.0f) {
            float speed = Mth.m_14207_((float)(this.floatAwayProgress - 0.7f));
            if (this.floatUp) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, (double)(speed * 0.015f), 0.0));
            } else {
                this.m_19920_(0.4f, new Vec3d(-0.0, speed * 0.02f, -0.02f));
                this.m_20256_(this.m_20184_().m_82520_(0.0, (double)(speed * 0.015f), 0.0));
            }
            this.floatAwayProgress += 0.025f;
            if (this.floatAwayProgress > 1.0f) {
                this.stopFloating();
            }
        }
        if (this.scaleInProgress < 1.0f) {
            this.scaleInProgress += 0.02f;
        }
        if (this.scaleInProgress > 1.0f) {
            this.scaleInProgress = 1.0f;
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (this.timeBoxWaiting == 0) {
            if (this.getDeathTicks() < 0) {
                if (!this.m_20145_() && level.m_5776_()) {
                    double zP;
                    double yDir;
                    double xP;
                    int e;
                    double yCenter = this.m_20186_() + (double)this.m_20206_() * 0.5;
                    for (e = 0; e < 2; ++e) {
                        xP = (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.2;
                        yDir = this.f_19796_.m_188500_() * 0.1;
                        zP = (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.2;
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + xP, yCenter, this.m_20189_() + zP, 0.0, yDir, 0.0);
                    }
                    for (e = 0; e < 3; ++e) {
                        double xDir = (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 3.0;
                        yDir = this.f_19796_.m_188500_() * 4.0 + 2.0;
                        double zDir = (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 3.0;
                        double xP2 = (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_();
                        double zP2 = (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_();
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123809_, this.m_20185_() + xP2 + xDir, yCenter + yDir, this.m_20189_() + zP2 + zDir, -xDir, -yDir, -zDir);
                    }
                    for (e = 0; e < 4; ++e) {
                        xP = this.f_19796_.m_188500_() * 16.0 - 8.0;
                        double yP = this.f_19796_.m_188500_() * 5.0 - 2.0;
                        zP = this.f_19796_.m_188500_() * 16.0 - 8.0;
                        double xDir = this.f_19796_.m_188500_() * 2.0 - 1.0;
                        double yDir2 = this.f_19796_.m_188500_() * 2.0 - 1.0;
                        double zDir = this.f_19796_.m_188500_() * 2.0 - 1.0;
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20185_() + xP, yCenter + yP, this.m_20189_() + zP, xDir, yDir2, zDir);
                    }
                }
                ++this.effectTicksExisted;
            }
        } else {
            --this.timeBoxWaiting;
        }
        if (this.getDeathTicks() >= 0) {
            if (level instanceof ServerLevel) {
                if (this.getDeathTicks() >= 30) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            } else {
                for (int e = 0; e < Math.min(this.getDeathTicks(), 60); ++e) {
                    double xP = (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.5;
                    double yP = (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.5;
                    double zP = (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.5;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + xP, this.m_20186_() + yP, this.m_20189_() + zP, 0.0, 0.0, 0.0);
                }
            }
            this.setDeathTicks(this.getDeathTicks() + 1);
        }
    }

    public void startNewEffect() {
        this.effectTicksExisted = 0;
        this.timeBoxWaiting = this.f_19796_.m_188503_(40);
        this.boxEffect = this.ensureNotNull(PBECRegistry.createRandomEffect(this.m_9236_(), this.f_19796_, this.effectCenter.f_82479_, this.effectCenter.f_82480_, this.effectCenter.f_82481_, true));
        this.f_19804_.m_135381_(DATA_EFFECT_ID, (Object)this.boxEffect);
    }

    public void startFadingOut() {
        this.setDeathTicks(0);
    }

    public void beginFloatingAway() {
        this.floatAwayProgress = 0.0f;
        this.floatUp = false;
    }

    public void beginFloatingUp() {
        this.floatAwayProgress = 0.0f;
        this.floatUp = true;
    }

    public void stopFloating() {
        this.floatAwayProgress = -1.0f;
        this.effectTicksExisted = 0;
    }

    public void beginScalingIn() {
        this.scaleInProgress = 0.0f;
    }

    public PBEffect getBoxEffect() {
        return (PBEffect)this.f_19804_.m_135370_(DATA_EFFECT_ID);
    }

    public void setBoxEffect(PBEffect effect) {
        this.boxEffect = this.ensureNotNull(effect);
        this.f_19804_.m_135381_(DATA_EFFECT_ID, (Object)this.boxEffect);
    }

    public PBEffect ensureNotNull(PBEffect input) {
        while (input == null) {
            input = PBECRegistry.createRandomEffect(this.m_9236_(), this.f_19796_, this.effectCenter.f_82479_, this.effectCenter.f_82480_, this.effectCenter.f_82481_, true);
        }
        return input;
    }

    public RandomSource getRandom() {
        return this.f_19796_;
    }

    public int getDeathTicks() {
        return (Integer)this.m_20088_().m_135370_(BOX_DEATH_TICKS);
    }

    public void setDeathTicks(int deathTicks) {
        this.m_20088_().m_135381_(BOX_DEATH_TICKS, (Object)deathTicks);
    }

    public float getRatioBoxOpen(float partialTicks) {
        if (this.floatAwayProgress >= 0.0f) {
            return Mth.m_14036_((float)((this.floatAwayProgress + partialTicks * 0.025f - 0.5f) * 2.0f), (float)0.0f, (float)1.0f);
        }
        return 1.0f;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_7334_(Entity entityIn) {
    }

    public void m_7378_(CompoundTag compound) {
        this.readBoxData(compound);
    }

    public void m_7380_(CompoundTag compound) {
        this.writeBoxData(compound);
    }

    public void readBoxData(CompoundTag compound) {
        this.setBoxEffect(PBEffectRegistry.loadEffect(compound.m_128469_("boxEffect")));
        this.effectTicksExisted = compound.m_128451_("effectTicksExisted");
        this.timeBoxWaiting = compound.m_128451_("timeBoxWaiting");
        this.canGenerateMoreEffectsAfterwards = compound.m_128471_("canGenerateMoreEffectsAfterwards");
        this.floatAwayProgress = compound.m_128457_("floatAwayProgress");
        this.floatUp = compound.m_128471_("floatUp");
        this.scaleInProgress = compound.m_128457_("scaleInProgress");
        if (compound.m_128425_("effectCenterX", 6) && compound.m_128425_("effectCenterY", 6) && compound.m_128425_("effectCenterZ", 6)) {
            this.setEffectCenter(compound.m_128459_("effectCenterX"), compound.m_128459_("effectCenterY"), compound.m_128459_("effectCenterZ"));
        } else {
            this.setEffectCenter(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
    }

    public void writeBoxData(CompoundTag compound) {
        CompoundTag effectCompound = new CompoundTag();
        PBEffectRegistry.writeEffect(this.getBoxEffect(), effectCompound);
        compound.m_128365_("boxEffect", (Tag)effectCompound);
        compound.m_128405_("effectTicksExisted", this.effectTicksExisted);
        compound.m_128405_("timeBoxWaiting", this.timeBoxWaiting);
        compound.m_128379_("canGenerateMoreEffectsAfterwards", this.canGenerateMoreEffectsAfterwards);
        compound.m_128350_("floatAwayProgress", this.floatAwayProgress);
        compound.m_128379_("floatUp", this.floatUp);
        compound.m_128350_("scaleInProgress", this.scaleInProgress);
        compound.m_128347_("effectCenterX", this.effectCenter.f_82479_);
        compound.m_128347_("effectCenterY", this.effectCenter.f_82480_);
        compound.m_128347_("effectCenterZ", this.effectCenter.f_82481_);
    }

    @Override
    public void writeUpdateData(FriendlyByteBuf buffer, String context) {
        if (context.equals("boxEffect")) {
            CompoundTag compound = new CompoundTag();
            this.writeBoxData(compound);
            buffer.m_130079_(compound);
        }
    }

    @Override
    public void readUpdateData(FriendlyByteBuf buffer, String context) {
        CompoundTag compound;
        if (context.equals("boxEffect") && (compound = buffer.m_130260_()) != null) {
            this.readBoxData(compound);
        }
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        CompoundTag compound = new CompoundTag();
        this.writeBoxData(compound);
        buffer.m_130079_(compound);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        CompoundTag compound = additionalData.m_130260_();
        if (compound != null) {
            this.readBoxData(compound);
        }
    }
}

