/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.events;

import com.mojang.brigadier.CommandDispatcher;
import ivorius.pandorasbox.PandorasBox;
import ivorius.pandorasbox.commands.CommandPandorasBox;
import ivorius.pandorasbox.effects.PBEffects;
import ivorius.pandorasbox.utils.ArrayListExtensions;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="pandorasbox", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PBEventHandler {
    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onCommandRegister(RegisterCommandsEvent evt) {
        new CommandPandorasBox((CommandDispatcher<CommandSourceStack>)evt.getDispatcher());
    }

    @SubscribeEvent
    public void onPlayerInteractAir(PlayerInteractEvent.RightClickEmpty event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            BlockPos pos = event.getEntity().m_20183_();
            Direction direction = event.getEntity().m_6350_();
            BlockPos frontPos = this.getPosInFront(pos, direction);
            ((BlockItem)item).m_40576_(new BlockPlaceContext(event.getEntity(), event.getHand(), stack, new BlockHitResult(new Vec3((double)frontPos.m_123341_() + 0.5 + (double)direction.m_122429_() * 0.5, (double)frontPos.m_123342_() + 0.5 + (double)direction.m_122430_() * 0.5, (double)frontPos.m_123343_() + 0.5 + (double)direction.m_122431_() * 0.5), direction, frontPos, false)));
        }
    }

    @SubscribeEvent
    public void serverInit(ServerStartedEvent event) {
        this.initPB();
    }

    @SubscribeEvent
    public void datapackReload(OnDatapackSyncEvent event) {
        if (event.getPlayer() != null) {
            return;
        }
        this.initPB();
    }

    public void initPB() {
        PandorasBox.logs = new ArrayListExtensions();
        PandorasBox.leaves = new ArrayListExtensions();
        PandorasBox.flowers = new ArrayListExtensions();
        PandorasBox.wool = new ArrayListExtensions();
        PandorasBox.slabs = new ArrayListExtensions();
        PandorasBox.bricks = new ArrayListExtensions();
        PandorasBox.terracotta = new ArrayListExtensions();
        PandorasBox.stained_terracotta = new ArrayListExtensions();
        PandorasBox.planks = new ArrayListExtensions();
        PandorasBox.stained_glass = new ArrayListExtensions();
        PandorasBox.saplings = new ArrayListExtensions();
        PandorasBox.pots = new ArrayListExtensions();
        for (Block block : ForgeRegistries.BLOCKS) {
            if (block.m_49966_().m_204336_(BlockTags.f_13106_)) {
                PandorasBox.logs.add(block);
            }
            if (block.m_49966_().m_204336_(BlockTags.f_13035_)) {
                PandorasBox.leaves.add(block);
            }
            if (block.m_49966_().m_204336_(BlockTags.f_13037_)) {
                PandorasBox.flowers.add(block);
            }
            if (block.m_49966_().m_204336_(BlockTags.f_13089_)) {
                PandorasBox.wool.add(block);
            }
            if (block.m_49966_().m_204336_(BlockTags.f_13031_)) {
                PandorasBox.slabs.add(block);
            }
            if (block.m_49966_().m_204336_(BlockTags.f_13091_)) {
                PandorasBox.bricks.add(block);
            }
            if (Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_().endsWith("terracotta")) {
                PandorasBox.terracotta.add(block);
            }
            if (Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_().endsWith("_terracotta")) {
                PandorasBox.stained_terracotta.add(block);
            }
            if (block.m_49966_().m_204336_(BlockTags.f_13090_)) {
                PandorasBox.planks.add(block);
            }
            if (block instanceof StainedGlassBlock) {
                PandorasBox.stained_glass.add(block);
            }
            if (block instanceof SaplingBlock) {
                PandorasBox.saplings.add(block);
            }
            if (!block.m_49966_().m_204336_(BlockTags.f_13045_)) continue;
            PandorasBox.pots.add(block);
        }
        PBEffects.registerEffectCreators();
    }

    public BlockPos getPosInFront(BlockPos pos, Direction direction) {
        return switch (direction) {
            case Direction.WEST -> pos.m_122024_();
            case Direction.EAST -> pos.m_122029_();
            case Direction.NORTH -> pos.m_122012_();
            case Direction.SOUTH -> pos.m_122019_();
            default -> pos;
        };
    }
}

