/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.utils;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class PBNBTHelper {
    public static byte readByte(CompoundTag compound, String key, byte defaultValue) {
        return compound != null && compound.m_128425_(key, 1) ? compound.m_128445_(key) : defaultValue;
    }

    public static byte[] readByteArray(CompoundTag compound, String key, byte[] defaultValue) {
        return compound != null && compound.m_128425_(key, 7) ? compound.m_128463_(key) : defaultValue;
    }

    public static double readDouble(CompoundTag compound, String key, double defaultValue) {
        return compound != null && compound.m_128425_(key, 6) ? compound.m_128459_(key) : defaultValue;
    }

    public static float readFloat(CompoundTag compound, String key, float defaultValue) {
        return compound != null && compound.m_128425_(key, 5) ? compound.m_128457_(key) : defaultValue;
    }

    public static int readInt(CompoundTag compound, String key, int defaultValue) {
        return compound != null && compound.m_128425_(key, 3) ? compound.m_128451_(key) : defaultValue;
    }

    public static int[] readIntArray(CompoundTag compound, String key, int[] defaultValue) {
        return compound != null && compound.m_128425_(key, 11) ? compound.m_128465_(key) : defaultValue;
    }

    public static long readLong(CompoundTag compound, String key, long defaultValue) {
        return compound != null && compound.m_128425_(key, 4) ? compound.m_128454_(key) : defaultValue;
    }

    public static short readShort(CompoundTag compound, String key, short defaultValue) {
        return compound != null && compound.m_128425_(key, 2) ? compound.m_128448_(key) : defaultValue;
    }

    public static String readString(CompoundTag compound, String key, String defaultValue) {
        return compound != null && compound.m_128425_(key, 8) ? compound.m_128461_(key) : defaultValue;
    }

    public static double[] readDoubleArray(String key, CompoundTag compound) {
        if (compound.m_128441_(key)) {
            ListTag list = compound.m_128437_(key, 6);
            double[] array = new double[list.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = list.m_128772_(i);
            }
            return array;
        }
        return null;
    }

    public static String[] readNBTStrings(String id, CompoundTag compound) {
        if (compound.m_128441_(id)) {
            ListTag nbtTagList = compound.m_128437_(id, 8);
            String[] strings = new String[nbtTagList.size()];
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = nbtTagList.m_128778_(i);
            }
            return strings;
        }
        return null;
    }

    public static void writeNBTStrings(String id, String[] strings, CompoundTag compound) {
        if (strings != null) {
            ListTag nbtTagList = new ListTag();
            for (String s : strings) {
                nbtTagList.add((Object)StringTag.m_129297_((String)s));
            }
            compound.m_128365_(id, (Tag)nbtTagList);
        }
    }

    public static ItemStack[] readNBTStacks(String id, CompoundTag compound) {
        if (compound.m_128441_(id)) {
            ListTag nbtTagList = compound.m_128437_(id, 10);
            ItemStack[] itemStacks = new ItemStack[nbtTagList.size()];
            for (int i = 0; i < itemStacks.length; ++i) {
                itemStacks[i] = ItemStack.m_41712_((CompoundTag)(nbtTagList.get(i) instanceof CompoundTag ? (CompoundTag)nbtTagList.get(i) : new CompoundTag()));
            }
            return itemStacks;
        }
        return null;
    }

    public static void writeNBTStacks(String id, ItemStack[] stacks, CompoundTag compound) {
        if (stacks != null) {
            ListTag nbtTagList = new ListTag();
            for (ItemStack stack : stacks) {
                CompoundTag tagCompound = new CompoundTag();
                stack.m_41739_(tagCompound);
                nbtTagList.add((Object)tagCompound);
            }
            compound.m_128365_(id, (Tag)nbtTagList);
        }
    }

    public static Block[] readNBTBlocks(String id, CompoundTag compound) {
        if (compound.m_128441_(id)) {
            ListTag nbtTagList = compound.m_128437_(id, 8);
            Block[] blocks = new Block[nbtTagList.size()];
            for (int i = 0; i < blocks.length; ++i) {
                blocks[i] = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbtTagList.m_128778_(i)));
            }
            return blocks;
        }
        return null;
    }

    public static void writeNBTBlocks(String id, Block[] blocks, CompoundTag compound) {
        if (blocks != null) {
            ListTag nbtTagList = new ListTag();
            for (Block b : blocks) {
                nbtTagList.add((Object)StringTag.m_129297_((String)PBNBTHelper.storeBlockString(b)));
            }
            compound.m_128365_(id, (Tag)nbtTagList);
        }
    }

    public static long[] readNBTLongs(String id, CompoundTag compound) {
        if (compound.m_128441_(id)) {
            ByteBuf bytes = Unpooled.copiedBuffer((byte[])compound.m_128463_(id));
            long[] longs = new long[bytes.capacity() / 8];
            for (int i = 0; i < longs.length; ++i) {
                longs[i] = bytes.readLong();
            }
            return longs;
        }
        return null;
    }

    public static void writeNBTLongs(String id, long[] longs, CompoundTag compound) {
        if (longs != null) {
            ByteBuf bytes = Unpooled.buffer((int)(longs.length * 8));
            for (long aLong : longs) {
                bytes.writeLong(aLong);
            }
            compound.m_128382_(id, bytes.array());
        }
    }

    public static MobEffectInstance[] readNBTPotions(String id, CompoundTag compound) {
        if (compound.m_128441_(id)) {
            ListTag nbtTagList = compound.m_128437_(id, 8);
            MobEffectInstance[] potions = new MobEffectInstance[nbtTagList.size()];
            for (int i = 0; i < potions.length; ++i) {
                potions[i] = MobEffectInstance.m_19560_((CompoundTag)nbtTagList.m_128728_(i));
            }
            return potions;
        }
        return null;
    }

    public static void writeNBTPotions(String id, MobEffectInstance[] potions, CompoundTag compound) {
        if (potions != null) {
            ListTag nbtTagList = new ListTag();
            for (MobEffectInstance p : potions) {
                nbtTagList.add((Object)p.m_19555_(new CompoundTag()));
            }
            compound.m_128365_(id, (Tag)nbtTagList);
        }
    }

    public static int[] readIntArrayFixedSize(String id, int length, CompoundTag compound) {
        int[] array = compound.m_128465_(id);
        return array.length != length ? new int[length] : array;
    }

    public static String[][] readNBTStrings2D(String id, CompoundTag compound) {
        ListTag nbtTagList = compound.m_128437_(id, 10);
        String[][] strings = new String[nbtTagList.size()][];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = PBNBTHelper.readNBTStrings("Strings", nbtTagList.m_128728_(i));
        }
        return strings;
    }

    public static void writeNBTStrings2D(String id, String[][] strings, CompoundTag compound) {
        ListTag nbtTagList = new ListTag();
        for (String[] s : strings) {
            CompoundTag compound1 = new CompoundTag();
            PBNBTHelper.writeNBTStrings("Strings", s, compound1);
            nbtTagList.add((Object)compound1);
        }
        compound.m_128365_(id, (Tag)nbtTagList);
    }

    public static String storeBlockString(Block block) {
        ResourceLocation location = ForgeRegistries.BLOCKS.getKey((Object)block);
        return location == null ? "minecraft:air" : location.toString();
    }

    public static Block getBlock(String string) {
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(string));
    }
}

