/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.weighted;

import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.RandomSource;

public class WeightedSelector {
    public static <T extends Item> double totalWeight(Collection<T> items) {
        return items.stream().mapToDouble(Item::getWeight).reduce(0.0, Double::sum);
    }

    public static <T> double totalWeight(Collection<T> items, ToDoubleFunction<T> weightFunction) {
        return items.stream().mapToDouble(weightFunction).reduce(0.0, Double::sum);
    }

    public static boolean canSelect(Collection<? extends Item> items) {
        return items.stream().anyMatch(item -> item.getWeight() > 0.0);
    }

    public static <T> boolean canSelect(Collection<T> items, ToDoubleFunction<T> weightFunction) {
        return items.stream().anyMatch(item -> weightFunction.applyAsDouble(item) > 0.0);
    }

    public static <T> T selectWeightless(RandomSource rand, Collection<T> items, int counted) {
        T item;
        counted = rand.m_188503_(counted);
        Iterator<T> iterator = items.iterator();
        do {
            item = iterator.next();
        } while (counted-- != 0 && iterator.hasNext());
        return item;
    }

    public static <T extends Item> T selectItem(RandomSource rand, Collection<T> items) {
        return WeightedSelector.selectItem(rand, items, WeightedSelector.totalWeight(items));
    }

    public static <T extends Item> T selectItem(RandomSource rand, Collection<T> items, double totalWeight) {
        return WeightedSelector.selectItem(rand, items, totalWeight, false);
    }

    public static <T extends Item> T selectItem(RandomSource rand, Collection<T> items, boolean remove) {
        return WeightedSelector.selectItem(rand, items, WeightedSelector.totalWeight(items), remove);
    }

    public static <T extends Item> T selectItem(RandomSource rand, Collection<T> items, double totalWeight, boolean remove) {
        if (items.size() == 0) {
            throw new IndexOutOfBoundsException();
        }
        double random = rand.m_188500_() * totalWeight;
        int counted = 0;
        Iterator<T> iterator = items.iterator();
        while (iterator.hasNext()) {
            Item t = (Item)iterator.next();
            if ((random -= t.getWeight()) <= 0.0) {
                if (remove) {
                    iterator.remove();
                }
                return (T)t;
            }
            ++counted;
        }
        return (T)((Item)WeightedSelector.selectWeightless(rand, items, counted));
    }

    public static <T> T select(RandomSource rand, Collection<T> items, ToDoubleFunction<T> weightFunction) {
        return WeightedSelector.select(rand, items, weightFunction, WeightedSelector.totalWeight(items, weightFunction));
    }

    public static <T> T select(RandomSource rand, Collection<T> items, ToDoubleFunction<T> weightFunction, double totalWeight) {
        return WeightedSelector.select(rand, items, weightFunction, totalWeight, false);
    }

    public static <T> T select(RandomSource rand, Collection<T> items, ToDoubleFunction<T> weightFunction, boolean remove) {
        return WeightedSelector.select(rand, items, weightFunction, WeightedSelector.totalWeight(items, weightFunction), remove);
    }

    public static <T> T select(RandomSource rand, Collection<T> items, ToDoubleFunction<T> weightFunction, double totalWeight, boolean remove) {
        if (items.size() == 0) {
            throw new IndexOutOfBoundsException();
        }
        double random = rand.m_188500_() * totalWeight;
        int counted = 0;
        Iterator<T> iterator = items.iterator();
        while (iterator.hasNext()) {
            T t = iterator.next();
            if ((random -= weightFunction.applyAsDouble(t)) <= 0.0) {
                if (remove) {
                    iterator.remove();
                }
                return t;
            }
            ++counted;
        }
        return WeightedSelector.selectWeightless(rand, items, counted);
    }

    public static <T> T select(RandomSource rand, Collection<SimpleItem<T>> items) {
        return WeightedSelector.selectItem(rand, items).getItem();
    }

    public static <T> T select(RandomSource rand, Collection<SimpleItem<T>> items, double totalWeight) {
        return WeightedSelector.selectItem(rand, items, totalWeight).getItem();
    }

    public static <T> T select(RandomSource rand, Collection<SimpleItem<T>> items, boolean remove) {
        return WeightedSelector.selectItem(rand, items, remove).getItem();
    }

    public static <T> T select(RandomSource rand, Collection<SimpleItem<T>> items, double totalWeight, boolean remove) {
        return WeightedSelector.selectItem(rand, items, totalWeight, remove).getItem();
    }

    public static interface Item {
        public double getWeight();
    }

    public static class SimpleItem<T>
    implements Item,
    Comparable<Item> {
        protected final double weight;
        protected final T item;

        public SimpleItem(double weight, T item) {
            this.item = item;
            this.weight = weight;
        }

        public static <T> SimpleItem<T> of(double weight, T item) {
            return new SimpleItem<T>(weight, item);
        }

        public static <T> List<SimpleItem<T>> apply(Stream<T> items, ToDoubleFunction<T> weightFunction) {
            return items.map(input -> new SimpleItem<Object>(weightFunction.applyAsDouble(input), input)).collect(Collectors.toList());
        }

        public static <T> Collection<SimpleItem<T>> apply(Collection<T> items, ToDoubleFunction<T> weightFunction) {
            return Collections2.transform(items, item -> new SimpleItem<Object>(weightFunction.applyAsDouble(item), item));
        }

        public static <T> List<SimpleItem<T>> apply(List<T> items, ToDoubleFunction<T> weightFunction) {
            return SimpleItem.apply(items.stream(), weightFunction);
        }

        public T getItem() {
            return this.item;
        }

        @Override
        public double getWeight() {
            return this.weight;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleItem that = (SimpleItem)o;
            if (Double.compare(that.weight, this.weight) != 0) {
                return false;
            }
            return this.item != null ? this.item.equals(that.item) : that.item == null;
        }

        public int hashCode() {
            long temp = Double.doubleToLongBits(this.weight);
            int result = (int)(temp ^ temp >>> 32);
            result = 31 * result + (this.item != null ? this.item.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "SimpleItem{weight=" + this.weight + ", item=" + this.item + "}";
        }

        @Override
        public int compareTo(Item o) {
            return Double.compare(this.weight, o.getWeight());
        }
    }

    public static class ItemComparator
    implements Comparator<Item> {
        @Override
        public int compare(Item o1, Item o2) {
            return Double.compare(o1.getWeight(), o2.getWeight());
        }
    }
}

