/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.worldgen;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import ivorius.pandorasbox.PandorasBox;
import ivorius.pandorasbox.utils.ArrayListExtensions;
import ivorius.pandorasbox.worldgen.AccessibleTreeFeature;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public class WorldGenColorfulTree
extends TreeFeature
implements AccessibleTreeFeature {
    public Block trunk;
    public int[] metas;
    public Block soil;
    private Random random;
    private Level level;
    private BlockPos origin = BlockPos.f_121853_;
    int heightLimit;
    int height;
    double heightAttenuation = 0.618;
    double field_175944_d = 0.381;
    double field_175945_e = 1.0;
    double leafDensity = 1.0;
    int spread = 1;
    int maxHeight;
    int leafDistanceLimit;
    List<FoliageCoordinates> foliageCoords;

    public WorldGenColorfulTree(Codec<TreeConfiguration> configIn, int height) {
        super(configIn);
        this.maxHeight = height;
        this.leafDistanceLimit = 4;
    }

    void generateLeafNodeList() {
        int k;
        int i;
        this.height = (int)((double)this.heightLimit * this.heightAttenuation);
        if (this.height >= this.heightLimit) {
            this.height = this.heightLimit - 1;
        }
        if ((i = (int)(1.382 + Math.pow(this.leafDensity * (double)this.heightLimit / 13.0, 2.0))) < 1) {
            i = 1;
        }
        int j = this.origin.m_123342_() + this.height;
        this.foliageCoords = Lists.newArrayList();
        this.foliageCoords.add(new FoliageCoordinates(this.origin.m_6630_(k), j));
        for (k = this.heightLimit - this.leafDistanceLimit; k >= 0; --k) {
            float f = this.layerSize(k);
            if (!(f >= 0.0f)) continue;
            for (int l = 0; l < i; ++l) {
                double d0 = this.field_175945_e * (double)f * ((double)this.random.nextFloat() + 0.328);
                double d1 = (double)(this.random.nextFloat() * 2.0f) * Math.PI;
                double d2 = d0 * Math.sin(d1) + 0.5;
                double d3 = d0 * Math.cos(d1) + 0.5;
                BlockPos blockpos = this.origin.m_121955_((Vec3i)BlockPos.m_274561_((double)d2, (double)(k - 1), (double)d3));
                BlockPos blockpos1 = blockpos.m_6630_(this.leafDistanceLimit);
                this.func_175936_a(blockpos, blockpos1);
                int i1 = this.origin.m_123341_() - blockpos.m_123341_();
                int j1 = this.origin.m_123343_() - blockpos.m_123343_();
                double d4 = (double)blockpos.m_123342_() - Math.sqrt(i1 * i1 + j1 * j1) * this.field_175944_d;
                int k1 = (int)Math.min(d4, (double)j);
                BlockPos blockpos2 = new BlockPos(this.origin.m_123341_(), k1, this.origin.m_123343_());
                this.func_175936_a(blockpos2, blockpos);
                this.foliageCoords.add(new FoliageCoordinates(blockpos, blockpos2.m_123342_()));
            }
        }
    }

    void createLeaves(BlockPos blockPos, float f, BlockState blockState) {
        int i = (int)((double)f + 0.618);
        for (int j = -i; j <= i; ++j) {
            for (int k = -i; k <= i; ++k) {
                BlockPos blockpos1;
                BlockState state;
                if (!(Math.pow((double)Math.abs(j) + 0.5, 2.0) + Math.pow((double)Math.abs(k) + 0.5, 2.0) <= (double)(f * f)) || !(state = this.level.m_8055_(blockpos1 = blockPos.m_7918_(j, 0, k))).m_60795_() && !state.m_204336_(BlockTags.f_13035_)) continue;
                this.m_5974_((LevelWriter)this.level, blockpos1, blockState);
            }
        }
    }

    float layerSize(int p_76490_1_) {
        if ((float)p_76490_1_ < (float)this.heightLimit * 0.3f) {
            return -1.0f;
        }
        float f = (float)this.heightLimit / 2.0f;
        float f1 = f - (float)p_76490_1_;
        float f2 = Mth.m_14116_((float)(f * f - f1 * f1));
        if (f1 == 0.0f) {
            f2 = f;
        } else if (Math.abs(f1) >= f) {
            return 0.0f;
        }
        return f2 * 0.5f;
    }

    float leafSize(int p_76495_1_) {
        return p_76495_1_ >= 0 && p_76495_1_ < this.leafDistanceLimit ? (p_76495_1_ != 0 && p_76495_1_ != this.leafDistanceLimit - 1 ? 3.0f : 2.0f) : -1.0f;
    }

    void placeLeaves(BlockPos blockPos) {
        for (int i = 0; i < this.leafDistanceLimit; ++i) {
            this.createLeaves(blockPos.m_6630_(i), this.leafSize(i), this.trunk.m_49966_());
        }
    }

    void placeBlock(BlockPos blockPos, BlockPos blockPos1, Block block) {
        BlockPos blockPos2 = blockPos1.m_7918_(-blockPos.m_123341_(), -blockPos.m_123342_(), -blockPos.m_123343_());
        int i = this.getHighestAbsoluteCoordinate(blockPos2);
        float f = (float)blockPos2.m_123341_() / (float)i;
        float f1 = (float)blockPos2.m_123342_() / (float)i;
        float f2 = (float)blockPos2.m_123343_() / (float)i;
        for (int j = 0; j <= i; ++j) {
            BlockPos blockPos3 = blockPos.m_121955_((Vec3i)BlockPos.m_274561_((double)(0.5f + (float)j * f), (double)(0.5f + (float)j * f1), (double)(0.5f + (float)j * f2)));
            this.m_5974_((LevelWriter)this.level, blockPos3, block.m_49966_());
        }
    }

    private int getHighestAbsoluteCoordinate(BlockPos p_175935_1_) {
        int i = Mth.m_14040_((int)p_175935_1_.m_123341_());
        int j = Mth.m_14040_((int)p_175935_1_.m_123342_());
        int k = Mth.m_14040_((int)p_175935_1_.m_123343_());
        return k > i && k > j ? k : Math.max(j, i);
    }

    void createLeafNodes() {
        for (FoliageCoordinates foliagecoordinates : this.foliageCoords) {
            this.placeLeaves(foliagecoordinates);
        }
    }

    boolean leafNodeNeedsBase(int p_76493_1_) {
        return (double)p_76493_1_ >= (double)this.heightLimit * 0.2;
    }

    void buildTrunk() {
        BlockPos blockpos = this.origin;
        BlockPos blockpos1 = this.origin.m_6630_(this.height);
        Block block = this.trunk;
        this.placeBlock(blockpos, blockpos1, block);
        if (this.spread == 2) {
            this.placeBlock(blockpos.m_122029_(), blockpos1.m_122029_(), block);
            this.placeBlock(blockpos.m_122029_().m_122019_(), blockpos1.m_122029_().m_122019_(), block);
            this.placeBlock(blockpos.m_122019_(), blockpos1.m_122019_(), block);
        }
    }

    void placeLeaves() {
        for (FoliageCoordinates foliageCoordinates : this.foliageCoords) {
            int i = foliageCoordinates.getHeight();
            BlockPos blockpos = new BlockPos(this.origin.m_123341_(), i, this.origin.m_123343_());
            if (!this.leafNodeNeedsBase(i - this.origin.m_123342_())) continue;
            this.placeBlock(blockpos, foliageCoordinates, this.trunk);
        }
    }

    int func_175936_a(BlockPos blockPos, BlockPos blockPos1) {
        BlockPos blockPos2 = blockPos1.m_7918_(-blockPos.m_123341_(), -blockPos.m_123342_(), -blockPos.m_123343_());
        int i = this.getHighestAbsoluteCoordinate(blockPos2);
        float f = (float)blockPos2.m_123341_() / (float)i;
        float f1 = (float)blockPos2.m_123342_() / (float)i;
        float f2 = (float)blockPos2.m_123343_() / (float)i;
        if (i != 0) {
            for (int j = 0; j <= i; ++j) {
                blockPos.m_121955_((Vec3i)BlockPos.m_274561_((double)(0.5f + (float)j * f), (double)(0.5f + (float)j * f1), (double)(0.5f + (float)j * f2)));
            }
        }
        return -1;
    }

    private boolean validTreeLocation() {
        boolean isSoil;
        BlockPos down = this.origin.m_7495_();
        BlockState state = this.level.m_8055_(down);
        boolean bl = isSoil = state.m_60734_() == this.soil;
        if (!isSoil) {
            return false;
        }
        int i = this.func_175936_a(this.origin, this.origin.m_6630_(this.heightLimit - 1));
        if (i == -1) {
            return true;
        }
        if (i < 6) {
            return false;
        }
        this.heightLimit = i;
        return true;
    }

    @Override
    public void setMetas(int[] newMetas) {
        this.metas = newMetas;
    }

    @Override
    public void setSoil(Block newSoil) {
        this.soil = newSoil;
    }

    @Override
    public boolean place(Level worldIn, RandomSource rand, BlockPos position) {
        this.level = worldIn;
        this.origin = position;
        this.random = new Random(rand.m_188505_());
        ArrayListExtensions blocks = new ArrayListExtensions();
        blocks.addAll(PandorasBox.wool);
        this.trunk = (Block)blocks.get(this.metas[rand.m_188503_(this.metas.length)]);
        if (this.level == null) {
            return false;
        }
        if (this.heightLimit == 0) {
            this.heightLimit = 5 + this.random.nextInt(this.maxHeight);
        }
        if (!this.validTreeLocation()) {
            this.level = null;
            return false;
        }
        this.generateLeafNodeList();
        this.createLeafNodes();
        this.buildTrunk();
        this.placeLeaves();
        this.level = null;
        return true;
    }

    static class FoliageCoordinates
    extends BlockPos {
        private final int height;

        public FoliageCoordinates(BlockPos blockPos, int height) {
            super((Vec3i)blockPos);
            this.height = height;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

