/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.client.rendering;

import ivorius.pandorasbox.client.rendering.ModelPandorasBox;
import ivorius.pandorasbox.client.rendering.effects.PBEffectRenderer;
import ivorius.pandorasbox.client.rendering.effects.PBEffectRenderingRegistry;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.entitites.EntityPandorasBox;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.b3d.B3DLoader;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderPandorasBox
extends Render {
    public ModelBase model = new ModelPandorasBox();
    public ResourceLocation texture = new ResourceLocation("pandorasbox", "textures/entity/pandoras_box.png");

    public RenderPandorasBox(RenderManager renderManager) {
        super(renderManager);
    }

    public static void renderB3DModel(TextureManager textureManager, ResourceLocation modelLoc, IBlockState blockState, int animationCounter) {
        IModel model = null;
        try {
            model = ModelLoaderRegistry.getModel((ResourceLocation)modelLoc);
            B3DLoader.B3DState defaultState = (B3DLoader.B3DState)model.getDefaultState();
            B3DLoader.B3DState newState = new B3DLoader.B3DState(defaultState.getAnimation(), animationCounter);
            RenderPandorasBox.renderBlockModel(textureManager, model, blockState, (IModelState)newState);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void renderBlockModel(TextureManager textureManager, IModel model, IBlockState blockState, IModelState state) {
        if (state == null) {
            state = model.getDefaultState();
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179118_c();
        TextureMap textureMapBlocks = Minecraft.func_71410_x().func_147117_R();
        VertexFormat vFormat = Attributes.DEFAULT_BAKED_FORMAT;
        IBakedModel bakedModel = model.bake(state, vFormat, input -> input == null ? textureMapBlocks.func_174944_f() : textureMapBlocks.func_110572_b(input.toString()));
        textureManager.func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)-0.5f, (float)0.0f, (float)-0.5f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_181668_a(7, vFormat);
        for (BakedQuad quad : bakedModel.func_188616_a(blockState, null, 4206942L)) {
            worldRenderer.func_178981_a(quad.func_178209_a());
        }
        for (EnumFacing facing : EnumFacing.values()) {
            for (BakedQuad quad : bakedModel.func_188616_a(blockState, facing, 4206942L)) {
                worldRenderer.func_178981_a(quad.func_178209_a());
            }
        }
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179141_d();
    }

    public void func_76986_a(Entity entity, double x, double y, double z, float yaw, float partialTicks) {
        PBEffectRenderer renderer;
        EntityPandorasBox entityPandorasBox = (EntityPandorasBox)entity;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)(y + (double)MathHelper.func_76126_a((float)(((float)entity.field_70173_aa + partialTicks) * 0.04f)) * 0.05), (double)z);
        GlStateManager.func_179114_b((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        PBEffect effect = entityPandorasBox.getBoxEffect();
        if (!effect.isDone(entityPandorasBox, entityPandorasBox.getEffectTicksExisted()) && entityPandorasBox.getDeathTicks() < 0 && (renderer = PBEffectRenderingRegistry.rendererForEffect(effect)) != null) {
            renderer.renderBox(entityPandorasBox, effect, partialTicks);
        }
        if (!entity.func_82150_aj()) {
            float boxScale = entityPandorasBox.getCurrentScale();
            if (boxScale < 1.0f) {
                GlStateManager.func_179152_a((float)boxScale, (float)boxScale, (float)boxScale);
            }
            GlStateManager.func_179109_b((float)0.0f, (float)1.5f, (float)0.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            EntityTippedArrow emptyEntity = new EntityTippedArrow(entity.field_70170_p);
            emptyEntity.field_70125_A = entityPandorasBox.getRatioBoxOpen(partialTicks) * 120.0f / 180.0f * 3.1415925f;
            this.func_180548_c(entity);
            this.model.func_78088_a((Entity)emptyEntity, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        }
        GlStateManager.func_179121_F();
        super.func_76986_a(entity, x, y, z, yaw, partialTicks);
    }

    protected ResourceLocation func_110775_a(Entity var1) {
        return this.texture;
    }
}

