/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectEntityBased;
import ivorius.pandorasbox.entitites.EntityPandorasBox;
import ivorius.pandorasbox.mods.Psychedelicraft;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class PBEffectEntitiesDrug
extends PBEffectEntityBased {
    public final List<Pair<String, Float>> drugs = new ArrayList<Pair<String, Float>>();

    public PBEffectEntitiesDrug() {
    }

    public PBEffectEntitiesDrug(int maxTicksAlive, double range, Collection<Pair<String, Float>> drugs) {
        super(maxTicksAlive, range);
        this.drugs.addAll(drugs);
    }

    @Override
    public void affectEntity(World world, EntityPandorasBox box, Random random, EntityLivingBase entity, double newRatio, double prevRatio, double strength) {
        for (Pair<String, Float> effect : this.drugs) {
            float prevStrength = (float)(prevRatio * strength * (double)((Float)effect.getRight()).floatValue());
            float newStrength = (float)(newRatio * strength * (double)((Float)effect.getRight()).floatValue());
            float drugStrength = newStrength - prevStrength;
            if (!(drugStrength > 0.0f)) continue;
            Psychedelicraft.addDrugValue((Entity)entity, (String)effect.getLeft(), drugStrength);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        NBTTagList drugList = new NBTTagList();
        for (Pair<String, Float> drug : this.drugs) {
            NBTTagCompound drugCmp = new NBTTagCompound();
            drugCmp.func_74778_a("drugName", (String)drug.getLeft());
            drugCmp.func_74776_a("strength", ((Float)drug.getRight()).floatValue());
            drugList.func_74742_a((NBTBase)drugCmp);
        }
        compound.func_74782_a("drugs", (NBTBase)drugList);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.drugs.clear();
        NBTTagList drugList = compound.func_150295_c("drugs", 10);
        for (int i = 0; i < drugList.func_74745_c(); ++i) {
            NBTTagCompound drugCmp = drugList.func_150305_b(i);
            this.drugs.add((Pair<String, Float>)new ImmutablePair((Object)drugCmp.func_74779_i("drugName"), (Object)Float.valueOf(drugCmp.func_74760_g("strength"))));
        }
    }
}

