/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectRangeBased;
import ivorius.pandorasbox.entitites.EntityPandorasBox;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class PBEffectGenerate
extends PBEffectRangeBased {
    public int unifiedSeed;

    public PBEffectGenerate() {
    }

    public PBEffectGenerate(int time, double range, int passes, int unifiedSeed) {
        super(time, range, passes);
        this.unifiedSeed = unifiedSeed;
    }

    @Override
    public void generateInRange(World world, EntityPandorasBox entity, Random random, Vec3d effectCenter, double prevRange, double newRange, int pass) {
        int requiredRange = MathHelper.func_76143_f((double)newRange);
        int baseX = MathHelper.func_76128_c((double)effectCenter.field_72450_a);
        int baseY = MathHelper.func_76128_c((double)effectCenter.field_72448_b);
        int baseZ = MathHelper.func_76128_c((double)effectCenter.field_72449_c);
        for (int x = -requiredRange; x <= requiredRange; ++x) {
            for (int y = -requiredRange; y <= requiredRange; ++y) {
                for (int z = -requiredRange; z <= requiredRange; ++z) {
                    double dist = MathHelper.func_76129_c((float)(x * x + y * y + z * z));
                    if (!(dist <= newRange)) continue;
                    if (dist > prevRange) {
                        this.generateOnBlock(world, entity, effectCenter, random, pass, new BlockPos(baseX + x, baseY + y, baseZ + z), dist);
                        continue;
                    }
                    z = -z;
                }
            }
        }
    }

    public abstract void generateOnBlock(World var1, EntityPandorasBox var2, Vec3d var3, Random var4, int var5, BlockPos var6, double var7);

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74768_a("unifiedSeed", this.unifiedSeed);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.unifiedSeed = compound.func_74762_e("unifiedSeed");
    }
}

