/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.entitites.EntityPandorasBox;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class PBEffectNormal
extends PBEffect {
    public int maxTicksAlive;

    public PBEffectNormal() {
    }

    public PBEffectNormal(int maxTicksAlive) {
        this.maxTicksAlive = maxTicksAlive;
    }

    public float getRatioDone(int ticks) {
        if (ticks == this.maxTicksAlive) {
            return 1.0f;
        }
        return (float)ticks / (float)this.maxTicksAlive;
    }

    public abstract void doEffect(World var1, EntityPandorasBox var2, Vec3d var3, Random var4, float var5, float var6);

    public void setUpEffect(World world, EntityPandorasBox entity, Vec3d effectCenter, Random random) {
    }

    public void finalizeEffect(World world, EntityPandorasBox entity, Vec3d effectCenter, Random random) {
    }

    @Override
    public void doTick(EntityPandorasBox entity, Vec3d effectCenter, int ticksAlive) {
        float prevRatio = this.getRatioDone(ticksAlive);
        float newRatio = this.getRatioDone(ticksAlive + 1);
        if (ticksAlive == 0) {
            this.setUpEffect(entity.field_70170_p, entity, effectCenter, entity.getRandom());
        }
        if (prevRatio >= 0.0f && newRatio <= 1.0f && newRatio > prevRatio) {
            this.doEffect(entity.field_70170_p, entity, effectCenter, entity.getRandom(), prevRatio, newRatio);
        }
        if (ticksAlive == this.maxTicksAlive - 1) {
            this.finalizeEffect(entity.field_70170_p, entity, effectCenter, entity.getRandom());
        }
    }

    @Override
    public boolean isDone(EntityPandorasBox entity, int ticksAlive) {
        return ticksAlive >= this.maxTicksAlive;
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74768_a("maxTicksAlive", this.maxTicksAlive);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.maxTicksAlive = compound.func_74762_e("maxTicksAlive");
    }

    @Override
    public boolean canGenerateMoreEffectsAfterwards(EntityPandorasBox entity) {
        return true;
    }
}

