/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.entitites;

import io.netty.buffer.ByteBuf;
import ivorius.pandorasbox.PBConfig;
import ivorius.pandorasbox.PandorasBox;
import ivorius.pandorasbox.effectcreators.PBECRegistry;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectRegistry;
import ivorius.pandorasbox.mods.Psychedelicraft;
import ivorius.pandorasbox.network.PacketEntityData;
import ivorius.pandorasbox.network.PartialUpdateHandler;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityPandorasBox
extends Entity
implements IEntityAdditionalSpawnData,
PartialUpdateHandler {
    public static final float BOX_UPSCALE_SPEED = 0.02f;
    private static final DataParameter<Integer> BOX_DEATH_TICKS = EntityDataManager.func_187226_a(EntityLivingBase.class, (DataSerializer)DataSerializers.field_187192_b);
    protected int timeBoxWaiting;
    protected int effectTicksExisted;
    protected boolean canGenerateMoreEffectsAfterwards = true;
    protected PBEffect boxEffect;
    protected boolean floatUp = false;
    protected float floatAwayProgress = -1.0f;
    protected float scaleInProgress = 1.0f;
    protected Vec3d effectCenter = new Vec3d(0.0, 0.0, 0.0);

    public EntityPandorasBox(World world) {
        super(world);
        this.func_70105_a(0.6f, 0.4f);
    }

    public EntityPandorasBox(World world, PBEffect effect) {
        this(world);
        this.setBoxEffect(effect);
        this.timeBoxWaiting = 40;
    }

    public int getTimeBoxWaiting() {
        return this.timeBoxWaiting;
    }

    public void setTimeBoxWaiting(int timeBoxWaiting) {
        this.timeBoxWaiting = timeBoxWaiting;
    }

    public int getEffectTicksExisted() {
        return this.effectTicksExisted;
    }

    public void setEffectTicksExisted(int effectTicksExisted) {
        this.effectTicksExisted = effectTicksExisted;
    }

    public boolean isCanGenerateMoreEffectsAfterwards() {
        return this.canGenerateMoreEffectsAfterwards;
    }

    public void setCanGenerateMoreEffectsAfterwards(boolean canGenerateMoreEffectsAfterwards) {
        this.canGenerateMoreEffectsAfterwards = canGenerateMoreEffectsAfterwards;
    }

    public boolean isFloatUp() {
        return this.floatUp;
    }

    public void setFloatUp(boolean floatUp) {
        this.floatUp = floatUp;
    }

    public float getFloatAwayProgress() {
        return this.floatAwayProgress;
    }

    public void setFloatAwayProgress(float floatAwayProgress) {
        this.floatAwayProgress = floatAwayProgress;
    }

    public Vec3d getEffectCenter() {
        return this.effectCenter;
    }

    public void setEffectCenter(double x, double y, double z) {
        this.effectCenter = new Vec3d(x, y, z);
    }

    public float getCurrentScale() {
        return this.scaleInProgress;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(BOX_DEATH_TICKS, (Object)-1);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getDeathTicks() >= 0) {
            if (!this.field_70170_p.field_72995_K) {
                if (this.getDeathTicks() >= 30) {
                    this.func_70106_y();
                }
            } else {
                for (int e = 0; e < Math.min(this.getDeathTicks(), 60); ++e) {
                    double xP = (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.5;
                    double yP = (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.5;
                    double zP = (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.5;
                    if (this.field_70146_Z.nextBoolean()) {
                        this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + xP, this.field_70163_u + yP, this.field_70161_v + zP, 0.0, 0.0, 0.0, new int[0]);
                        continue;
                    }
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + xP, this.field_70163_u + yP, this.field_70161_v + zP, 0.0, 0.0, 0.0, new int[0]);
                }
            }
            this.setDeathTicks(this.getDeathTicks() + 1);
        }
        if (this.timeBoxWaiting == 0 && this.getDeathTicks() < 0) {
            PBEffect effect = this.getBoxEffect();
            if (effect == null) {
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70106_y();
                }
            } else if (effect.isDone(this, this.effectTicksExisted)) {
                if (!this.field_70170_p.field_72995_K) {
                    boolean isCompletelyDone = true;
                    if (this.canGenerateMoreEffectsAfterwards && effect.canGenerateMoreEffectsAfterwards(this) && (double)this.field_70146_Z.nextFloat() < PBConfig.boxLongevity) {
                        this.startNewEffect();
                        isCompletelyDone = false;
                    }
                    if (isCompletelyDone) {
                        this.startFadingOut();
                    }
                }
            } else {
                if (this.effectTicksExisted == 0) {
                    this.setEffectCenter(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                }
                effect.doTick(this, this.effectCenter, this.effectTicksExisted);
            }
        }
        if (this.timeBoxWaiting == 0) {
            this.field_70159_w *= 0.5;
            this.field_70181_x *= 0.5;
            this.field_70179_y *= 0.5;
        } else {
            this.field_70159_w *= 0.95;
            this.field_70181_x *= 0.95;
            this.field_70179_y *= 0.95;
        }
        if (this.floatAwayProgress >= 0.0f && this.floatAwayProgress < 1.0f) {
            float speed;
            if (this.floatUp) {
                speed = (this.floatAwayProgress - 0.7f) * (this.floatAwayProgress - 0.7f);
                this.field_70181_x += (double)(speed * 0.005f);
            } else {
                speed = (this.floatAwayProgress - 0.7f) * (this.floatAwayProgress - 0.7f);
                this.func_191958_b(0.0f, 0.01f, speed * 0.02f, 0.02f);
                this.field_70181_x += (double)(speed * 0.005f);
            }
            this.floatAwayProgress += 0.025f;
            if (this.floatAwayProgress > 1.0f) {
                this.stopFloating();
            }
        }
        if (this.scaleInProgress < 1.0f) {
            this.scaleInProgress += 0.02f;
        }
        if (this.scaleInProgress > 1.0f) {
            this.scaleInProgress = 1.0f;
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (this.timeBoxWaiting == 0) {
            if (this.getDeathTicks() < 0) {
                if (!this.func_82150_aj()) {
                    if (this.field_70170_p.field_72995_K) {
                        double zP;
                        double yDir;
                        double xP;
                        int e;
                        double yCenter = this.field_70163_u + (double)this.field_70131_O * 0.5;
                        for (e = 0; e < 2; ++e) {
                            xP = (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.2;
                            yDir = this.field_70146_Z.nextDouble() * 0.1;
                            zP = (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.2;
                            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + xP, yCenter, this.field_70161_v + zP, 0.0, yDir, 0.0, new int[0]);
                        }
                        for (e = 0; e < 3; ++e) {
                            double xDir = (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 3.0;
                            yDir = this.field_70146_Z.nextDouble() * 4.0 + 2.0;
                            double zDir = (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 3.0;
                            double xP2 = (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N;
                            double zP2 = (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N;
                            this.field_70170_p.func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, this.field_70165_t + xP2 + xDir, yCenter + yDir, this.field_70161_v + zP2 + zDir, -xDir, -yDir, -zDir, new int[0]);
                        }
                        for (e = 0; e < 4; ++e) {
                            xP = this.field_70146_Z.nextDouble() * 16.0 - 8.0;
                            double yP = this.field_70146_Z.nextDouble() * 5.0 - 2.0;
                            zP = this.field_70146_Z.nextDouble() * 16.0 - 8.0;
                            double xDir = this.field_70146_Z.nextDouble() * 2.0 - 1.0;
                            double yDir2 = this.field_70146_Z.nextDouble() * 2.0 - 1.0;
                            double zDir = this.field_70146_Z.nextDouble() * 2.0 - 1.0;
                            this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t + xP, yCenter + yP, this.field_70161_v + zP, xDir, yDir2, zDir, new int[0]);
                        }
                    }
                    if (Psychedelicraft.isLoaded() && PBConfig.boxPowerVisuals) {
                        float powerRange = 5.0f;
                        float powerStrength = 0.07f;
                        List nearbyEntities = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_72321_a((double)powerRange, (double)powerRange, (double)powerRange));
                        for (EntityLivingBase entity : nearbyEntities) {
                            float entityDist = (float)entity.func_70068_e((Entity)this);
                            if (!(entityDist < powerRange)) continue;
                            Psychedelicraft.addDrugValue((Entity)entity, "Power", powerStrength * (powerRange - entityDist));
                        }
                    }
                }
                ++this.effectTicksExisted;
            }
        } else {
            --this.timeBoxWaiting;
        }
    }

    public void startNewEffect() {
        this.effectTicksExisted = 0;
        this.timeBoxWaiting = this.field_70146_Z.nextInt(40);
        this.boxEffect = PBECRegistry.createRandomEffect(this.field_70170_p, this.field_70146_Z, this.effectCenter.field_72450_a, this.effectCenter.field_72448_b, this.effectCenter.field_72449_c, true);
        PandorasBox.network.sendToDimension((IMessage)PacketEntityData.packetEntityData(this, "boxEffect"), this.field_70170_p.field_73011_w.getDimension());
    }

    public void startFadingOut() {
        this.setDeathTicks(0);
    }

    public void beginFloatingAway() {
        this.floatAwayProgress = 0.0f;
        this.floatUp = false;
    }

    public void beginFloatingUp() {
        this.floatAwayProgress = 0.0f;
        this.floatUp = true;
    }

    public void stopFloating() {
        this.floatAwayProgress = -1.0f;
        this.effectTicksExisted = 0;
        PandorasBox.network.sendToDimension((IMessage)PacketEntityData.packetEntityData(this, "boxEffect"), this.field_70170_p.field_73011_w.getDimension());
    }

    public void beginScalingIn() {
        this.scaleInProgress = 0.0f;
    }

    public PBEffect getBoxEffect() {
        return this.boxEffect;
    }

    public void setBoxEffect(PBEffect effect) {
        this.boxEffect = effect;
    }

    public Random getRandom() {
        return this.field_70146_Z;
    }

    public int getDeathTicks() {
        return (Integer)this.func_184212_Q().func_187225_a(BOX_DEATH_TICKS);
    }

    public void setDeathTicks(int deathTicks) {
        this.func_184212_Q().func_187227_b(BOX_DEATH_TICKS, (Object)deathTicks);
    }

    public float getRatioBoxOpen(float partialTicks) {
        if (this.floatAwayProgress >= 0.0f) {
            return MathHelper.func_76131_a((float)((this.floatAwayProgress + partialTicks * 0.025f - 0.5f) * 2.0f), (float)0.0f, (float)1.0f);
        }
        return 1.0f;
    }

    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return entityIn.func_174813_aQ();
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    protected void func_70037_a(NBTTagCompound var1) {
        this.readBoxData(var1);
    }

    protected void func_70014_b(NBTTagCompound var1) {
        this.writeBoxData(var1);
    }

    public void readBoxData(NBTTagCompound compound) {
        this.setBoxEffect(PBEffectRegistry.loadEffect(compound.func_74775_l("boxEffect")));
        this.effectTicksExisted = compound.func_74762_e("effectTicksExisted");
        this.timeBoxWaiting = compound.func_74762_e("timeBoxWaiting");
        this.canGenerateMoreEffectsAfterwards = compound.func_74767_n("canGenerateMoreEffectsAfterwards");
        this.floatAwayProgress = compound.func_74760_g("floatAwayProgress");
        this.floatUp = compound.func_74767_n("floatUp");
        this.scaleInProgress = compound.func_74760_g("scaleInProgress");
        if (compound.func_150297_b("effectCenterX", 6) && compound.func_150297_b("effectCenterY", 6) && compound.func_150297_b("effectCenterZ", 6)) {
            this.setEffectCenter(compound.func_74769_h("effectCenterX"), compound.func_74769_h("effectCenterY"), compound.func_74769_h("effectCenterZ"));
        } else {
            this.setEffectCenter(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    public void writeBoxData(NBTTagCompound compound) {
        NBTTagCompound effectCompound = new NBTTagCompound();
        PBEffectRegistry.writeEffect(this.getBoxEffect(), effectCompound);
        compound.func_74782_a("boxEffect", (NBTBase)effectCompound);
        compound.func_74768_a("effectTicksExisted", this.effectTicksExisted);
        compound.func_74768_a("timeBoxWaiting", this.timeBoxWaiting);
        compound.func_74757_a("canGenerateMoreEffectsAfterwards", this.canGenerateMoreEffectsAfterwards);
        compound.func_74776_a("floatAwayProgress", this.floatAwayProgress);
        compound.func_74757_a("floatUp", this.floatUp);
        compound.func_74776_a("scaleInProgress", this.scaleInProgress);
        compound.func_74780_a("effectCenterX", this.effectCenter.field_72450_a);
        compound.func_74780_a("effectCenterY", this.effectCenter.field_72448_b);
        compound.func_74780_a("effectCenterZ", this.effectCenter.field_72449_c);
    }

    public void writeSpawnData(ByteBuf buffer) {
        NBTTagCompound compound = new NBTTagCompound();
        this.writeBoxData(compound);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)compound);
    }

    public void readSpawnData(ByteBuf buffer) {
        NBTTagCompound compound = ByteBufUtils.readTag((ByteBuf)buffer);
        if (compound != null) {
            this.readBoxData(compound);
        }
    }

    @Override
    public void writeUpdateData(ByteBuf buffer, String context) {
        if (context.equals("boxEffect")) {
            NBTTagCompound compound = new NBTTagCompound();
            this.writeBoxData(compound);
            ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)compound);
        }
    }

    @Override
    public void readUpdateData(ByteBuf buffer, String context) {
        NBTTagCompound compound;
        if (context.equals("boxEffect") && (compound = ByteBufUtils.readTag((ByteBuf)buffer)) != null) {
            this.readBoxData(compound);
        }
    }
}

