/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.math;

import java.util.Random;
import net.minecraft.util.math.MathHelper;

public class IvMathHelper {
    public static double mix(double value1, double value2, double progress) {
        return value1 + (value2 - value1) * progress;
    }

    public static double mixEaseInOut(double value1, double value2, double progress) {
        return IvMathHelper.cubicMix(value1, value1, value2, value2, progress);
    }

    public static double easeZeroToOne(double progress) {
        return IvMathHelper.cubicMix(0.0, 0.0, 1.0, 1.0, IvMathHelper.clamp(0.0, progress, 1.0));
    }

    public static double quadraticMix(double value1, double value2, double value3, double progress) {
        return IvMathHelper.mix(IvMathHelper.mix(value1, value2, progress), IvMathHelper.mix(value2, value3, progress), progress);
    }

    public static double cubicMix(double value1, double value2, double value3, double value4, double progress) {
        return IvMathHelper.mix(IvMathHelper.quadraticMix(value1, value2, value3, progress), IvMathHelper.quadraticMix(value2, value3, value4, progress), progress);
    }

    public static float mix(float value1, float value2, float progress) {
        return value1 + (value2 - value1) * progress;
    }

    public static float mixEaseInOut(float value1, float value2, float progress) {
        return IvMathHelper.cubicMix(value1, value1, value2, value2, progress);
    }

    public static float easeZeroToOne(float progress) {
        return IvMathHelper.cubicMix(0.0f, 0.0f, 1.0f, 1.0f, IvMathHelper.clamp(0.0f, progress, 1.0f));
    }

    public static float quadraticMix(float value1, float value2, float value3, float progress) {
        return IvMathHelper.mix(IvMathHelper.mix(value1, value2, progress), IvMathHelper.mix(value2, value3, progress), progress);
    }

    public static float cubicMix(float value1, float value2, float value3, float value4, float progress) {
        return IvMathHelper.mix(IvMathHelper.quadraticMix(value1, value2, value3, progress), IvMathHelper.quadraticMix(value2, value3, value4, progress), progress);
    }

    public static float clamp(float min, float value, float max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static double clamp(double min, double value, double max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static float nearValue(float value, float dest, float mulSpeed, float plusSpeed) {
        if ((value += (dest - value) * mulSpeed) > dest) {
            if ((value -= plusSpeed) < dest) {
                value = dest;
            }
        } else if (value < dest && (value += plusSpeed) > dest) {
            value = dest;
        }
        return value;
    }

    public static double nearValue(double value, double dest, double mulSpeed, double plusSpeed) {
        if ((value += (dest - value) * mulSpeed) > dest) {
            if ((value -= plusSpeed) < dest) {
                value = dest;
            }
        } else if (value < dest && (value += plusSpeed) > dest) {
            value = dest;
        }
        return value;
    }

    public static int randomLinearNumber(Random random, float number) {
        return MathHelper.func_76141_d((float)number) + (random.nextFloat() < number % 1.0f ? 1 : 0);
    }

    public static float zeroToOne(float value, float min, float max) {
        return IvMathHelper.clamp(0.0f, (value - min) / (max - min), 1.0f);
    }

    public static double zeroToOne(double value, double min, double max) {
        return IvMathHelper.clamp(0.0, (value - min) / (max - min), 1.0);
    }
}

