/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.attribute;

import com.google.common.util.concurrent.AtomicDouble;
import daripher.skilltree.api.PSTLivingEntity;
import daripher.skilltree.gem.GemHelper;
import daripher.skilltree.init.SkillTreeAttributes;
import daripher.skilltree.init.SkillTreeEffects;
import daripher.skilltree.item.ItemHelper;
import daripher.skilltree.util.FoodHelper;
import daripher.skilltree.util.PlayerHelper;
import daripher.skilltree.util.TooltipHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

@Mod.EventBusSubscriber(modid="skilltree")
public class AttributeBonusHandler {
    @SubscribeEvent
    public static void applyDamageBonus(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7640_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            float damage = event.getAmount();
            event.setAmount(damage *= PlayerHelper.getDamageMultiplier(player, event.getEntity(), true));
        }
    }

    @SubscribeEvent
    public static void applyCritBonus(CriticalHitEvent event) {
        if (event.isVanillaCritical()) {
            return;
        }
        Entity entity = event.getTarget();
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            float critChance = PlayerHelper.getCritChance(event.getEntity(), target);
            critChance = Math.min(0.75f, critChance);
            if (event.getEntity().m_217043_().m_188501_() < critChance) {
                float critDamage = PlayerHelper.getCritDamageMultiplier(event.getEntity(), target);
                event.setDamageModifier(critDamage);
                event.setResult(Event.Result.ALLOW);
            }
        }
    }

    @SubscribeEvent
    public static void applyDynamicAttributeBonuses(TickEvent.PlayerTickEvent event) {
        if (event.player.f_19853_.f_46443_) {
            return;
        }
        Player player = event.player;
        AttributeBonusHandler.applyDynamicAttributeBonus(player, Attributes.f_22276_, AttributeModifier.Operation.ADDITION, "d1f7e78b-3368-409c-aa89-90f0f89a5524", AttributeBonusHandler::getMaximumLifePerEvasion);
        AttributeBonusHandler.applyDynamicAttributeBonus(player, Attributes.f_22276_, AttributeModifier.Operation.ADDITION, "b68181bd-fbc4-4a63-95d4-df386fe3f71f", AttributeBonusHandler::getMaximumLifePerGemInArmor);
        AttributeBonusHandler.applyDynamicAttributeBonus(player, Attributes.f_22284_, AttributeModifier.Operation.ADDITION, "7cb71ee5-8715-40ae-a877-72ec3b49b33e", AttributeBonusHandler::getArmorPerEvasion);
        AttributeBonusHandler.applyDynamicAttributeBonus(player, Attributes.f_22284_, AttributeModifier.Operation.ADDITION, "66eae15c-53eb-4a4a-b511-2ab94f81324b", AttributeBonusHandler::getArmorPerGemInChestplate);
        AttributeBonusHandler.applyDynamicAttributeBonus(player, Attributes.f_22284_, AttributeModifier.Operation.ADDITION, "1080308c-bdd4-4693-876c-a36390b66b73", AttributeBonusHandler::getArmorPerGemInHelmet);
        AttributeBonusHandler.applyDynamicAttributeBonus(player, Attributes.f_22281_, AttributeModifier.Operation.ADDITION, "d1079882-dd8c-42b7-9a43-3928553193c8", AttributeBonusHandler::getDamagePerArmor);
        AttributeBonusHandler.applyDynamicAttributeBonus(player, Attributes.f_22276_, AttributeModifier.Operation.ADDITION, "9199d7cf-c7e4-4123-b636-6f6591e1137d", AttributeBonusHandler::getMaximumLifePerArmor);
        AttributeBonusHandler.applyDynamicAttributeBonus(player, Attributes.f_22276_, AttributeModifier.Operation.ADDITION, "8810227f-9798-4890-8400-91c0941a3fc0", AttributeBonusHandler::getMaximumLifePerBootsArmor);
        AttributeBonusHandler.applyDynamicAttributeBonus(player, Attributes.f_22276_, AttributeModifier.Operation.ADDITION, "98a17cd0-68c8-4808-8981-1796c33295e7", AttributeBonusHandler::getMaximumLifePerSatisfiedHunger);
        AttributeBonusHandler.applyDynamicAttributeBonus(player, (Attribute)SkillTreeAttributes.EVASION_CHANCE.get(), AttributeModifier.Operation.MULTIPLY_BASE, "4aa87d74-b729-4e1d-9c76-893495050416", AttributeBonusHandler::getEvasionUnderPotionEffect);
        AttributeBonusHandler.applyDynamicAttributeBonus(player, Attributes.f_22283_, AttributeModifier.Operation.MULTIPLY_TOTAL, "a4daf7f8-29e3-404d-8277-9215a16ef4c8", AttributeBonusHandler::getAttackSpeedUnderPotionEffect);
        AttributeBonusHandler.applyDynamicAttributeBonus(player, Attributes.f_22276_, AttributeModifier.Operation.ADDITION, "de712f9d-9f47-475c-8b86-188bca70d1df", AttributeBonusHandler::getMaximumLifeUnderPotionEffect);
        AttributeBonusHandler.applyDynamicAttributeBonus(player, (Attribute)SkillTreeAttributes.EVASION_CHANCE.get(), AttributeModifier.Operation.MULTIPLY_BASE, "282c4f81-7b6d-48e0-82c9-c4ebd58265cb", AttributeBonusHandler::getEvasionPerPotionEffect);
        AttributeBonusHandler.applyDynamicAttributeBonus(player, Attributes.f_22276_, AttributeModifier.Operation.ADDITION, "16c35c5c-56da-4d21-ad56-bd6618fee711", AttributeBonusHandler::getMaximumLifeWithEnchantedItem);
        AttributeBonusHandler.applyDynamicAttributeBonus(player, Attributes.f_22284_, AttributeModifier.Operation.ADDITION, "8b836bea-4c28-4430-8184-7330530239f6", AttributeBonusHandler::getArmorWithEnchantedShield);
        AttributeBonusHandler.applyDynamicAttributeBonus(player, Attributes.f_22276_, AttributeModifier.Operation.ADDITION, "27b4644b-96a0-4443-89e5-1700af61d602", AttributeBonusHandler::getMaximumLifePerEnchantment);
        AttributeBonusHandler.applyDynamicAttributeBonus(player, Attributes.f_22284_, AttributeModifier.Operation.ADDITION, "55c3cb58-c09e-465a-a812-6a18ae587ec0", AttributeBonusHandler::getArmorPerChestplateEnchantment);
        AttributeBonusHandler.applyDynamicAttributeBonus(player, Attributes.f_22276_, AttributeModifier.Operation.ADDITION, "9b1e9aac-fa58-4343-ba88-7541eca2836f", AttributeBonusHandler::getMaximumLifePerArmorEnchantment);
        AttributeBonusHandler.applyDynamicAttributeBonus(player, Attributes.f_22283_, AttributeModifier.Operation.MULTIPLY_TOTAL, "5e2d6a95-bc70-4f3d-a348-307b49f5bc84", AttributeBonusHandler::getAttackSpeedWithGemInWeapon);
        AttributeBonusHandler.applyDynamicAttributeBonus(player, (Attribute)SkillTreeAttributes.BLOCK_CHANCE.get(), AttributeModifier.Operation.MULTIPLY_BASE, "bfbc3d6b-7c37-498b-888c-3b05c921f24a", AttributeBonusHandler::getBlockChanceWithEnchantedShield);
        AttributeBonusHandler.applyDynamicAttributeBonus(player, (Attribute)SkillTreeAttributes.EVASION_CHANCE.get(), AttributeModifier.Operation.MULTIPLY_BASE, "d2865c2c-d5cc-4de9-a793-752349d27da0", AttributeBonusHandler::getEvasionChanceWhenWounded);
        AttributeBonusHandler.applyDynamicAttributeBonus(player, Attributes.f_22283_, AttributeModifier.Operation.MULTIPLY_BASE, "f6dbc327-88c0-4704-b230-91fe1642dc7a", AttributeBonusHandler::getAttackSpeedIfNotHungry);
        AttributeBonusHandler.applyDynamicAttributeBonus(player, Attributes.f_22283_, AttributeModifier.Operation.MULTIPLY_BASE, "5d449ea8-12dd-4596-a6e1-e4837946acb6", AttributeBonusHandler::getAttackSpeedWithRangedWeapon);
        AttributeBonusHandler.applyDynamicAttributeBonus(player, Attributes.f_22283_, AttributeModifier.Operation.MULTIPLY_BASE, "e37a2257-8511-4ffb-a5dd-913b591dd520", AttributeBonusHandler::getAttackSpeedPerGemInWeapon);
        AttributeBonusHandler.applyDynamicAttributeBonus(player, (Attribute)SkillTreeAttributes.CRIT_CHANCE.get(), AttributeModifier.Operation.MULTIPLY_BASE, "44984187-74c8-4927-be18-1e187ca9babe", AttributeBonusHandler::getCritChanceIfNotHungry);
        AttributeBonusHandler.applyDynamicAttributeBonus(player, Attributes.f_22283_, AttributeModifier.Operation.MULTIPLY_BASE, "7bd1d9fb-4a20-41f3-89df-7cb42e849c5f", AttributeBonusHandler::getAttackWithEnchantedWeapon);
        AttributeBonusHandler.applyDynamicAttributeBonus(player, (Attribute)SkillTreeAttributes.LIFE_PER_HIT.get(), AttributeModifier.Operation.ADDITION, "9c36d4dc-06e3-4f42-b8e6-abb0fb6b344c", AttributeBonusHandler::getLifePerHitUnderPotionEffect);
        AttributeBonusHandler.applyDynamicAttributeBonus(player, Attributes.f_22276_, AttributeModifier.Operation.ADDITION, "77353761-61e2-4f3c-b0e4-2abef4b75d76", AttributeBonusHandler::getMaximumLifePerGemInHelmet);
        AttributeBonusHandler.applyDynamicAttributeBonus(player, (Attribute)SkillTreeAttributes.CRIT_CHANCE.get(), AttributeModifier.Operation.MULTIPLY_BASE, "636b118d-478b-4c4e-9785-b6e7da876828", AttributeBonusHandler::getCritChancePerGemInWeapon);
        AttributeBonusHandler.applyDynamicAttributeBonus(player, (Attribute)SkillTreeAttributes.CRIT_DAMAGE.get(), AttributeModifier.Operation.MULTIPLY_BASE, "3051c828-7281-458c-b6fc-df9d93b31d30", AttributeBonusHandler::getCritDamagePerGemInWeapon);
        AttributeBonusHandler.applyDynamicAttributeBonus(player, (Attribute)SkillTreeAttributes.LIFE_REGENERATION.get(), AttributeModifier.Operation.ADDITION, "6732aed2-1948-4e86-a83c-aad617cd4387", AttributeBonusHandler::getLifeRegenerationPerGemInHelmet);
        AttributeBonusHandler.applyDynamicAttributeBonus(player, Attributes.f_22283_, AttributeModifier.Operation.MULTIPLY_BASE, "b983bec3-a049-49d7-855e-3025b283c7d2", AttributeBonusHandler::getAttackSpeedWithShield);
        AttributeBonusHandler.applyDynamicAttributeBonus(player, (Attribute)SkillTreeAttributes.LIFE_REGENERATION.get(), AttributeModifier.Operation.ADDITION, "d86d8efb-4539-46f3-b157-672b2e1241d6", AttributeBonusHandler::getLifeRegenerationWithShield);
        AttributeBonusHandler.applyDynamicAttributeBonus(player, Attributes.f_22284_, AttributeModifier.Operation.ADDITION, "f11460ca-56f9-4cff-98ea-791ed27f6639", AttributeBonusHandler::getBonusChestplateArmor);
        AttributeBonusHandler.applyDynamicAttributeBonus(player, (Attribute)SkillTreeAttributes.LIFE_ON_BLOCK.get(), AttributeModifier.Operation.ADDITION, "6dccce60-76e9-4ca0-8497-8352ba26620d", AttributeBonusHandler::getLifeOnBlockPerShieldEnchantment);
        AttributeBonusHandler.applyDynamicAttributeBonus(player, (Attribute)SkillTreeAttributes.BLOCK_CHANCE.get(), AttributeModifier.Operation.MULTIPLY_BASE, "7ea18323-13e4-43ee-bb30-decfdc1b1299", AttributeBonusHandler::getBlockChancePerShieldEnchantment);
        AttributeBonusHandler.applyDynamicAttributeBonus(player, (Attribute)SkillTreeAttributes.BLOCK_CHANCE.get(), AttributeModifier.Operation.MULTIPLY_BASE, "629ecea2-51b4-415a-80ff-4137a0f0dce1", AttributeBonusHandler::getBlockChanceIfNotHungry);
        AttributeBonusHandler.applyDynamicAttributeBonus(player, (Attribute)SkillTreeAttributes.BLOCK_CHANCE.get(), AttributeModifier.Operation.MULTIPLY_BASE, "fb0934db-cdbb-4fa6-bf4f-d3c0c12f50be", AttributeBonusHandler::getBlockChancePerSatisfiedHunger);
        AttributeBonusHandler.applyDynamicAttributeBonus(player, (Attribute)SkillTreeAttributes.LIFE_ON_BLOCK.get(), AttributeModifier.Operation.ADDITION, "793d56a0-7d0c-4bec-a328-65d6d681ec44", AttributeBonusHandler::getLifeOnBlockIfNotHungry);
        AttributeBonusHandler.applyDynamicAttributeBonus(player, Attributes.f_22276_, AttributeModifier.Operation.ADDITION, "e529b2e9-2170-430c-b77d-cfe829f66c69", AttributeBonusHandler::getMaximumLifeIfNotHungry);
    }

    private static void applyDynamicAttributeBonus(Player player, Attribute modifiedAttribute, AttributeModifier.Operation operation, String id, Function<Player, Double> dynamicBonusFunction) {
        Double dynamicBonus = dynamicBonusFunction.apply(player);
        UUID modifierId = UUID.fromString(id);
        AttributeInstance playerAttribute = player.m_21051_(modifiedAttribute);
        AttributeModifier oldModifier = playerAttribute.m_22111_(modifierId);
        if (oldModifier != null) {
            if (oldModifier.m_22218_() == dynamicBonus.doubleValue()) {
                return;
            }
            playerAttribute.m_22120_(modifierId);
        }
        if (modifiedAttribute == Attributes.f_22276_) {
            playerAttribute.m_22125_(new AttributeModifier(modifierId, "Skill Tree Bonus", dynamicBonus.doubleValue(), operation));
            player.m_21153_(player.m_21223_());
        } else {
            playerAttribute.m_22118_(new AttributeModifier(modifierId, "Skill Tree Bonus", dynamicBonus.doubleValue(), operation));
        }
    }

    private static double getMaximumLifePerEvasion(Player player) {
        double lifePerEvasion = player.m_21133_((Attribute)SkillTreeAttributes.MAXIMUM_LIFE_PER_EVASION.get());
        double evasion = player.m_21133_((Attribute)SkillTreeAttributes.EVASION_CHANCE.get()) - 1.0;
        return evasion * lifePerEvasion * 100.0;
    }

    private static double getMaximumLifePerGemInArmor(Player player) {
        double lifePerGemInArmor = player.m_21133_((Attribute)SkillTreeAttributes.MAXIMUM_LIFE_PER_GEM_IN_ARMOR.get());
        int gemstonesInArmor = 0;
        for (int slot = 0; slot < 4; ++slot) {
            ItemStack itemInSlot = player.m_6844_(EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)slot));
            gemstonesInArmor += GemHelper.getGemsCount(itemInSlot);
        }
        return lifePerGemInArmor * (double)gemstonesInArmor;
    }

    private static double getMaximumLifePerGemInHelmet(Player player) {
        double lifePerGemInHelmet = player.m_21133_((Attribute)SkillTreeAttributes.MAXIMUM_LIFE_PER_GEM_IN_HELMET.get());
        ItemStack helmet = player.m_6844_(EquipmentSlot.HEAD);
        int gemstonesInHelmet = GemHelper.getGemsCount(helmet);
        return lifePerGemInHelmet * (double)gemstonesInHelmet;
    }

    private static double getArmorPerEvasion(Player player) {
        double armorPerEvasion = player.m_21133_((Attribute)SkillTreeAttributes.ARMOR_PER_EVASION.get());
        double evasion = player.m_21133_((Attribute)SkillTreeAttributes.EVASION_CHANCE.get()) - 1.0;
        return evasion * armorPerEvasion * 100.0;
    }

    private static double getArmorPerGemInChestplate(Player player) {
        double armorPerGemInChestplate = player.m_21133_((Attribute)SkillTreeAttributes.ARMOR_PER_GEM_IN_CHESTPLATE.get());
        int getmstonesInChestplate = GemHelper.getGemsCount(player.m_6844_(EquipmentSlot.CHEST));
        return armorPerGemInChestplate * (double)getmstonesInChestplate;
    }

    private static double getArmorPerGemInHelmet(Player player) {
        double armorPerGemInHelmet = player.m_21133_((Attribute)SkillTreeAttributes.ARMOR_PER_GEM_IN_HELMET.get());
        int getmstonesInHelmet = GemHelper.getGemsCount(player.m_6844_(EquipmentSlot.HEAD));
        return armorPerGemInHelmet * (double)getmstonesInHelmet;
    }

    private static double getDamagePerArmor(Player player) {
        double damagePerArmor = player.m_21133_((Attribute)SkillTreeAttributes.ATTACK_DAMAGE_PER_ARMOR.get());
        double armor = player.m_21133_(Attributes.f_22284_);
        return damagePerArmor * armor;
    }

    private static double getMaximumLifePerArmor(Player player) {
        double maximumLifePerArmor = player.m_21133_((Attribute)SkillTreeAttributes.MAXIMUM_LIFE_PER_ARMOR.get());
        double armor = player.m_21133_(Attributes.f_22284_);
        return maximumLifePerArmor * armor;
    }

    private static double getMaximumLifePerBootsArmor(Player player) {
        double maximumLifePerBootsArmor = player.m_21133_((Attribute)SkillTreeAttributes.MAXIMUM_LIFE_PER_BOOTS_ARMOR.get());
        ItemStack boots = player.m_6844_(EquipmentSlot.FEET);
        AtomicDouble bootsArmor = new AtomicDouble();
        boots.m_41638_(EquipmentSlot.FEET).forEach((attribute, modifier) -> {
            if (attribute == Attributes.f_22284_ && modifier.m_22217_() == AttributeModifier.Operation.ADDITION) {
                bootsArmor.addAndGet(modifier.m_22218_());
            }
        });
        if (bootsArmor.get() == 0.0) {
            return 0.0;
        }
        return bootsArmor.doubleValue() * maximumLifePerBootsArmor;
    }

    private static double getMaximumLifePerSatisfiedHunger(Player player) {
        double maximumLifePerSatisfiedHunger = player.m_21133_((Attribute)SkillTreeAttributes.MAXIMUM_LIFE_PER_SATISFIED_HUNGER.get());
        int satisfiedHunger = player.m_36324_().m_38702_();
        return (double)satisfiedHunger * maximumLifePerSatisfiedHunger;
    }

    private static double getEvasionUnderPotionEffect(Player player) {
        double evasionUnderPotionEffect = player.m_21133_((Attribute)SkillTreeAttributes.EVASION_UNDER_POTION_EFFECT.get()) - 1.0;
        boolean hasPotionEffect = !player.m_21220_().isEmpty();
        return hasPotionEffect ? evasionUnderPotionEffect : 0.0;
    }

    private static double getAttackSpeedUnderPotionEffect(Player player) {
        double attackSpeedUnderPotionEffect = player.m_21133_((Attribute)SkillTreeAttributes.ATTACK_SPEED_UNDER_POTION_EFFECT.get()) - 1.0;
        boolean hasPotionEffect = !player.m_21220_().isEmpty();
        return hasPotionEffect ? attackSpeedUnderPotionEffect : 0.0;
    }

    private static double getMaximumLifeUnderPotionEffect(Player player) {
        double maximumLifeUnderPotionEffect = player.m_21133_((Attribute)SkillTreeAttributes.MAXIMUM_LIFE_UNDER_POTION_EFFECT.get());
        boolean hasPotionEffect = !player.m_21220_().isEmpty();
        return hasPotionEffect ? maximumLifeUnderPotionEffect : 0.0;
    }

    private static double getEvasionPerPotionEffect(Player player) {
        double evasionPerPotionEffect = player.m_21133_((Attribute)SkillTreeAttributes.EVASION_PER_POTION_EFFECT.get()) - 1.0;
        int potionEffectCount = player.m_21220_().size();
        return (double)potionEffectCount * evasionPerPotionEffect;
    }

    private static double getMaximumLifeWithEnchantedItem(Player player) {
        double maximumLifeWithEnchantedItem = player.m_21133_((Attribute)SkillTreeAttributes.MAXIMUM_LIFE_WITH_ENCHANTED_ITEM.get());
        for (int slot = 0; slot < 6; ++slot) {
            boolean isItemEnchanted = player.m_6844_(EquipmentSlot.values()[slot]).m_41793_();
            if (!isItemEnchanted) continue;
            return maximumLifeWithEnchantedItem;
        }
        return 0.0;
    }

    private static double getArmorWithEnchantedShield(Player player) {
        ItemStack offhandItem = player.m_21206_();
        if (!ItemHelper.isShield(offhandItem) || !offhandItem.m_41793_()) {
            return 0.0;
        }
        double armorWithEnchantedShield = player.m_21133_((Attribute)SkillTreeAttributes.ARMOR_WITH_ENCHANTED_SHIELD.get());
        return armorWithEnchantedShield;
    }

    private static double getMaximumLifePerEnchantment(Player player) {
        double maximumLifePerEnchantment = player.m_21133_((Attribute)SkillTreeAttributes.MAXIMUM_LIFE_PER_ENCHANTMENT.get());
        int enchantmentCount = 0;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack itemInSlot = player.m_6844_(slot);
            if (!itemInSlot.m_41793_()) continue;
            enchantmentCount += itemInSlot.getAllEnchantments().size();
        }
        return maximumLifePerEnchantment * (double)enchantmentCount;
    }

    private static double getArmorPerChestplateEnchantment(Player player) {
        double armorPerChestplateEnchantment = player.m_21133_((Attribute)SkillTreeAttributes.ARMOR_PER_CHESTPLATE_ENCHANTMENT.get());
        ItemStack chestplate = player.m_6844_(EquipmentSlot.CHEST);
        int enchantmentCount = chestplate.getAllEnchantments().size();
        return armorPerChestplateEnchantment * (double)enchantmentCount;
    }

    private static double getMaximumLifePerArmorEnchantment(Player player) {
        double maximumLifePerArmorEnchantment = player.m_21133_((Attribute)SkillTreeAttributes.MAXIMUM_LIFE_PER_ARMOR_ENCHANTMENT.get());
        int enchantmentCount = 0;
        for (int slot = 0; slot < 4; ++slot) {
            ItemStack itemInSlot = player.m_6844_(EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)slot));
            if (!itemInSlot.m_41793_()) continue;
            enchantmentCount += itemInSlot.getAllEnchantments().size();
        }
        return maximumLifePerArmorEnchantment * (double)enchantmentCount;
    }

    private static double getAttackSpeedWithGemInWeapon(Player player) {
        if (!GemHelper.hasGem(player.m_21205_(), 0)) {
            return 0.0;
        }
        return player.m_21133_((Attribute)SkillTreeAttributes.ATTACK_SPEED_WITH_GEM_IN_WEAPON.get()) - 1.0;
    }

    private static double getBlockChanceWithEnchantedShield(Player player) {
        ItemStack offhandItem = player.m_21206_();
        if (!ItemHelper.isShield(offhandItem) || !offhandItem.m_41793_()) {
            return 0.0;
        }
        return player.m_21133_((Attribute)SkillTreeAttributes.BLOCK_CHANCE_WITH_ENCHANTED_SHIELD.get()) - 1.0;
    }

    private static double getEvasionChanceWhenWounded(Player player) {
        boolean isWounded;
        boolean bl = isWounded = player.m_21223_() < player.m_21233_() / 2.0f;
        if (!isWounded) {
            return 0.0;
        }
        double evasionChanceWhenWounded = player.m_21133_((Attribute)SkillTreeAttributes.EVASION_CHANCE_WHEN_WOUNDED.get()) - 1.0;
        return evasionChanceWhenWounded;
    }

    private static double getAttackSpeedIfNotHungry(Player player) {
        boolean isHungry;
        boolean bl = isHungry = player.m_36324_().m_38702_() < 10;
        if (isHungry) {
            return 0.0;
        }
        double attackSpeedIfNotHungry = player.m_21133_((Attribute)SkillTreeAttributes.ATTACK_SPEED_IF_NOT_HUNGRY.get()) - 1.0;
        return attackSpeedIfNotHungry;
    }

    private static double getAttackSpeedWithRangedWeapon(Player player) {
        boolean hasRangedWeapon = ItemHelper.isRangedWeapon(player.m_21205_());
        if (!hasRangedWeapon) {
            return 0.0;
        }
        double attackSpeedWithBow = player.m_21133_((Attribute)SkillTreeAttributes.ATTACK_SPEED_WITH_RANGED_WEAPON.get()) - 1.0;
        return attackSpeedWithBow;
    }

    private static double getAttackSpeedPerGemInWeapon(Player player) {
        ItemStack mainHandItem = player.m_21205_();
        if (!ItemHelper.isWeapon(mainHandItem)) {
            return 0.0;
        }
        int gemstonesInWeapon = GemHelper.getGemsCount(mainHandItem);
        if (gemstonesInWeapon == 0) {
            return 0.0;
        }
        double attackSpeedPerGemInWeapon = player.m_21133_((Attribute)SkillTreeAttributes.ATTACK_SPEED_PER_GEM_IN_WEAPON.get()) - 1.0;
        return attackSpeedPerGemInWeapon * (double)gemstonesInWeapon;
    }

    private static double getCritChancePerGemInWeapon(Player player) {
        ItemStack mainHandItem = player.m_21205_();
        if (!ItemHelper.isWeapon(mainHandItem)) {
            return 0.0;
        }
        int gemstonesInWeapon = GemHelper.getGemsCount(mainHandItem);
        if (gemstonesInWeapon == 0) {
            return 0.0;
        }
        double critChancePerGemInWeapon = player.m_21133_((Attribute)SkillTreeAttributes.CRIT_CHANCE_PER_GEM_IN_WEAPON.get()) - 1.0;
        return critChancePerGemInWeapon * (double)gemstonesInWeapon;
    }

    private static double getCritChanceIfNotHungry(Player player) {
        boolean isHungry;
        boolean bl = isHungry = player.m_36324_().m_38702_() < 10;
        if (isHungry) {
            return 0.0;
        }
        double critChanceIfNotHungry = player.m_21133_((Attribute)SkillTreeAttributes.CRIT_CHANCE_IF_NOT_HUNGRY.get()) - 1.0;
        return critChanceIfNotHungry;
    }

    private static double getAttackWithEnchantedWeapon(Player player) {
        ItemStack mainHandItem = player.m_21205_();
        if (!ItemHelper.isWeapon(mainHandItem) || !mainHandItem.m_41793_()) {
            return 0.0;
        }
        double attackWithEnchantedWeapon = player.m_21133_((Attribute)SkillTreeAttributes.ATTACK_SPEED_WITH_ENCHANTED_WEAPON.get()) - 1.0;
        return attackWithEnchantedWeapon;
    }

    private static double getLifePerHitUnderPotionEffect(Player player) {
        double lifePerHitUnderPotionEffect = player.m_21133_((Attribute)SkillTreeAttributes.LIFE_PER_HIT_UNDER_POTION_EFFECT.get());
        boolean hasPotionEffect = !player.m_21220_().isEmpty();
        return hasPotionEffect ? lifePerHitUnderPotionEffect : 0.0;
    }

    private static double getCritDamagePerGemInWeapon(Player player) {
        ItemStack mainHandItem = player.m_21205_();
        if (!ItemHelper.isWeapon(mainHandItem)) {
            return 0.0;
        }
        int gemstonesInWeapon = GemHelper.getGemsCount(mainHandItem);
        if (gemstonesInWeapon == 0) {
            return 0.0;
        }
        double critDamagePerGemInWeapon = player.m_21133_((Attribute)SkillTreeAttributes.CRIT_DAMAGE_PER_GEM_IN_WEAPON.get()) - 1.0;
        return critDamagePerGemInWeapon * (double)gemstonesInWeapon;
    }

    private static double getLifeRegenerationPerGemInHelmet(Player player) {
        double lifeRegenerationPerGemInHelmet = player.m_21133_((Attribute)SkillTreeAttributes.LIFE_REGENERATION_PER_GEM_IN_HELMET.get());
        int getmstonesInHelmet = GemHelper.getGemsCount(player.m_6844_(EquipmentSlot.HEAD));
        return lifeRegenerationPerGemInHelmet * (double)getmstonesInHelmet;
    }

    private static double getAttackSpeedWithShield(Player player) {
        ItemStack offhandItem = player.m_21206_();
        if (!ItemHelper.isShield(offhandItem)) {
            return 0.0;
        }
        double attackSpeedWithShield = player.m_21133_((Attribute)SkillTreeAttributes.ATTACK_SPEED_WITH_SHIELD.get()) - 1.0;
        return attackSpeedWithShield;
    }

    private static double getLifeRegenerationWithShield(Player player) {
        ItemStack offhandItem = player.m_21206_();
        if (!ItemHelper.isShield(offhandItem)) {
            return 0.0;
        }
        double lifeRegenerationWithShield = player.m_21133_((Attribute)SkillTreeAttributes.LIFE_REGENERATION_WITH_SHIELD.get());
        return lifeRegenerationWithShield;
    }

    private static double getBonusChestplateArmor(Player player) {
        ItemStack chestplate = player.m_6844_(EquipmentSlot.CHEST);
        if (chestplate.m_41619_()) {
            return 0.0;
        }
        AtomicDouble chestplateArmor = new AtomicDouble();
        chestplate.m_41638_(EquipmentSlot.CHEST).forEach((attribute, modifier) -> {
            if (attribute == Attributes.f_22284_ && modifier.m_22217_() == AttributeModifier.Operation.ADDITION) {
                chestplateArmor.addAndGet(modifier.m_22218_());
            }
        });
        if (chestplateArmor.get() == 0.0) {
            return 0.0;
        }
        double bonusChestplateArmor = player.m_21133_((Attribute)SkillTreeAttributes.CHESTPLATE_ARMOR.get()) - 1.0;
        return bonusChestplateArmor * chestplateArmor.get();
    }

    private static double getLifeOnBlockPerShieldEnchantment(Player player) {
        ItemStack offhandItem = player.m_21206_();
        if (!ItemHelper.isShield(offhandItem)) {
            return 0.0;
        }
        int enchantmentsCount = offhandItem.getAllEnchantments().size();
        if (enchantmentsCount == 0) {
            return 0.0;
        }
        double lifeOnBlockPerShieldEnchantment = player.m_21133_((Attribute)SkillTreeAttributes.LIFE_ON_BLOCK_PER_SHIELD_ENCHANTMENT.get());
        return lifeOnBlockPerShieldEnchantment * (double)enchantmentsCount;
    }

    private static double getBlockChancePerShieldEnchantment(Player player) {
        ItemStack offhandItem = player.m_21206_();
        if (!ItemHelper.isShield(offhandItem)) {
            return 0.0;
        }
        int enchantmentsCount = offhandItem.getAllEnchantments().size();
        if (enchantmentsCount == 0) {
            return 0.0;
        }
        double blockChancePerShieldEnchantment = player.m_21133_((Attribute)SkillTreeAttributes.BLOCK_CHANCE_PER_SHIELD_ENCHANTMENT.get()) - 1.0;
        return blockChancePerShieldEnchantment * (double)enchantmentsCount;
    }

    private static double getBlockChanceIfNotHungry(Player player) {
        boolean isHungry;
        boolean bl = isHungry = player.m_36324_().m_38702_() < 10;
        if (isHungry) {
            return 0.0;
        }
        double blockChanceIfNotHungry = player.m_21133_((Attribute)SkillTreeAttributes.BLOCK_CHANCE_IF_NOT_HUNGRY.get()) - 1.0;
        return blockChanceIfNotHungry;
    }

    private static double getLifeOnBlockIfNotHungry(Player player) {
        boolean isHungry;
        boolean bl = isHungry = player.m_36324_().m_38702_() < 10;
        if (isHungry) {
            return 0.0;
        }
        double lifeOnBlockIfNotHungry = player.m_21133_((Attribute)SkillTreeAttributes.LIFE_ON_BLOCK_IF_NOT_HUNGRY.get());
        return lifeOnBlockIfNotHungry;
    }

    private static double getMaximumLifeIfNotHungry(Player player) {
        boolean isHungry;
        boolean bl = isHungry = player.m_36324_().m_38702_() < 10;
        if (isHungry) {
            return 0.0;
        }
        double maximumLifeIfNotHungry = player.m_21133_((Attribute)SkillTreeAttributes.MAXIMUM_LIFE_IF_NOT_HUNGRY.get());
        return maximumLifeIfNotHungry;
    }

    private static double getBlockChancePerSatisfiedHunger(Player player) {
        int satisfiedHunger = player.m_36324_().m_38702_();
        if (satisfiedHunger == 0) {
            return 0.0;
        }
        double blockChancePerSatisfiedHunger = player.m_21133_((Attribute)SkillTreeAttributes.BLOCK_CHANCE_PER_SATISFIED_HUNGER.get()) - 1.0;
        return (double)satisfiedHunger * blockChancePerSatisfiedHunger;
    }

    @SubscribeEvent
    public static void setCraftedArmorBonuses(PlayerEvent.ItemCraftedEvent event) {
        double armorEvasionBonus;
        double tougherArmorCraftingChance;
        ItemStack itemStack = event.getCrafting();
        if (!ItemHelper.isArmor(itemStack)) {
            return;
        }
        double armorDefenceBonus = event.getEntity().m_21133_((Attribute)SkillTreeAttributes.CRAFTED_ARMOR_DEFENCE.get()) - 1.0;
        if (armorDefenceBonus > 0.0) {
            ItemHelper.setDefenceBonus(itemStack, armorDefenceBonus);
        }
        if ((tougherArmorCraftingChance = event.getEntity().m_21133_((Attribute)SkillTreeAttributes.CHANCE_TO_CRAFT_TOUGHER_ARMOR.get()) - 1.0) > 0.0) {
            double bonusToughness = Math.floor(tougherArmorCraftingChance);
            tougherArmorCraftingChance -= bonusToughness;
            if ((double)event.getEntity().m_217043_().m_188501_() < tougherArmorCraftingChance) {
                bonusToughness += 1.0;
            }
            ItemHelper.setToughnessBonus(itemStack, bonusToughness);
        }
        if ((armorEvasionBonus = event.getEntity().m_21133_((Attribute)SkillTreeAttributes.CRAFTED_ARMOR_EVASION.get()) - 1.0) > 0.0) {
            ItemHelper.setEvasionBonus(itemStack, armorEvasionBonus);
        }
        double helmetAdditionalGemSlots = event.getEntity().m_21133_((Attribute)SkillTreeAttributes.CRAFTED_HELMETS_ADDITIONAL_GEMSTONE_SLOTS.get());
        if (ItemHelper.isHelmet(itemStack) && helmetAdditionalGemSlots > 0.0) {
            GemHelper.setAdditionalSocket(itemStack);
        }
    }

    @SubscribeEvent
    public static void applyArmorBonuses(ItemAttributeModifierEvent event) {
        Item item;
        if (ItemHelper.hasDefenceBonus(event.getItemStack())) {
            double defenceBonus = ItemHelper.getDefenceBonus(event.getItemStack());
            ItemHelper.applyBaseModifierBonus(event, Attributes.f_22284_, d -> d * (1.0 + defenceBonus));
        }
        if (ItemHelper.hasToughnessBonus(event.getItemStack())) {
            double toughnessBonus = ItemHelper.getToughnessBonus(event.getItemStack());
            ItemHelper.applyBaseModifierBonus(event, Attributes.f_22285_, d -> d + toughnessBonus);
        }
        if ((item = event.getItemStack().m_41720_()) instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            if (ItemHelper.hasEvasionBonus(event.getItemStack()) && event.getSlotType() == armorItem.m_40402_()) {
                String[] modifierIds = new String[]{"845DB27C-C624-495F-8C9F-6020A9A58B6B", "D8499B04-0E66-4726-AB29-64469D734E0D", "9F3D476D-C118-4544-8365-64846904B48E", "2AD3F246-FEE1-4E67-B886-69FD380BB150"};
                double evasionBonus = ItemHelper.getEvasionBonus(event.getItemStack());
                UUID modifierId = UUID.fromString(modifierIds[event.getSlotType().m_20749_()]);
                event.addModifier((Attribute)SkillTreeAttributes.EVASION_CHANCE.get(), new AttributeModifier(modifierId, "Crafted Armor Bonus", evasionBonus, AttributeModifier.Operation.MULTIPLY_BASE));
            }
        }
    }

    @SubscribeEvent
    public static void setCraftedShieldBonuses(PlayerEvent.ItemCraftedEvent event) {
        ItemStack itemStack = event.getCrafting();
        if (!ItemHelper.isShield(itemStack)) {
            return;
        }
        double shieldArmorBonus = event.getEntity().m_21133_((Attribute)SkillTreeAttributes.CRAFTED_SHIELDS_ARMOR_BONUS.get());
        if (shieldArmorBonus > 0.0) {
            ItemHelper.setDefenceBonus(itemStack, shieldArmorBonus);
        }
    }

    @SubscribeEvent
    public static void applyShieldAttributeBonuses(ItemAttributeModifierEvent event) {
        if (!ItemHelper.isShield(event.getItemStack())) {
            return;
        }
        if (event.getSlotType() != EquipmentSlot.OFFHAND) {
            return;
        }
        if (ItemHelper.hasDefenceBonus(event.getItemStack())) {
            double armorBonus = ItemHelper.getDefenceBonus(event.getItemStack());
            UUID modifierId = UUID.fromString("7174b3ef-e310-4b60-9535-eeddc741fcf5");
            AttributeModifier modifier = new AttributeModifier(modifierId, "Skill Tree Bonus", armorBonus, AttributeModifier.Operation.ADDITION);
            event.addModifier(Attributes.f_22284_, modifier);
        }
    }

    @SubscribeEvent
    public static void setCraftedWeaponBonuses(PlayerEvent.ItemCraftedEvent event) {
        double weaponAttackSpeedBonus;
        ItemStack itemStack = event.getCrafting();
        if (!ItemHelper.isMeleeWeapon(itemStack)) {
            return;
        }
        double weaponDamageBonus = event.getEntity().m_21133_((Attribute)SkillTreeAttributes.CRAFTED_MELEE_WEAPON_DAMAGE_BONUS.get());
        if (weaponDamageBonus > 0.0) {
            ItemHelper.setDamageBonus(itemStack, weaponDamageBonus);
        }
        if ((weaponAttackSpeedBonus = event.getEntity().m_21133_((Attribute)SkillTreeAttributes.CRAFTED_MELEE_WEAPON_ATTACK_SPEED.get()) - 1.0) > 0.0) {
            ItemHelper.setAttackSpeedBonus(itemStack, weaponAttackSpeedBonus);
        }
    }

    @SubscribeEvent
    public static void applyWeaponAttributeBonuses(ItemAttributeModifierEvent event) {
        if (!ItemHelper.isMeleeWeapon(event.getItemStack())) {
            return;
        }
        if (ItemHelper.hasDamageBonus(event.getItemStack())) {
            double damageBonus = ItemHelper.getDamageBonus(event.getItemStack());
            ItemHelper.applyBaseModifierBonus(event, Attributes.f_22281_, d -> d + damageBonus);
        }
        if (ItemHelper.hasAttackSpeedBonus(event.getItemStack())) {
            double attackSpeedBonus = ItemHelper.getAttackSpeedBonus(event.getItemStack());
            ItemHelper.applyBaseModifierBonus(event, Attributes.f_22283_, d -> {
                int basePlayerAttackSpeed = 4;
                double oldAttackSpeed = (double)basePlayerAttackSpeed + d;
                double newAttackSpeed = oldAttackSpeed * (1.0 + attackSpeedBonus);
                return newAttackSpeed - (double)basePlayerAttackSpeed;
            });
        }
    }

    @SubscribeEvent
    public static void applyBreakSpeedBonus(PlayerEvent.BreakSpeed event) {
        if (ItemHelper.isPickaxe(event.getEntity().m_21205_())) {
            float miningSpeedMultiplier = (float)event.getEntity().m_21133_((Attribute)SkillTreeAttributes.MINING_SPEED.get());
            event.setNewSpeed(event.getOriginalSpeed() * miningSpeedMultiplier);
        }
    }

    @SubscribeEvent
    public static void applyLifeRegenerationBonus(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END || event.player.f_19853_.f_46443_) {
            return;
        }
        if (event.player.m_36324_().m_38702_() == 0) {
            return;
        }
        float lifeRegeneration = (float)event.player.m_21133_((Attribute)SkillTreeAttributes.LIFE_REGENERATION.get());
        if (event.player.m_21223_() != event.player.m_21233_() && event.player.f_19797_ % 20 == 0) {
            event.player.m_5634_(lifeRegeneration);
            event.player.m_36324_().m_38703_(lifeRegeneration / 5.0f);
        }
    }

    @SubscribeEvent
    public static void applyEvasionBonus(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            float evasionChance = (float)player.m_21133_((Attribute)SkillTreeAttributes.EVASION_CHANCE.get()) - 1.0f;
            if (evasionChance == 0.0f) {
                return;
            }
            boolean canEvade = PlayerHelper.canEvadeDamage(event.getSource());
            if (canEvade && player.m_217043_().m_188501_() < evasionChance) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void applyLootDuplicationChanceBonus(LivingDropsEvent event) {
        boolean lootDoubled;
        if (event.getEntity() instanceof Player) {
            return;
        }
        if (!(event.getSource().m_7639_() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getSource().m_7639_();
        LivingEntity target = event.getEntity();
        double doubleLootChance = player.m_21133_((Attribute)SkillTreeAttributes.DOUBLE_LOOT_CHANCE.get()) - 1.0;
        double tripleLootChance = player.m_21133_((Attribute)SkillTreeAttributes.TRIPLE_LOOT_CHANCE.get()) - 1.0;
        if (doubleLootChance == 0.0 && tripleLootChance == 0.0) {
            return;
        }
        boolean lootTripled = (double)player.m_217043_().m_188501_() < tripleLootChance;
        boolean bl = lootDoubled = (double)player.m_217043_().m_188501_() < doubleLootChance;
        if (!lootTripled && !lootDoubled) {
            return;
        }
        ArrayList<ItemEntity> extraLoot = new ArrayList<ItemEntity>();
        event.getDrops().stream().map(ItemEntity::m_32066_).forEach(extraLoot::add);
        if (target instanceof PSTLivingEntity) {
            PSTLivingEntity pstEntity = (PSTLivingEntity)target;
            extraLoot.removeIf(pstEntity::hadEquipped);
        }
        event.getDrops().addAll(extraLoot);
        if (!lootTripled) {
            return;
        }
        event.getDrops().addAll(extraLoot.stream().map(ItemEntity::m_32066_).toList());
    }

    @SubscribeEvent
    public static void setCraftedBowsBonuses(PlayerEvent.ItemCraftedEvent event) {
        double additionalSockets;
        ItemStack itemStack = event.getCrafting();
        if (!ItemHelper.isRangedWeapon(itemStack)) {
            return;
        }
        double attackSpeedBonus = event.getEntity().m_21133_((Attribute)SkillTreeAttributes.CRAFTED_RANGED_WEAPON_ATTACK_SPEED.get()) - 1.0;
        if (attackSpeedBonus > 0.0) {
            ItemHelper.setAttackSpeedBonus(itemStack, attackSpeedBonus);
        }
        if ((additionalSockets = event.getEntity().m_21133_((Attribute)SkillTreeAttributes.CRAFTED_RANGED_WEAPON_ADDITIONAL_SOCKETS.get())) > 0.0) {
            GemHelper.setAdditionalSocket(itemStack);
        }
    }

    @SubscribeEvent
    public static void applyBowAttributeBonuses(ItemAttributeModifierEvent event) {
        if (!ItemHelper.isRangedWeapon(event.getItemStack()) || event.getSlotType() != EquipmentSlot.MAINHAND) {
            return;
        }
        UUID modifierId = (UUID)ObfuscationReflectionHelper.getPrivateValue(Item.class, null, (String)"f_41375_");
        float modifierAmount = -3.0f;
        if (ItemHelper.hasAttackSpeedBonus(event.getItemStack())) {
            double attackSpeedBonus = ItemHelper.getAttackSpeedBonus(event.getItemStack());
            modifierAmount = (float)((double)modifierAmount + attackSpeedBonus);
        }
        AttributeModifier modifier = new AttributeModifier(modifierId, "Base Attack Speed", (double)modifierAmount, AttributeModifier.Operation.ADDITION);
        event.addModifier(Attributes.f_22283_, modifier);
    }

    @SubscribeEvent
    public static void applyProjectileDamageBonus(LivingHurtEvent event) {
        if (!(event.getSource().m_7640_() instanceof Projectile)) {
            return;
        }
        if (!(event.getSource().m_7639_() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getSource().m_7639_();
        Projectile projectile = (Projectile)event.getSource().m_7640_();
        float damage = event.getAmount();
        event.setAmount(damage *= PlayerHelper.getProjectileDamageMultiplier(player, event.getEntity(), projectile));
    }

    @SubscribeEvent
    public static void setCraftedFoodBonuses(PlayerEvent.ItemCraftedEvent event) {
        if (!ItemHelper.isFood(event.getCrafting())) {
            return;
        }
        FoodHelper.setCraftedFoodBonuses(event.getCrafting(), event.getEntity());
    }

    @SubscribeEvent
    public static void setCraftedFoodBonuses(PlayerEvent.ItemSmeltedEvent event) {
        ItemStack craftedItem = event.getSmelting();
        if (!ItemHelper.isFood(craftedItem)) {
            return;
        }
        Player player = event.getEntity();
        FoodHelper.setCraftedFoodBonuses(craftedItem, player);
    }

    @SubscribeEvent
    public static void applyCraftedFoodBonuses(LivingEntityUseItemEvent.Finish event) {
        int effectAmplifier;
        int restoration;
        if (!ItemHelper.isFood(event.getItem())) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        int finalRestoration = restoration = event.getItem().getFoodProperties((LivingEntity)player).m_38744_();
        if (FoodHelper.hasRestorationBonus(event.getItem())) {
            float restorationBonus = FoodHelper.getRestorationBonus(event.getItem());
            finalRestoration = (int)((float)finalRestoration + (float)restoration * restorationBonus);
            player.m_36324_().m_38707_((int)((float)restoration * restorationBonus), 0.0f);
        }
        if (FoodHelper.hasHealingBonus(event.getItem())) {
            float healingBonus = FoodHelper.getHealingBonus(event.getItem());
            player.m_5634_(healingBonus * (float)finalRestoration);
        }
        if (FoodHelper.hasDamageBonus(event.getItem())) {
            float damageBonus = FoodHelper.getDamageBonus(event.getItem());
            effectAmplifier = (int)(damageBonus * (float)finalRestoration * 100.0f);
            MobEffectInstance damageEffect = new MobEffectInstance((MobEffect)SkillTreeEffects.DAMAGE_BONUS.get(), 1200, effectAmplifier);
            player.m_7292_(damageEffect);
        }
        if (FoodHelper.hasLifeRegenerationBonus(event.getItem())) {
            float lifeRegenerationBonus = FoodHelper.getLifeRegenerationBonus(event.getItem());
            effectAmplifier = (int)(lifeRegenerationBonus * 100.0f);
            MobEffectInstance lifeRegenerationEffect = new MobEffectInstance((MobEffect)SkillTreeEffects.LIFE_REGENERATION_BONUS.get(), 1200, effectAmplifier);
            player.m_7292_(lifeRegenerationEffect);
        }
        if (FoodHelper.hasCritDamageBonus(event.getItem())) {
            float critDamageBonus = FoodHelper.getCritDamageBonus(event.getItem());
            effectAmplifier = (int)(critDamageBonus * (float)finalRestoration * 100.0f);
            MobEffectInstance critDamageEffect = new MobEffectInstance((MobEffect)SkillTreeEffects.CRIT_DAMAGE_BONUS.get(), 1200, effectAmplifier);
            player.m_7292_(critDamageEffect);
        }
    }

    @SubscribeEvent
    public static void addFoodBonusesTooltips(ItemTooltipEvent event) {
        int restoration;
        if (!ItemHelper.isFood(event.getItemStack())) {
            return;
        }
        int finalRestoration = restoration = event.getItemStack().getFoodProperties((LivingEntity)event.getEntity()).m_38744_();
        if (FoodHelper.hasRestorationBonus(event.getItemStack())) {
            float restorationBonus = FoodHelper.getRestorationBonus(event.getItemStack());
            finalRestoration = (int)((float)finalRestoration + (float)restoration * restorationBonus);
        }
        if (FoodHelper.hasDamageBonus(event.getItemStack())) {
            float damagePerRestorationBonus = FoodHelper.getDamageBonus(event.getItemStack());
            event.getToolTip().add(Component.m_237110_((String)"food.bonus.damage", (Object[])new Object[]{(int)(damagePerRestorationBonus * (float)finalRestoration * 100.0f)}).m_130940_(ChatFormatting.BLUE));
        }
        if (FoodHelper.hasCritDamageBonus(event.getItemStack())) {
            float critDamageBonus = FoodHelper.getCritDamageBonus(event.getItemStack());
            event.getToolTip().add(Component.m_237110_((String)"food.bonus.crit_damage", (Object[])new Object[]{(int)(critDamageBonus * (float)finalRestoration * 100.0f)}).m_130940_(ChatFormatting.BLUE));
        }
        if (FoodHelper.hasLifeRegenerationBonus(event.getItemStack())) {
            float lifeRegenerationBonus = FoodHelper.getLifeRegenerationBonus(event.getItemStack());
            String formattedBonus = String.format("%.1f", Float.valueOf(lifeRegenerationBonus));
            formattedBonus = formattedBonus.replace(".0", "");
            event.getToolTip().add(Component.m_237110_((String)"food.bonus.life_regeneration", (Object[])new Object[]{formattedBonus}).m_130940_(ChatFormatting.BLUE));
        }
    }

    @SubscribeEvent
    public static void applyBlockChanceBonus(LivingAttackEvent event) {
        AbstractArrow arrow;
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (event.getAmount() <= 0.0f) {
            return;
        }
        if (event.getSource().m_19376_()) {
            return;
        }
        Entity entity = event.getSource().m_7640_();
        if (entity instanceof AbstractArrow && (arrow = (AbstractArrow)entity).m_36796_() > 0) {
            return;
        }
        Player player = (Player)event.getEntity();
        ItemStack offhandItem = player.m_21206_();
        if (!ItemHelper.isShield(offhandItem)) {
            return;
        }
        double blockChance = player.m_21133_((Attribute)SkillTreeAttributes.BLOCK_CHANCE.get()) - 1.0;
        if ((double)player.m_217043_().m_188501_() >= blockChance) {
            return;
        }
        ShieldBlockEvent shieldBlockEvent = ForgeHooks.onShieldBlock((LivingEntity)player, (DamageSource)event.getSource(), (float)event.getAmount());
        if (shieldBlockEvent.isCanceled()) {
            return;
        }
        event.setCanceled(true);
        player.f_19853_.m_7605_((Entity)player, (byte)29);
        if (shieldBlockEvent.shieldTakesDamage()) {
            PlayerHelper.hurtShield(player, offhandItem, event.getAmount());
        }
        if (event.getSource().m_19360_()) {
            return;
        }
        Entity attacker = event.getSource().m_7640_();
        if (attacker instanceof LivingEntity) {
            LivingEntity livingAttacker = (LivingEntity)attacker;
            Method blockUsingShieldMethod = ObfuscationReflectionHelper.findMethod(LivingEntity.class, (String)"m_6728_", (Class[])new Class[]{LivingEntity.class});
            try {
                blockUsingShieldMethod.invoke((Object)player, livingAttacker);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void applyHealingOnBlockBonus(ShieldBlockEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        double healingOnBlock = player.m_21133_((Attribute)SkillTreeAttributes.LIFE_ON_BLOCK.get());
        if (healingOnBlock == 0.0) {
            return;
        }
        player.m_5634_((float)healingOnBlock);
    }

    @SubscribeEvent
    public static void applyPoisonedWeaponEffects(LivingHurtEvent event) {
        DamageSource damageSource = event.getSource();
        if (!(damageSource.m_7640_() instanceof Player)) {
            return;
        }
        Player player = (Player)damageSource.m_7640_();
        ItemStack weapon = player.m_21205_();
        if (!ItemHelper.hasPoisons(weapon)) {
            return;
        }
        List<MobEffectInstance> poisons = ItemHelper.getPoisons(weapon);
        LivingEntity target = event.getEntity();
        poisons.stream().map(MobEffectInstance::new).forEach(arg_0 -> ((LivingEntity)target).m_7292_(arg_0));
    }

    @SubscribeEvent
    public static void applyPoisonedThrownTridentEffects(LivingHurtEvent event) {
        DamageSource damageSource = event.getSource();
        if (!(damageSource.m_7640_() instanceof ThrownTrident)) {
            return;
        }
        ThrownTrident trident = (ThrownTrident)damageSource.m_7640_();
        Method getPickupItemMethod = ObfuscationReflectionHelper.findMethod(AbstractArrow.class, (String)"m_7941_", (Class[])new Class[0]);
        ItemStack weapon = null;
        try {
            weapon = (ItemStack)getPickupItemMethod.invoke((Object)trident, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
        if (!ItemHelper.hasPoisons(weapon)) {
            return;
        }
        List<MobEffectInstance> poisons = ItemHelper.getPoisons(weapon);
        LivingEntity target = event.getEntity();
        poisons.stream().map(MobEffectInstance::new).forEach(arg_0 -> ((LivingEntity)target).m_7292_(arg_0));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void addPoisonedWeaponTooltips(ItemTooltipEvent event) {
        ItemStack weapon = event.getItemStack();
        if (!ItemHelper.hasPoisons(weapon)) {
            return;
        }
        event.getToolTip().add(Component.m_237119_());
        event.getToolTip().add(Component.m_237115_((String)"weapon.poisoned").m_130940_(ChatFormatting.DARK_PURPLE));
        List<MobEffectInstance> poisons = ItemHelper.getPoisons(weapon);
        poisons.stream().map(TooltipHelper::getEffectTooltip).forEach(event.getToolTip()::add);
    }

    @SubscribeEvent
    public static void applyLifePerHitBonus(LivingHurtEvent event) {
        Entity directAttacker = event.getSource().m_7640_();
        Entity indirectAttacker = event.getSource().m_7639_();
        Player player = null;
        if (directAttacker instanceof Player) {
            player = (Player)directAttacker;
        } else if (directAttacker instanceof AbstractArrow && indirectAttacker instanceof Player) {
            player = (Player)indirectAttacker;
        }
        if (player == null) {
            return;
        }
        float lifePerHit = (float)player.m_21133_((Attribute)SkillTreeAttributes.LIFE_PER_HIT.get());
        if (directAttacker instanceof AbstractArrow) {
            lifePerHit = (float)((double)lifePerHit + player.m_21133_((Attribute)SkillTreeAttributes.LIFE_PER_PROJECTILE_HIT.get()));
        }
        player.m_5634_(lifePerHit);
    }

    @SubscribeEvent
    public static void applyChanceToRetrieveArrowsBonus(LivingHurtEvent event) {
        ItemStack arrowStack;
        Entity directAttacker = event.getSource().m_7640_();
        Entity indirectAttacker = event.getSource().m_7639_();
        Player player = null;
        AbstractArrow arrow = null;
        if (directAttacker instanceof AbstractArrow && indirectAttacker instanceof Player) {
            player = (Player)indirectAttacker;
            arrow = (AbstractArrow)directAttacker;
        }
        if (player == null) {
            return;
        }
        float chanceToRetrieveArrows = (float)player.m_21133_((Attribute)SkillTreeAttributes.CHANCE_TO_RETRIEVE_ARROWS.get()) - 1.0f;
        if (player.m_217043_().m_188501_() >= chanceToRetrieveArrows) {
            return;
        }
        LivingEntity target = event.getEntity();
        CompoundTag targetData = target.getPersistentData();
        ListTag stuckArrowsData = targetData.m_128437_("StuckArrows", (int)new CompoundTag().m_7060_());
        try {
            arrowStack = (ItemStack)ObfuscationReflectionHelper.findMethod(AbstractArrow.class, (String)"m_7941_", (Class[])new Class[0]).invoke((Object)arrow, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return;
        }
        stuckArrowsData.add((Object)arrowStack.m_41739_(new CompoundTag()));
        targetData.m_128365_("StuckArrows", (Tag)stuckArrowsData);
    }

    @SubscribeEvent
    public static void retrieveArrows(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        CompoundTag entityData = entity.getPersistentData();
        ListTag stuckArrowsData = entityData.m_128437_("StuckArrows", (int)new CompoundTag().m_7060_());
        if (stuckArrowsData.isEmpty()) {
            return;
        }
        stuckArrowsData.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_).forEach(arg_0 -> ((LivingEntity)entity).m_19983_(arg_0));
    }

    @SubscribeEvent
    public static void setCraftedEquipmentBonuses(PlayerEvent.ItemCraftedEvent event) {
        ItemStack craftedStack = event.getCrafting();
        if (!ItemHelper.isEquipment(craftedStack)) {
            return;
        }
        double durabilityBonus = event.getEntity().m_21133_((Attribute)SkillTreeAttributes.CRAFTED_EQUIPMENT_DURABILITY.get()) - 1.0;
        if (durabilityBonus == 0.0) {
            return;
        }
        ItemHelper.setDurabilityBonus(craftedStack, durabilityBonus);
    }

    @SubscribeEvent
    public static void addAdditionalSocketTooltip(ItemTooltipEvent event) {
        if (GemHelper.hasAdditionalSocket(event.getItemStack())) {
            MutableComponent additionalSocketTooltip = Component.m_237115_((String)"gem.additional_socket").m_130940_(ChatFormatting.YELLOW);
            event.getToolTip().add(1, additionalSocketTooltip);
        }
    }
}

