/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.capability.skill;

import daripher.skilltree.capability.skill.IPlayerSkills;
import daripher.skilltree.data.SkillsDataReloader;
import daripher.skilltree.skill.PassiveSkill;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class PlayerSkills
implements IPlayerSkills {
    private static final UUID TREE_VERSION = UUID.fromString("77fee779-4042-4312-8aca-5776af55238e");
    private List<PassiveSkill> skills = new ArrayList<PassiveSkill>();
    private int skillPoints;
    private boolean treeReset;

    @Override
    public List<PassiveSkill> getPlayerSkills() {
        return this.skills;
    }

    @Override
    public int getSkillPoints() {
        return this.skillPoints;
    }

    @Override
    public void setSkillPoints(int skillPoints) {
        this.skillPoints = skillPoints;
    }

    @Override
    public void grantSkillPoints(int skillPoints) {
        this.skillPoints += skillPoints;
    }

    @Override
    public boolean learnSkill(ServerPlayer player, PassiveSkill passiveSkill) {
        if (this.skillPoints == 0) {
            return false;
        }
        if (this.skills.contains(passiveSkill)) {
            return false;
        }
        --this.skillPoints;
        return this.skills.add(passiveSkill);
    }

    @Override
    public boolean hasSkill(ResourceLocation skillId) {
        return this.skills.stream().map(PassiveSkill::getId).anyMatch(arg_0 -> ((ResourceLocation)skillId).equals(arg_0));
    }

    @Override
    public boolean isTreeReset() {
        return this.treeReset;
    }

    @Override
    public void setTreeReset(boolean reset) {
        this.treeReset = reset;
    }

    @Override
    public void resetTree(ServerPlayer player) {
        this.skillPoints += this.getPlayerSkills().size();
        this.getPlayerSkills().forEach(skill -> skill.getAttributeModifiers().forEach(pair -> {
            Attribute attribute = (Attribute)pair.getLeft();
            AttributeModifier modifier = (AttributeModifier)pair.getRight();
            AttributeInstance playerAttribute = player.m_21051_(attribute);
            if (playerAttribute.m_22109_(modifier)) {
                playerAttribute.m_22130_(modifier);
            }
        }));
        this.getPlayerSkills().clear();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128362_("TreeVersion", TREE_VERSION);
        tag.m_128405_("Points", this.skillPoints);
        tag.m_128379_("TreeReset", this.treeReset);
        ListTag skillTagsList = new ListTag();
        this.skills.forEach(skill -> skillTagsList.add((Object)StringTag.m_129297_((String)skill.getId().toString())));
        tag.m_128365_("Skills", (Tag)skillTagsList);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.skills.clear();
        UUID treeVersion = tag.m_128403_("TreeVersion") ? tag.m_128342_("TreeVersion") : null;
        this.skillPoints = tag.m_128451_("Points");
        ListTag skillTagsList = tag.m_128437_("Skills", (int)StringTag.m_129297_((String)"").m_7060_());
        if (!treeVersion.equals(TREE_VERSION)) {
            this.skillPoints += skillTagsList.size();
            this.treeReset = true;
        } else {
            skillTagsList.forEach(skillTag -> {
                ResourceLocation skillId = new ResourceLocation(skillTag.m_7916_());
                PassiveSkill passiveSkill = SkillsDataReloader.getSkillById(skillId);
                if (passiveSkill != null) {
                    this.skills.add(passiveSkill);
                }
            });
        }
    }
}

