/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.capability.skill;

import daripher.skilltree.capability.skill.IPlayerSkills;
import daripher.skilltree.capability.skill.PlayerSkills;
import daripher.skilltree.network.NetworkDispatcher;
import daripher.skilltree.network.message.SyncPlayerSkillsMessage;
import daripher.skilltree.network.message.SyncSkillsMessage;
import daripher.skilltree.skill.PassiveSkill;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="skilltree")
public class PlayerSkillsProvider
implements ICapabilitySerializable<CompoundTag> {
    private static final ResourceLocation CAPABILITY_ID = new ResourceLocation("skilltree", "player_skills");
    private static final Capability<IPlayerSkills> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPlayerSkills>(){});
    private LazyOptional<IPlayerSkills> optionalCapability = LazyOptional.of(() -> new PlayerSkills());

    @SubscribeEvent
    public static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            PlayerSkillsProvider capabilityProvider = new PlayerSkillsProvider();
            event.addCapability(CAPABILITY_ID, (ICapabilityProvider)capabilityProvider);
        }
    }

    @SubscribeEvent
    public static void persistThroughDeath(PlayerEvent.Clone event) {
        if (event.getEntity().f_19853_.f_46443_) {
            return;
        }
        event.getOriginal().reviveCaps();
        IPlayerSkills originalData = PlayerSkillsProvider.get(event.getOriginal());
        IPlayerSkills cloneData = PlayerSkillsProvider.get(event.getEntity());
        cloneData.deserializeNBT((Tag)((CompoundTag)originalData.serializeNBT()));
        event.getOriginal().invalidateCaps();
    }

    @SubscribeEvent
    public static void syncSkills(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getEntity().f_19853_.f_46443_) {
            NetworkDispatcher.network_channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SyncSkillsMessage());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void restoreSkillsAttributeModifiers(EntityJoinLevelEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (event.getEntity().f_19853_.f_46443_) {
            return;
        }
        Player player = (Player)event.getEntity();
        PlayerSkillsProvider.get(player).getPlayerSkills().stream().map(PassiveSkill::getAttributeModifiers).forEach(attributeAndModifierList -> attributeAndModifierList.forEach(attributeAndModifier -> {
            Attribute attribute = (Attribute)attributeAndModifier.getLeft();
            AttributeModifier modifier = (AttributeModifier)attributeAndModifier.getRight();
            AttributeInstance playerAttribute = player.m_21051_(attribute);
            if (!playerAttribute.m_22109_(modifier)) {
                playerAttribute.m_22118_(modifier);
            }
        }));
    }

    @SubscribeEvent
    public static void sendTreeResetMessage(EntityJoinLevelEvent event) {
        if (event.getEntity().f_19853_.f_46443_) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        IPlayerSkills skillsCapability = PlayerSkillsProvider.get(player);
        if (skillsCapability.isTreeReset()) {
            player.m_213846_((Component)Component.m_237115_((String)"skilltree.message.reset").m_130940_(ChatFormatting.YELLOW));
            skillsCapability.setTreeReset(false);
        }
    }

    @SubscribeEvent
    public static void syncPlayerSkills(EntityJoinLevelEvent event) {
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        NetworkDispatcher.network_channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncPlayerSkillsMessage((Player)player));
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return cap == CAPABILITY ? this.optionalCapability.cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        return (CompoundTag)((IPlayerSkills)this.optionalCapability.orElseThrow(NullPointerException::new)).serializeNBT();
    }

    public void deserializeNBT(CompoundTag compoundTag) {
        ((IPlayerSkills)this.optionalCapability.orElseThrow(NullPointerException::new)).deserializeNBT((Tag)compoundTag);
    }

    @NotNull
    public static IPlayerSkills get(Player player) {
        return (IPlayerSkills)player.getCapability(CAPABILITY).orElseThrow(NullPointerException::new);
    }
}

