/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.client;

import daripher.skilltree.skill.PassiveSkill;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class SkillTreeClientData {
    private static final Map<ResourceLocation, PassiveSkill> ALL_ASSIVE_SKILLS = new HashMap<ResourceLocation, PassiveSkill>();
    private static final Map<ResourceLocation, Map<ResourceLocation, PassiveSkill>> SKILL_TREES = new HashMap<ResourceLocation, Map<ResourceLocation, PassiveSkill>>();

    public static void loadFromByteBuf(FriendlyByteBuf buf) {
        ALL_ASSIVE_SKILLS.clear();
        SKILL_TREES.clear();
        int skillsCount = buf.readInt();
        for (int i = 0; i < skillsCount; ++i) {
            PassiveSkill passiveSkill = PassiveSkill.loadFromByteBuf(buf);
            ALL_ASSIVE_SKILLS.put(passiveSkill.getId(), passiveSkill);
            ResourceLocation skillTreeId = passiveSkill.getTreeId();
            if (SKILL_TREES.get(skillTreeId) == null) {
                SKILL_TREES.put(skillTreeId, new HashMap());
            }
            SKILL_TREES.get(skillTreeId).put(passiveSkill.getId(), passiveSkill);
        }
    }

    public static Map<ResourceLocation, PassiveSkill> getSkillsForTree(ResourceLocation skillTreeId) {
        return SKILL_TREES.get(skillTreeId);
    }
}

