/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import daripher.skilltree.capability.skill.IPlayerSkills;
import daripher.skilltree.capability.skill.PlayerSkillsProvider;
import daripher.skilltree.client.SkillTreeClientData;
import daripher.skilltree.client.widget.ProgressBar;
import daripher.skilltree.client.widget.SkillButton;
import daripher.skilltree.config.Config;
import daripher.skilltree.network.NetworkDispatcher;
import daripher.skilltree.network.message.LearnSkillMessage;
import daripher.skilltree.skill.PassiveSkill;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class SkillTreeScreen
extends Screen {
    private static final ResourceLocation CONNECTION_TEXTURE_LOCATION = new ResourceLocation("skilltree", "textures/screen/skill_connection.png");
    private static final ResourceLocation BACKGROUND_TEXTURE_LOCATION = new ResourceLocation("skilltree", "textures/screen/skill_tree_background.png");
    private static final ResourceLocation OVERLAY_TEXTURE_LOCATION = new ResourceLocation("skilltree", "textures/screen/skill_tree_overlay.png");
    protected final Map<ResourceLocation, SkillButton> skillButtons = new HashMap<ResourceLocation, SkillButton>();
    private final List<Pair<SkillButton, SkillButton>> connections = new ArrayList<Pair<SkillButton, SkillButton>>();
    private final List<SkillButton> startingPoints = new ArrayList<SkillButton>();
    private final ResourceLocation skillTreeId;
    private List<ResourceLocation> learnedSkills;
    private AbstractWidget progressBar;
    private int guiScale;
    protected double scrollSpeedX;
    protected double scrollSpeedY;
    protected double scrollX;
    protected double scrollY;
    protected int maxScrollX;
    protected int maxScrollY;
    public float renderAnimation;
    public int skillPoints;

    public SkillTreeScreen(ResourceLocation skillTreeId) {
        super((Component)Component.m_237119_());
        this.skillTreeId = skillTreeId;
        this.f_96541_ = Minecraft.m_91087_();
        this.guiScale = (Integer)this.f_96541_.f_91066_.m_231928_().m_231551_();
    }

    public void m_7856_() {
        this.m_169413_();
        this.initSkillsIfNeeded();
        this.addSkillButtons();
        this.maxScrollX -= this.f_96543_ / 2 - 80;
        this.maxScrollY -= this.f_96544_ / 2 - 80;
        if (this.maxScrollX < 0) {
            this.maxScrollX = 0;
        }
        if (this.maxScrollY < 0) {
            this.maxScrollY = 0;
        }
        this.addSkillConnections();
        this.highlightSkillsThatCanBeLearned();
        this.progressBar = new ProgressBar(this, this.f_96543_ / 2 - 117, this.f_96544_ - 18);
        this.m_142416_((GuiEventListener)this.progressBar);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.updateScroll(partialTick);
        this.renderAnimation += partialTick;
        this.m_7333_(poseStack);
        this.renderConnections(poseStack, partialTick);
        poseStack.m_85836_();
        poseStack.m_85837_(this.scrollX, this.scrollY, 0.0);
        for (Widget widget : this.f_169369_) {
            if (widget == this.progressBar) continue;
            widget.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
        poseStack.m_85849_();
        this.renderOverlay(poseStack, mouseX, mouseY, partialTick);
        this.progressBar.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.m_94729_(mouseX, mouseY).filter(SkillButton.class::isInstance).map(SkillButton.class::cast).ifPresent(button -> this.renderButtonTooltip((Button)button, poseStack, mouseX, mouseY));
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        Optional child = super.m_94729_(mouseX, mouseY);
        boolean clickedProgressBar = child.filter(ProgressBar.class::isInstance).isPresent();
        if (clickedProgressBar) {
            return super.m_6375_(mouseX, mouseY, button);
        }
        return super.m_6375_(mouseX - this.scrollX, mouseY - this.scrollY, button);
    }

    public Optional<GuiEventListener> m_94729_(double mouseX, double mouseY) {
        Optional child = super.m_94729_(mouseX, mouseY);
        if (child.filter(ProgressBar.class::isInstance).isPresent()) {
            return child;
        }
        return super.m_94729_(mouseX - this.scrollX, mouseY - this.scrollY);
    }

    protected void initSkillsIfNeeded() {
        if (this.learnedSkills != null) {
            return;
        }
        this.learnedSkills = new ArrayList<ResourceLocation>();
        IPlayerSkills skillsCapability = PlayerSkillsProvider.get((Player)this.f_96541_.f_91074_);
        skillsCapability.getPlayerSkills().stream().map(PassiveSkill::getId).forEach(this.learnedSkills::add);
        this.skillPoints = skillsCapability.getSkillPoints();
    }

    public void addSkillButtons() {
        this.startingPoints.clear();
        this.skillButtons.clear();
        SkillTreeClientData.getSkillsForTree(this.skillTreeId).forEach(this::addSkillButton);
    }

    protected void addSkillButton(ResourceLocation skillId, PassiveSkill skill) {
        int buttonX = skill.getPositionX() + this.f_96543_ / 2;
        int buttonY = skill.getPositionY() + this.f_96544_ / 2;
        SkillButton button = new SkillButton(() -> Float.valueOf(this.renderAnimation), buttonX, buttonY, skill, this::buttonPressed, this::renderButtonTooltip);
        this.m_142416_((GuiEventListener)button);
        this.skillButtons.put(skillId, button);
        if (skill.isStartingPoint()) {
            this.startingPoints.add(button);
        }
        if (this.learnedSkills.contains(skill.getId())) {
            button.highlighted = true;
        }
        if (this.maxScrollX < Mth.m_14040_((int)skill.getPositionX())) {
            this.maxScrollX = Mth.m_14040_((int)skill.getPositionX());
        }
        if (this.maxScrollY < Mth.m_14040_((int)skill.getPositionY())) {
            this.maxScrollY = Mth.m_14040_((int)skill.getPositionY());
        }
    }

    public void addSkillConnections() {
        this.connections.clear();
        SkillTreeClientData.getSkillsForTree(this.skillTreeId).forEach(this::addSkillConnection);
    }

    private void addSkillConnection(ResourceLocation skillId, PassiveSkill skill) {
        skill.getConnectedSkills().forEach(connectedSkillId -> this.connectSkills(skillId, (ResourceLocation)connectedSkillId));
    }

    protected void connectSkills(ResourceLocation skillId, ResourceLocation connectedSkillId) {
        SkillButton skillButton = this.skillButtons.get(skillId);
        SkillButton connectedSkillButton = this.skillButtons.get(connectedSkillId);
        this.connections.add((Pair<SkillButton, SkillButton>)Pair.of((Object)((Object)skillButton), (Object)((Object)connectedSkillButton)));
    }

    private void highlightSkillsThatCanBeLearned() {
        if (this.skillPoints == 0) {
            return;
        }
        if (this.learnedSkills.isEmpty()) {
            this.startingPoints.forEach(SkillButton::animate);
            return;
        }
        if (this.learnedSkills.size() >= this.getMaximumSkillPoints()) {
            return;
        }
        this.connections.forEach(this::highlightSkillIfCanLearn);
    }

    protected void highlightSkillIfCanLearn(Pair<SkillButton, SkillButton> connection) {
        SkillButton button1 = (SkillButton)((Object)connection.getLeft());
        SkillButton button2 = (SkillButton)((Object)connection.getRight());
        if (button1.highlighted == button2.highlighted) {
            return;
        }
        if (!button1.highlighted) {
            button1.animate();
        }
        if (!button2.highlighted) {
            button2.animate();
        }
    }

    public void renderButtonTooltip(Button button, PoseStack poseStack, int mouseX, int mouseY) {
        if (!(button instanceof SkillButton)) {
            return;
        }
        ItemStack borderStyleStack = ((SkillButton)button).getTooltipBorderStyleStack();
        List<MutableComponent> tooltip = ((SkillButton)button).getTooltip();
        this.renderComponentTooltip(poseStack, tooltip, mouseX, mouseY, borderStyleStack);
    }

    public void buttonPressed(Button button) {
        if (button instanceof SkillButton) {
            SkillButton skillButton = (SkillButton)button;
            this.skillButtonPressed(skillButton);
        }
    }

    protected void skillButtonPressed(SkillButton button) {
        if (button.animated) {
            this.learnSkill(button.skill);
            return;
        }
        ResourceLocation connectedTreeId = button.skill.getConnectedTreeId();
        if (connectedTreeId != null) {
            SkillTreeScreen connectedTreeScreen = new SkillTreeScreen(connectedTreeId);
            this.f_96541_.m_91152_((Screen)connectedTreeScreen);
        }
    }

    protected void learnSkill(PassiveSkill passiveSkill) {
        --this.skillPoints;
        this.learnedSkills.add(passiveSkill.getId());
        NetworkDispatcher.network_channel.sendToServer((Object)new LearnSkillMessage(passiveSkill));
        this.m_232761_();
    }

    private void updateScroll(float partialTick) {
        if (this.scrollSpeedX != 0.0) {
            this.scrollX += this.scrollSpeedX * (double)partialTick;
            this.scrollX = Math.max((double)(-this.maxScrollX), Math.min((double)this.maxScrollX, this.scrollX));
            this.scrollSpeedX *= 0.8;
        }
        if (this.scrollSpeedY != 0.0) {
            this.scrollY += this.scrollSpeedY * (double)partialTick;
            this.scrollY = Math.max((double)(-this.maxScrollY), Math.min((double)this.maxScrollY, this.scrollY));
            this.scrollSpeedY *= 0.8;
        }
    }

    private void renderOverlay(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.prepareTextureRendering(OVERLAY_TEXTURE_LOCATION);
        SkillTreeScreen.m_93143_((PoseStack)poseStack, (int)0, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)this.f_96543_, (int)this.f_96544_, (int)this.f_96543_, (int)this.f_96544_);
    }

    public void m_7333_(PoseStack poseStack) {
        this.prepareTextureRendering(BACKGROUND_TEXTURE_LOCATION);
        poseStack.m_85836_();
        poseStack.m_85837_(this.scrollX / 3.0, this.scrollY / 3.0, 0.0);
        int size = this.getBackgroundSize();
        SkillTreeScreen.m_93143_((PoseStack)poseStack, (int)((this.f_96543_ - size) / 2), (int)((this.f_96544_ - size) / 2), (int)0, (float)0.0f, (float)0.0f, (int)size, (int)size, (int)size, (int)size);
        poseStack.m_85849_();
    }

    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double dragAmountX, double dragAmountY) {
        if (mouseButton != 0 && mouseButton != 2) {
            return false;
        }
        if (this.maxScrollX > 0) {
            this.scrollSpeedX += dragAmountX * 0.25;
        }
        if (this.maxScrollY > 0) {
            this.scrollSpeedY += dragAmountY * 0.25;
        }
        return true;
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        Integer guiScale = (Integer)this.f_96541_.f_91066_.m_231928_().m_231551_();
        if (amount > 0.0 && guiScale < 4) {
            this.f_96541_.f_91066_.m_231928_().m_231514_((Object)(guiScale + 1));
        }
        if (amount < 0.0 && guiScale > 1) {
            this.f_96541_.f_91066_.m_231928_().m_231514_((Object)(guiScale - 1));
        }
        this.f_96541_.m_5741_();
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public void m_7379_() {
        this.f_96541_.f_91066_.m_231928_().m_231514_((Object)this.guiScale);
        this.f_96541_.m_5741_();
        super.m_7379_();
    }

    protected void renderConnections(PoseStack poseStack, float partialTick) {
        this.prepareTextureRendering(CONNECTION_TEXTURE_LOCATION);
        this.connections.forEach(connection -> this.renderConnection(poseStack, (Pair<SkillButton, SkillButton>)connection));
    }

    private void renderConnection(PoseStack poseStack, Pair<SkillButton, SkillButton> connection) {
        boolean isAnimated;
        poseStack.m_85836_();
        SkillButton button1 = (SkillButton)((Object)connection.getLeft());
        SkillButton button2 = (SkillButton)((Object)connection.getRight());
        int connectionX = button1.f_93620_ + button1.m_5711_() / 2;
        int connectionY = button1.f_93621_ + button1.m_93694_() / 2;
        poseStack.m_85837_((double)connectionX + this.scrollX, (double)connectionY + this.scrollY, 0.0);
        float rotation = this.getAngleBetweenButtons(button1, button2);
        poseStack.m_85845_(Vector3f.f_122227_.m_122270_(rotation));
        int length = this.getDistanceBetweenButtons(button1, button2);
        boolean highlighted = button1.highlighted && button2.highlighted;
        SkillTreeScreen.m_93160_((PoseStack)poseStack, (int)0, (int)-3, (int)length, (int)6, (float)0.0f, (float)(highlighted ? 0.0f : 6.0f), (int)length, (int)6, (int)50, (int)12);
        boolean shouldAnimate = button1.highlighted && button2.animated || button2.highlighted && button1.animated;
        boolean bl = isAnimated = !highlighted && shouldAnimate;
        if (isAnimated) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.getAnimationProgress());
            SkillTreeScreen.m_93160_((PoseStack)poseStack, (int)0, (int)-3, (int)length, (int)6, (float)0.0f, (float)0.0f, (int)length, (int)6, (int)50, (int)12);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        poseStack.m_85849_();
    }

    public void prepareTextureRendering(ResourceLocation textureLocation) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)textureLocation);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
    }

    public float getAnimationProgress() {
        return (Mth.m_14031_((float)(this.renderAnimation / 3.0f)) + 1.0f) / 2.0f;
    }

    protected float getAngleBetweenButtons(Button button1, Button button2) {
        int x1 = button1.f_93620_ + button1.m_5711_() / 2;
        int y1 = button1.f_93621_ + button1.m_93694_() / 2;
        int x2 = button2.f_93620_ + button2.m_5711_() / 2;
        int y2 = button2.f_93621_ + button2.m_93694_() / 2;
        float angle = this.getAngleBetweenPoints(x1, y1, x2, y2);
        return angle;
    }

    protected int getDistanceBetweenButtons(Button button1, Button button2) {
        int x1 = button1.f_93620_ + button1.m_5711_() / 2;
        int y1 = button1.f_93621_ + button1.m_93694_() / 2;
        int x2 = button2.f_93620_ + button2.m_5711_() / 2;
        int y2 = button2.f_93621_ + button2.m_93694_() / 2;
        return this.getDistanceBetweenPoints(x1, y1, x2, y2);
    }

    protected int getDistanceBetweenPoints(int x1, int y1, int x2, int y2) {
        return (int)Mth.m_14116_((float)((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1)));
    }

    protected float getAngleBetweenPoints(int x1, int y1, int x2, int y2) {
        return (float)Mth.m_14136_((double)(y2 - y1), (double)(x2 - x1));
    }

    protected int getBackgroundSize() {
        return 2048;
    }

    protected int getMaximumSkillPoints() {
        return Config.COMMON_CONFIG.getMaximumSkillPoints();
    }
}

