/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.client.screen.editor;

import com.mojang.blaze3d.vertex.PoseStack;
import daripher.skilltree.client.screen.SkillTreeScreen;
import daripher.skilltree.client.screen.editor.tool.EditorTool;
import daripher.skilltree.client.widget.EditorToolButton;
import daripher.skilltree.client.widget.SkillButton;
import daripher.skilltree.skill.PassiveSkill;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class SkillTreeEditorScreen
extends SkillTreeScreen {
    public final List<ResourceLocation> selectedSkills = new ArrayList<ResourceLocation>();
    private final List<Pair<ResourceLocation, ResourceLocation>> newConnections = new ArrayList<Pair<ResourceLocation, ResourceLocation>>();
    private EditorTool selectedTool = EditorTool.SELECT;

    public SkillTreeEditorScreen(ResourceLocation skillTreeId) {
        super(skillTreeId);
    }

    @Override
    public void m_7856_() {
        this.maxScrollX = 512;
        this.maxScrollY = 512;
        this.addSkillButtons();
        this.addSkillConnections();
        this.addToolButtons();
    }

    @Override
    public void addSkillConnections() {
        super.addSkillConnections();
        this.newConnections.forEach(idPair -> this.connectSkills((ResourceLocation)idPair.getLeft(), (ResourceLocation)idPair.getRight()));
    }

    @Override
    protected void addSkillButton(ResourceLocation skillId, PassiveSkill skill) {
        int buttonX = (int)((double)skill.getPositionX() + this.scrollX + (double)(this.f_96543_ / 2));
        int buttonY = (int)((double)skill.getPositionY() + this.scrollY + (double)(this.f_96544_ / 2));
        SkillButton button = new SkillButton(() -> Float.valueOf(this.renderAnimation), buttonX, buttonY, skill, this::buttonPressed, this::renderButtonTooltip);
        this.m_142416_((GuiEventListener)button);
        this.skillButtons.put(skillId, button);
        if (this.selectedSkills.contains(skill.getId())) {
            button.highlighted = true;
        }
    }

    private void addToolButtons() {
        this.m_142416_((GuiEventListener)new EditorToolButton(this, EditorTool.SELECT, 0, 0));
        this.m_142416_((GuiEventListener)new EditorToolButton(this, EditorTool.CONNECT, 0, 15));
    }

    @Override
    public void renderButtonTooltip(Button button, PoseStack poseStack, int mouseX, int mouseY) {
        if (!(button instanceof SkillButton)) {
            return;
        }
        ItemStack borderStyleStack = ((SkillButton)button).getTooltipBorderStyleStack();
        List<MutableComponent> tooltip = ((SkillButton)button).getTooltip();
        this.renderComponentTooltip(poseStack, tooltip, mouseX, mouseY, borderStyleStack);
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.renderAnimation += partialTick;
        this.m_7333_(poseStack);
        this.renderConnections(poseStack, partialTick);
        for (Widget widget : this.f_169369_) {
            widget.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
    }

    @Override
    protected void skillButtonPressed(SkillButton button) {
        this.selectedTool.skillButtonPressed(this, button);
        this.m_232761_();
    }

    @Override
    public void buttonPressed(Button button) {
        if (button instanceof EditorToolButton) {
            EditorToolButton toolButton = (EditorToolButton)button;
            this.toolButtonPressed(toolButton);
        }
        super.buttonPressed(button);
    }

    public void toolButtonPressed(EditorToolButton button) {
        this.selectedTool = button.tool;
        button.tool.toolSelected(this);
    }

    public void addNewConnection(ResourceLocation skillId1, ResourceLocation skillId2) {
        this.newConnections.add((Pair<ResourceLocation, ResourceLocation>)Pair.of((Object)skillId1, (Object)skillId2));
    }

    public void m_232761_() {
        super.m_232761_();
    }
}

