/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.client.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import daripher.skilltree.capability.skill.IPlayerSkills;
import daripher.skilltree.capability.skill.PlayerSkillsProvider;
import daripher.skilltree.client.screen.SkillTreeScreen;
import daripher.skilltree.config.Config;
import daripher.skilltree.network.NetworkDispatcher;
import daripher.skilltree.network.message.GainSkillPointMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ProgressBar
extends Button {
    private static final ResourceLocation WIDGETS_LOCATION = new ResourceLocation("skilltree", "textures/screen/skill_tree_widgets.png");
    private static final Style EXPERIENCE_COLOR = Style.f_131099_.m_178520_(16573030);
    private final SkillTreeScreen parentScreen;

    public ProgressBar(SkillTreeScreen parentScreen, int x, int y) {
        super(x, y, 235, 19, (Component)Component.m_237119_(), ProgressBar::buttonPressed);
        this.parentScreen = parentScreen;
    }

    public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.renderExperienceBar(poseStack);
        if (this.m_198029_()) {
            this.m_7428_(poseStack, mouseX, mouseY);
        }
    }

    protected void renderExperienceBar(PoseStack poseStack) {
        this.renderExperienceBarBackground(poseStack);
        this.renderCurrentLevel(poseStack);
        this.renderNextLevel(poseStack);
        this.renderExperienceProgress(poseStack);
    }

    protected void renderExperienceBarBackground(PoseStack poseStack) {
        float experienceProgress = this.getExperienceProgress();
        int filledBarWidth = (int)(experienceProgress * 183.0f);
        this.parentScreen.prepareTextureRendering(WIDGETS_LOCATION);
        this.m_93228_(poseStack, this.f_93620_ + 26, this.f_93621_ + 7, 0, 0, 182, 5);
        if (filledBarWidth == 0) {
            return;
        }
        this.m_93228_(poseStack, this.f_93620_ + 26, this.f_93621_ + 7, 0, 5, filledBarWidth, 5);
    }

    protected void renderExperienceProgress(PoseStack poseStack) {
        float experienceProgress = this.getExperienceProgress();
        String percentageText = (int)(experienceProgress * 100.0f) + "%";
        this.drawCenteredOutlinedText(poseStack, percentageText, this.getMinecraftFont(), this.f_93620_ + this.f_93618_ / 2, this.getTextY());
    }

    protected void renderNextLevel(PoseStack poseStack) {
        int currentLevel = ProgressBar.getCurrentLevel();
        if (ProgressBar.isMaxLevel(currentLevel)) {
            --currentLevel;
        }
        int nextLevel = currentLevel + 1;
        this.drawCenteredOutlinedText(poseStack, "" + nextLevel, this.getMinecraftFont(), this.f_93620_ + this.f_93618_ - 17, this.getTextY());
    }

    protected void renderCurrentLevel(PoseStack poseStack) {
        int currentLevel = ProgressBar.getCurrentLevel();
        if (ProgressBar.isMaxLevel(currentLevel)) {
            --currentLevel;
        }
        this.drawCenteredOutlinedText(poseStack, "" + currentLevel, this.getMinecraftFont(), this.f_93620_ + 17, this.getTextY());
    }

    public void m_7428_(PoseStack poseStack, int mouseX, int mouseY) {
        ItemStack borderStyleStack = new ItemStack((ItemLike)Items.f_41905_);
        ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
        Minecraft minecraft = Minecraft.m_91087_();
        IPlayerSkills skillsCapability = PlayerSkillsProvider.get((Player)minecraft.f_91074_);
        int skillPointsAvailable = skillsCapability.getSkillPoints();
        tooltip.add(Component.m_237115_((String)"widget.skill_point_progress_bar.text").m_130940_(ChatFormatting.GRAY));
        MutableComponent skillPointsComponent = Component.m_237113_((String)("" + skillPointsAvailable)).m_130948_(EXPERIENCE_COLOR);
        tooltip.add(Component.m_237110_((String)"widget.skill_point_progress_bar.points", (Object[])new Object[]{skillPointsComponent}).m_130940_(ChatFormatting.GRAY));
        int currentLevel = ProgressBar.getCurrentLevel();
        if (ProgressBar.canBuySkillPoint(currentLevel)) {
            int levelupCost = this.getLevelupCost(currentLevel);
            MutableComponent costComponent = Component.m_237113_((String)("" + levelupCost)).m_130948_(EXPERIENCE_COLOR);
            tooltip.add(Component.m_237110_((String)"widget.skill_point_progress_bar.buy", (Object[])new Object[]{costComponent}).m_130940_(ChatFormatting.GRAY));
        }
        this.parentScreen.renderComponentTooltip(poseStack, tooltip, mouseX, mouseY, borderStyleStack);
    }

    private static void buttonPressed(Button button) {
        int currentLevel = ProgressBar.getCurrentLevel();
        if (!ProgressBar.canBuySkillPoint(currentLevel)) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        List<? extends Integer> skillCosts = Config.COMMON_CONFIG.getSkillPointCosts();
        NetworkDispatcher.network_channel.sendToServer((Object)new GainSkillPointMessage());
        minecraft.f_91074_.m_6756_(-skillCosts.get(currentLevel).intValue());
    }

    private static boolean canBuySkillPoint(int currentLevel) {
        if (!Config.COMMON_CONFIG.experienceGainEnabled()) {
            return false;
        }
        if (ProgressBar.isMaxLevel(currentLevel)) {
            return false;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        List<? extends Integer> skillCosts = Config.COMMON_CONFIG.getSkillPointCosts();
        return minecraft.f_91074_.f_36079_ >= skillCosts.get(currentLevel);
    }

    protected int getTextY() {
        return this.f_93621_ + 6;
    }

    private static int getCurrentLevel() {
        Minecraft minecraft = Minecraft.m_91087_();
        IPlayerSkills skillsCapability = PlayerSkillsProvider.get((Player)minecraft.f_91074_);
        int learnedSkills = skillsCapability.getPlayerSkills().size();
        int skillPoints = skillsCapability.getSkillPoints();
        int currentLevel = learnedSkills + skillPoints;
        return currentLevel;
    }

    private static boolean isMaxLevel(int currentLevel) {
        List<? extends Integer> levelupCosts = Config.COMMON_CONFIG.getSkillPointCosts();
        return currentLevel >= levelupCosts.size();
    }

    private float getExperienceProgress() {
        Minecraft minecraft = Minecraft.m_91087_();
        IPlayerSkills skillsCapability = PlayerSkillsProvider.get((Player)minecraft.f_91074_);
        int currentLevel = skillsCapability.getPlayerSkills().size() + skillsCapability.getSkillPoints();
        List<? extends Integer> levelupCosts = Config.COMMON_CONFIG.getSkillPointCosts();
        float experienceProgress = 1.0f;
        if (currentLevel < levelupCosts.size()) {
            Integer levelupCost = levelupCosts.get(currentLevel);
            experienceProgress = (float)minecraft.f_91074_.f_36079_ / (float)levelupCost.intValue();
            experienceProgress = Math.min(1.0f, experienceProgress);
        }
        return experienceProgress;
    }

    protected Font getMinecraftFont() {
        Minecraft minecraft = Minecraft.m_91087_();
        return minecraft.f_91062_;
    }

    private int getLevelupCost(int currentLevel) {
        List<? extends Integer> levelupCosts = Config.COMMON_CONFIG.getSkillPointCosts();
        return levelupCosts.get(currentLevel);
    }

    protected void drawCenteredOutlinedText(PoseStack poseStack, String text, Font font, int x, int y) {
        font.m_92883_(poseStack, text, (float)((x -= font.m_92895_(text) / 2) + 1), (float)y, 0);
        font.m_92883_(poseStack, text, (float)(x - 1), (float)y, 0);
        font.m_92883_(poseStack, text, (float)x, (float)(y + 1), 0);
        font.m_92883_(poseStack, text, (float)x, (float)(y - 1), 0);
        font.m_92883_(poseStack, text, (float)x, (float)y, 16573030);
    }
}

