/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.client.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import daripher.skilltree.skill.PassiveSkill;
import daripher.skilltree.util.TooltipHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.tuple.Pair;

public class SkillButton
extends Button {
    private static final ResourceLocation TITLE_FONT = new ResourceLocation("skilltree", "skill_title");
    private static final ResourceLocation DESCRIPTION_FONT = new ResourceLocation("skilltree", "skill_description");
    private static final Style LESSER_TITLE_STYLE = Style.f_131099_.m_178520_(15376745).m_131150_(TITLE_FONT);
    private static final Style NOTABLE_TITLE_STYLE = Style.f_131099_.m_178520_(13798130).m_131150_(TITLE_FONT);
    private static final Style KEYSTONE_TITLE_STYLE = Style.f_131099_.m_178520_(16766815).m_131150_(TITLE_FONT);
    private static final Style DESCRIPTION_STYLE = Style.f_131099_.m_178520_(8092645).m_131150_(DESCRIPTION_FONT);
    private final Supplier<Float> animationFunction;
    public final PassiveSkill skill;
    public boolean highlighted;
    public boolean animated;

    public SkillButton(Supplier<Float> animationFunction, int x, int y, PassiveSkill passiveSkill, Button.OnPress pressFunction, Button.OnTooltip tooltipFunction) {
        super(x, y, passiveSkill.getButtonSize(), passiveSkill.getButtonSize(), (Component)Component.m_237119_(), pressFunction, tooltipFunction);
        this.skill = passiveSkill;
        this.animationFunction = animationFunction;
    }

    public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.prepareTextureRendering(this.skill.getBackgroundTexture());
        SkillButton.m_93160_((PoseStack)poseStack, (int)this.f_93620_, (int)this.f_93621_, (int)this.f_93618_, (int)this.f_93619_, (float)0.0f, (float)0.0f, (int)this.f_93618_, (int)this.f_93619_, (int)(this.f_93618_ * 3), (int)this.f_93619_);
        float iconSize = (float)this.f_93618_ / 34.0f;
        poseStack.m_85836_();
        poseStack.m_85837_((double)(this.f_93620_ + this.f_93618_ / 2), (double)(this.f_93621_ + this.f_93619_ / 2), 0.0);
        poseStack.m_85841_(iconSize, iconSize, 1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.skill.getIconTexture());
        SkillButton.m_93160_((PoseStack)poseStack, (int)-8, (int)-8, (int)16, (int)16, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        poseStack.m_85849_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.skill.getBackgroundTexture());
        SkillButton.m_93160_((PoseStack)poseStack, (int)this.f_93620_, (int)this.f_93621_, (int)this.f_93618_, (int)this.f_93619_, (float)(this.f_93618_ + (this.highlighted ? this.f_93618_ : 0)), (float)0.0f, (int)this.f_93618_, (int)this.f_93619_, (int)(this.f_93618_ * 3), (int)this.f_93619_);
        if (this.animated) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.animationFunction.get().floatValue());
            SkillButton.m_93160_((PoseStack)poseStack, (int)this.f_93620_, (int)this.f_93621_, (int)this.f_93618_, (int)this.f_93619_, (float)(this.f_93618_ * 2), (float)0.0f, (int)this.f_93618_, (int)this.f_93619_, (int)(this.f_93618_ * 3), (int)this.f_93619_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void prepareTextureRendering(ResourceLocation textureLocation) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)textureLocation);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
    }

    public List<MutableComponent> getTooltip() {
        ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
        this.addTitleTooltip(tooltip);
        this.addDescriptionTooltip(tooltip);
        Minecraft minecraft = Minecraft.m_91087_();
        boolean useAdvancedTooltip = minecraft.f_91066_.f_92125_;
        if (useAdvancedTooltip) {
            this.addAdvancedTooltip(tooltip);
        }
        return tooltip;
    }

    protected void addAdvancedTooltip(ArrayList<MutableComponent> tooltip) {
        this.addIdTooltip(tooltip);
        String descriptionId = this.getSkillId() + ".description";
        String description = Component.m_237115_((String)descriptionId).getString();
        if (!description.equals(descriptionId)) {
            this.addAttributeModifiersTooltip(tooltip);
        }
    }

    protected void addDescriptionTooltip(ArrayList<MutableComponent> tooltip) {
        String descriptionId = this.getSkillId() + ".description";
        String description = Component.m_237115_((String)descriptionId).getString();
        if (description.equals(descriptionId)) {
            this.addAttributeModifiersTooltip(tooltip);
        } else {
            List<String> descriptionStrings = Arrays.asList(description.split("/n"));
            descriptionStrings.stream().map(Component::m_237115_).map(this::applyDescriptionStyle).forEach(tooltip::add);
        }
    }

    protected void addTitleTooltip(ArrayList<MutableComponent> tooltip) {
        boolean hasAttributeModifiers;
        String titleId = this.getSkillId() + ".name";
        MutableComponent title = Component.m_237115_((String)titleId);
        List<Pair<Attribute, AttributeModifier>> attributeModifiers = this.skill.getAttributeModifiers();
        boolean bl = hasAttributeModifiers = !attributeModifiers.isEmpty();
        if (titleId.equals(title.getString()) && hasAttributeModifiers) {
            title = this.generateTitle(attributeModifiers);
        }
        tooltip.add(title.m_130948_(this.getTitleStyle()));
    }

    protected MutableComponent generateTitle(List<Pair<Attribute, AttributeModifier>> attributeModifiers) {
        MutableComponent title = Component.m_237119_();
        List<MutableComponent> affectedAttributesNames = attributeModifiers.stream().map(Pair::getLeft).map(Attribute::m_22087_).map(Component::m_237115_).toList();
        title.m_7220_((Component)affectedAttributesNames.get(0));
        if (attributeModifiers.size() > 1) {
            title.m_130946_(" and ");
            title.m_7220_((Component)affectedAttributesNames.get(1));
        }
        return title;
    }

    private Style getTitleStyle() {
        return this.f_93618_ == 24 ? KEYSTONE_TITLE_STYLE : (this.f_93618_ == 20 ? NOTABLE_TITLE_STYLE : LESSER_TITLE_STYLE);
    }

    protected void addIdTooltip(ArrayList<MutableComponent> tooltip) {
        MutableComponent skillIdComponent = Component.m_237113_((String)this.skill.getId().toString()).m_130940_(ChatFormatting.DARK_GRAY);
        tooltip.add(skillIdComponent);
    }

    protected MutableComponent applyDescriptionStyle(MutableComponent component) {
        return component.m_130948_(DESCRIPTION_STYLE);
    }

    protected void addAttributeModifiersTooltip(ArrayList<MutableComponent> tooltip) {
        this.skill.getAttributeModifiers().stream().map(TooltipHelper::getAttributeBonusTooltip).map(this::applyDescriptionStyle).forEach(tooltip::add);
    }

    public void animate() {
        this.animated = true;
    }

    private String getSkillId() {
        return "skill." + this.skill.getId().m_135827_() + "." + this.skill.getId().m_135815_();
    }

    public ItemStack getTooltipBorderStyleStack() {
        Item styleItem = this.f_93618_ == 24 ? Items.f_42612_ : (this.f_93618_ == 20 ? Items.f_42748_ : Items.f_42446_);
        return new ItemStack((ItemLike)styleItem);
    }
}

