/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.compat.apotheosis;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import daripher.skilltree.init.SkillTreeAttributes;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.JsonCodecProvider;
import shadows.apotheosis.adventure.affix.socket.gem.Gem;
import shadows.apotheosis.adventure.affix.socket.gem.GemClass;
import shadows.apotheosis.adventure.affix.socket.gem.bonus.AttributeBonus;
import shadows.apotheosis.adventure.affix.socket.gem.bonus.GemBonus;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.util.StepFunction;

public class ModGemProvider
extends JsonCodecProvider<Gem> {
    private static final GemClass ARMOR_CLASS = new GemClass("any_armor", Set.of(LootCategory.BOOTS, LootCategory.CHESTPLATE, LootCategory.HELMET, LootCategory.LEGGINGS));
    private static final GemClass SHIELDS_CLASS = new GemClass("shield", Set.of(LootCategory.SHIELD));
    private static final GemClass ARMOR_OR_SHIELD_CLASS = new GemClass("armor_or_shield", Set.of(LootCategory.SHIELD, LootCategory.BOOTS, LootCategory.CHESTPLATE, LootCategory.HELMET, LootCategory.LEGGINGS));
    private static final GemClass MELEE_WEAPON_CLASS = new GemClass("melee_weapon", Set.of(LootCategory.HEAVY_WEAPON, LootCategory.PICKAXE, LootCategory.SHOVEL, LootCategory.SWORD, LootCategory.TRIDENT));
    private static final GemClass WEAPON_CLASS = new GemClass("any_weapon", Set.of(LootCategory.HEAVY_WEAPON, LootCategory.PICKAXE, LootCategory.SHOVEL, LootCategory.SWORD, LootCategory.TRIDENT, LootCategory.BOW));
    private static final GemClass BOOTS_CLASS = new GemClass("boots", Set.of(LootCategory.BOOTS));
    private static final GemClass HELMET_CLASS = new GemClass("helmet", Set.of(LootCategory.HELMET));
    private static final GemClass PICKAXE_CLASS = new GemClass("pickaxe", Set.of(LootCategory.PICKAXE));
    private static final GemClass WEAPON_WITHOUT_PICKAXE_CLASS = new GemClass("other_weapon", Set.of(LootCategory.HEAVY_WEAPON, LootCategory.SHOVEL, LootCategory.SWORD, LootCategory.TRIDENT, LootCategory.BOW));
    private static final GemClass ANITHYNG_CLASS = new GemClass("anything", Set.of(LootCategory.BOW, LootCategory.CROSSBOW, LootCategory.PICKAXE, LootCategory.SHOVEL, LootCategory.HEAVY_WEAPON, LootCategory.HELMET, LootCategory.CHESTPLATE, LootCategory.LEGGINGS, LootCategory.BOOTS, LootCategory.SHIELD, LootCategory.TRIDENT, LootCategory.SWORD));

    public ModGemProvider(DataGenerator dataGenerator, ExistingFileHelper existingFileHelper) {
        super(dataGenerator, existingFileHelper, "skilltree", (DynamicOps)JsonOps.INSTANCE, PackType.SERVER_DATA, "gems", Gem.CODEC, ModGemProvider.generateGems());
    }

    private static Map<ResourceLocation, Gem> generateGems() {
        AttributeBonus.initCodecs();
        HashMap<ResourceLocation, Gem> gems = new HashMap<ResourceLocation, Gem>();
        gems.put(new ResourceLocation("skilltree", "ruby"), ModGemProvider.createGem(new GemBonus[]{new AttributeBonus(ARMOR_CLASS, (Attribute)SkillTreeAttributes.LIFE_REGENERATION.get(), AttributeModifier.Operation.ADDITION, ModGemProvider.generateBonuses(0.1f, 5, 0.1f)), new AttributeBonus(SHIELDS_CLASS, Attributes.f_22276_, AttributeModifier.Operation.ADDITION, ModGemProvider.generateBonuses(0.5f, 5, 0.5f))}));
        gems.put(new ResourceLocation("skilltree", "onyx"), ModGemProvider.createGem(new GemBonus[]{new AttributeBonus(MELEE_WEAPON_CLASS, Attributes.f_22281_, AttributeModifier.Operation.ADDITION, ModGemProvider.generateBonuses(0.5f, 5, 0.5f)), new AttributeBonus(ARMOR_OR_SHIELD_CLASS, Attributes.f_22284_, AttributeModifier.Operation.ADDITION, ModGemProvider.generateBonuses(0.5f, 5, 0.5f))}));
        gems.put(new ResourceLocation("skilltree", "moonstone"), ModGemProvider.createGem(new GemBonus[]{new AttributeBonus(PICKAXE_CLASS, (Attribute)SkillTreeAttributes.MINING_SPEED.get(), AttributeModifier.Operation.MULTIPLY_BASE, ModGemProvider.generateBonuses(0.01f, 5, 0.02f)), new AttributeBonus(WEAPON_WITHOUT_PICKAXE_CLASS, Attributes.f_22283_, AttributeModifier.Operation.MULTIPLY_BASE, ModGemProvider.generateBonuses(0.005f, 5, 0.01f)), new AttributeBonus(BOOTS_CLASS, Attributes.f_22279_, AttributeModifier.Operation.MULTIPLY_BASE, ModGemProvider.generateBonuses(0.01f, 5, 0.01f))}));
        gems.put(new ResourceLocation("skilltree", "opal"), ModGemProvider.createGem(new GemBonus[]{new AttributeBonus(WEAPON_CLASS, (Attribute)SkillTreeAttributes.LIFE_PER_HIT.get(), AttributeModifier.Operation.ADDITION, ModGemProvider.generateBonuses(0.1f, 5, 0.1f)), new AttributeBonus(SHIELDS_CLASS, (Attribute)SkillTreeAttributes.LIFE_ON_BLOCK.get(), AttributeModifier.Operation.ADDITION, ModGemProvider.generateBonuses(0.1f, 5, 0.1f))}));
        gems.put(new ResourceLocation("skilltree", "adamite"), ModGemProvider.createGem(new GemBonus[]{new AttributeBonus(WEAPON_CLASS, (Attribute)SkillTreeAttributes.DAMAGE_AGAINST_POISONED.get(), AttributeModifier.Operation.MULTIPLY_BASE, ModGemProvider.generateBonuses(0.01f, 5, 0.015f)), new AttributeBonus(HELMET_CLASS, (Attribute)SkillTreeAttributes.CHANCE_TO_BREW_STRONGER_HARMFUL_POTION.get(), AttributeModifier.Operation.MULTIPLY_BASE, ModGemProvider.generateBonuses(0.01f, 5, 0.01f))}));
        gems.put(new ResourceLocation("skilltree", "third_eye"), ModGemProvider.createGem(0, 0.4f, true, new GemBonus[]{new AttributeBonus(HELMET_CLASS, (Attribute)SkillTreeAttributes.MAXIMUM_SOCKETS.get(), AttributeModifier.Operation.ADDITION, ModGemProvider.generateBonus(LootRarity.MYTHIC, 1.0f, 1, 0.0f))}));
        gems.put(new ResourceLocation("skilltree", "citrine"), ModGemProvider.createGem(new GemBonus[]{new AttributeBonus(ANITHYNG_CLASS, Attributes.f_22286_, AttributeModifier.Operation.ADDITION, ModGemProvider.generateBonuses(0.1f, 5, 0.15f))}));
        return gems;
    }

    private static Map<LootRarity, StepFunction> generateBonuses(float min, int steps, float step) {
        HashMap<LootRarity, StepFunction> bonuses = new HashMap<LootRarity, StepFunction>();
        LootRarity.values().stream().filter(rarity -> rarity != LootRarity.ANCIENT).forEach(rarity -> {
            StepFunction stepFunction = new StepFunction(min + (float)rarity.ordinal() * step, steps, step);
            bonuses.put((LootRarity)rarity, stepFunction);
        });
        return bonuses;
    }

    private static Map<LootRarity, StepFunction> generateBonus(LootRarity rarity, float min, int steps, float step) {
        HashMap<LootRarity, StepFunction> bonuses = new HashMap<LootRarity, StepFunction>();
        StepFunction stepFunction = new StepFunction(min + (float)rarity.ordinal() * step, steps, step);
        bonuses.put(rarity, stepFunction);
        return bonuses;
    }

    private static Gem createGem(GemBonus ... gemBonuses) {
        return ModGemProvider.createGem(1, 0.0f, false, gemBonuses);
    }

    private static Gem createGem(int weight, float quality, boolean unique, GemBonus ... gemBonuses) {
        Set<Object> dimensions = Set.of(new ResourceLocation("skilltree", "fake_dimension"));
        if (unique) {
            dimensions = Set.of();
        }
        return new Gem(weight, quality, dimensions, null, null, Arrays.asList(gemBonuses), unique, Optional.empty());
    }
}

