/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.config;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final CommonConfig COMMON_CONFIG;
    public static final ForgeConfigSpec COMMON_CONFIG_SPEC;

    public static void register() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_CONFIG_SPEC);
    }

    static {
        Pair configPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_CONFIG_SPEC = (ForgeConfigSpec)configPair.getRight();
        COMMON_CONFIG = (CommonConfig)configPair.getLeft();
    }

    public static class CommonConfig {
        private final ForgeConfigSpec.ConfigValue<Integer> maximumSkillPoints;
        private final ForgeConfigSpec.ConfigValue<Double> gemstoneDropChance;
        private final ForgeConfigSpec.ConfigValue<Boolean> showChatMessages;
        private final ForgeConfigSpec.ConfigValue<Boolean> enableExperienceGain;
        private final ForgeConfigSpec.ConfigValue<List<? extends Integer>> skillPointsCosts;
        private final ForgeConfigSpec.ConfigValue<List<? extends String>> blacklistedGemstoneContainers;

        public CommonConfig(ForgeConfigSpec.Builder builder) {
            Predicate<Object> positiveOrZeroInteger = o -> {
                Integer i;
                return o instanceof Integer && (i = (Integer)o) >= 0;
            };
            Predicate<Object> potentialItemId = o -> {
                String s;
                return o instanceof String && (s = (String)o).contains(":");
            };
            builder.push("Skill points");
            this.maximumSkillPoints = builder.defineInRange("Maximum skill points", 100, 1, 500);
            builder.comment("This list's size must be equal to maximum skill points.");
            this.skillPointsCosts = builder.defineList("Levelup costs", this.generateDefaultPointsCosts(100), positiveOrZeroInteger);
            builder.comment("Disabling this will remove chat messages when you gain a skill point.");
            this.showChatMessages = builder.define("Show chat messages", true);
            builder.comment("Warning: If you disable this make sure you make alternative way of getting skill points.");
            this.enableExperienceGain = builder.define("Enable exprerience exchange for skill points", true);
            builder.pop();
            builder.push("Gemstones");
            this.gemstoneDropChance = builder.defineInRange("Base drop chance", 0.05, 0.0, 1.0);
            builder.comment("This is how to blacklist specific items: [\"minecraft:diamond_hoe\", \"minecraft:golden_hoe\"]");
            builder.comment("You can also blacklist whole namespace like this: [\"<mod_id>:*\"]");
            builder.comment("You can also blacklist all items like this: [\"*:*\"]");
            this.blacklistedGemstoneContainers = builder.defineList("IDs of items that shouldn't have gemstone slots", new ArrayList(), potentialItemId);
            builder.pop();
        }

        private List<Integer> generateDefaultPointsCosts(int maximumPoints) {
            ArrayList<Integer> costs = new ArrayList<Integer>();
            costs.add(15);
            for (int i = 1; i < maximumPoints; ++i) {
                Integer previousCost = costs.get(costs.size() - 1);
                int cost = previousCost + 3 + i;
                costs.add(cost);
            }
            return costs;
        }

        public int getMaximumSkillPoints() {
            return (Integer)this.maximumSkillPoints.get();
        }

        public List<? extends String> getBlacklistedGemstoneContainers() {
            return (List)this.blacklistedGemstoneContainers.get();
        }

        public List<? extends Integer> getSkillPointCosts() {
            Integer maximumPoints = (Integer)this.maximumSkillPoints.get();
            if (((List)this.skillPointsCosts.get()).size() < maximumPoints) {
                this.skillPointsCosts.set(this.generateDefaultPointsCosts(maximumPoints));
            }
            return (List)this.skillPointsCosts.get();
        }

        public double getGemDropChance() {
            return (Double)this.gemstoneDropChance.get();
        }

        public boolean shouldShowChatMessages() {
            return (Boolean)this.showChatMessages.get();
        }

        public boolean experienceGainEnabled() {
            return (Boolean)this.enableExperienceGain.get();
        }
    }
}

