/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import daripher.skilltree.skill.PassiveSkill;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.storage.loot.Deserializers;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="skilltree")
public class SkillsDataReloader
extends SimpleJsonResourceReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = Deserializers.m_78800_().create();
    private static final Map<ResourceLocation, PassiveSkill> SKILLS = new HashMap<ResourceLocation, PassiveSkill>();

    public SkillsDataReloader() {
        super(GSON, "skills");
    }

    @SubscribeEvent
    public static void reloadSkills(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new SkillsDataReloader());
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        SKILLS.clear();
        map.forEach((id, json) -> {
            try {
                PassiveSkill passiveSkill = PassiveSkill.loadFromJson(id, json.getAsJsonObject());
                SKILLS.put((ResourceLocation)id, passiveSkill);
                LOGGER.info("Loading passive skill {}", id);
            }
            catch (Exception exception) {
                LOGGER.error("Couldn't parse passive skill {}", id, (Object)exception);
            }
        });
    }

    @Nullable
    public static PassiveSkill getSkillById(ResourceLocation id) {
        return SKILLS.get(id);
    }

    public static Map<ResourceLocation, PassiveSkill> getSkills() {
        return SKILLS;
    }
}

