/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.datagen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import daripher.skilltree.init.SkillTreeAttributes;
import daripher.skilltree.skill.PassiveSkill;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class ModSkillsProvider
implements DataProvider {
    private Map<ResourceLocation, PassiveSkill> data = new HashMap<ResourceLocation, PassiveSkill>();
    private String[] playerClasses = new String[]{"alchemist", "hunter", "enchanter", "cook", "blacksmith", "miner"};
    private DataGenerator dataGenerator;

    public ModSkillsProvider(DataGenerator dataGenerator) {
        this.dataGenerator = dataGenerator;
    }

    private void addSkills() {
        this.addSkill("void", "void", 24);
        this.setSkillPosition(0, null, -12.0f, 0.0f, "void");
        Arrays.stream(this.playerClasses).forEach(this::addClassSkills);
    }

    private void addClassSkills(String playerClass) {
        this.addSkill(playerClass, "class", "class", 24);
        this.addSkillBranch(playerClass, "defensive", "defensive_1", 16, 1, 8);
        this.addSkillBranch(playerClass, "offensive", "offensive_1", 16, 1, 13);
        this.addSkillBranch(playerClass, "defensive_crafting", "defensive_crafting_1", 16, 1, 7);
        this.addSkillBranch(playerClass, "offensive_crafting", "offensive_crafting_1", 16, 1, 7);
        this.addSkillBranch(playerClass, "crafting", "crafting_1", 16, 1, 3);
        this.addSkillBranch(playerClass, "life", "life_1", 16, 1, 2);
        this.addSkillBranch(playerClass, "speed", "speed_1", 16, 1, 2);
        this.addSkillBranch(playerClass, "healing", "healing_1", 16, 1, 2);
        this.addSkillBranch(playerClass, "lesser", "lesser_1", 16, 1, 6);
        this.addSkillBranch(playerClass, "crit", "crit_1", 16, 1, 2);
        this.addSkill(playerClass, "defensive_notable_1", "defensive_notable_1", 20);
        for (int i = 1; i <= 6; ++i) {
            this.addSkill(playerClass, "offensive_notable_" + i, "offensive_notable_" + i, 20);
        }
        this.addSkill(playerClass, "crafting_notable_1", "crafting_notable_1", 20);
        this.addSkill(playerClass, "life_notable_1", "life_notable_1", 20);
        this.addSkill(playerClass, "speed_notable_1", "speed_notable_1", 20);
        this.addSkill(playerClass, "healing_notable_1", "healing_notable_1", 20);
        this.addSkill(playerClass, "crit_notable_1", "crit_notable_1", 20);
        this.addSkill(playerClass, "defensive_keystone_1", "defensive_keystone_1", 24);
        this.addSkill(playerClass, "offensive_keystone_1", "offensive_keystone_1", 24);
        this.addSkill(playerClass, "defensive_crafting_keystone_1", "defensive_crafting_keystone_1", 24);
        this.addSkill(playerClass, "offensive_crafting_keystone_1", "offensive_crafting_keystone_1", 24);
        this.addSkill(playerClass, "mastery", "mastery", 24);
    }

    private void shapeSkillTree() {
        Arrays.stream(this.playerClasses).forEach(this::shapeClassTree);
        this.connectClassTrees();
    }

    private void shapeClassTree(String playerClass) {
        this.setSkillPosition(playerClass, null, 100.0f, 0.0f, "class");
        this.setSkillBranchPosition(playerClass, "class", 10, "defensive", 30.0f, 0.0f, 1, 4);
        this.setSkillBranchPosition(playerClass, "class", 10, "offensive", -30.0f, 0.0f, 1, 4);
        this.setSkillPosition(playerClass, "class", 10.0f, 120.0f, "defensive_crafting_1");
        this.setSkillPosition(playerClass, "class", 10.0f, -120.0f, "offensive_crafting_1");
        this.setSkillBranchPosition(playerClass, "defensive_crafting_1", 10, "defensive_crafting", 30.0f, 0.0f, 2, 4);
        this.setSkillBranchPosition(playerClass, "offensive_crafting_1", 10, "offensive_crafting", -30.0f, 0.0f, 2, 4);
        this.setSkillPosition(playerClass, "defensive_crafting_4", 12.0f, 30.0f, "defensive_notable_1");
        this.setSkillPosition(playerClass, "offensive_crafting_4", 12.0f, -30.0f, "offensive_notable_1");
        this.connectSkills(playerClass, "defensive_notable_1", "defensive_4");
        this.connectSkills(playerClass, "offensive_notable_1", "offensive_4");
        this.setSkillBranchPosition(playerClass, "class", 12, "crafting", 180.0f, 0.0f, 1, 2);
        this.setSkillPosition(playerClass, "crafting_2", 14.0f, 150.0f, "crafting_3");
        this.setSkillPosition(playerClass, "crafting_3", 12.0f, 30.0f, "crafting_notable_1");
        this.connectSkills(playerClass + "_crafting_3", "void");
        this.setSkillPosition(playerClass, "defensive_4", 10.0f, -90.0f, "life_1");
        this.setSkillPosition(playerClass, "offensive_4", 10.0f, 90.0f, "life_2");
        this.setSkillPosition(playerClass, "life_2", 10.0f, 90.0f, "life_notable_1");
        this.connectSkills(playerClass, "life_1", "life_notable_1");
        this.setSkillBranchPosition(playerClass, "defensive_4", 10, "defensive", 0.0f, 0.0f, 5, 8);
        this.setSkillBranchPosition(playerClass, "offensive_4", 10, "offensive", 0.0f, 0.0f, 5, 8);
        this.setSkillPosition(playerClass, "defensive_5", 10.0f, -90.0f, "speed_1");
        this.setSkillPosition(playerClass, "offensive_5", 10.0f, 90.0f, "speed_2");
        this.setSkillPosition(playerClass, "speed_2", 10.0f, 90.0f, "speed_notable_1");
        this.connectSkills(playerClass, "speed_1", "speed_notable_1");
        this.setSkillPosition(playerClass, "defensive_8", 10.0f, 0.0f, "defensive_keystone_1");
        this.setSkillPosition(playerClass, "offensive_8", 10.0f, 0.0f, "offensive_keystone_1");
        this.setSkillPosition(playerClass, "defensive_notable_1", 8.0f, 30.0f, "defensive_crafting_5");
        this.setSkillPosition(playerClass, "offensive_notable_1", 8.0f, -30.0f, "offensive_crafting_5");
        this.setSkillBranchPosition(playerClass, "defensive_crafting_5", 10, "defensive_crafting", 0.0f, 0.0f, 6, 7);
        this.setSkillBranchPosition(playerClass, "offensive_crafting_5", 10, "offensive_crafting", 0.0f, 0.0f, 6, 7);
        this.setSkillPosition(playerClass, "defensive_crafting_7", 10.0f, 0.0f, "defensive_crafting_keystone_1");
        this.setSkillPosition(playerClass, "offensive_crafting_7", 10.0f, 0.0f, "offensive_crafting_keystone_1");
        this.setSkillPosition(playerClass, "defensive_crafting_4", 10.0f, 120.0f, "healing_1");
        this.setSkillPosition(playerClass, "healing_1", 8.0f, -150.0f, "healing_notable_1");
        this.setSkillPosition(playerClass, "healing_notable_1", 8.0f, -150.0f, "healing_2");
        this.setSkillPosition(playerClass, "defensive_7", 10.0f, -90.0f, "lesser_1");
        this.setSkillPosition(playerClass, "offensive_7", 10.0f, 90.0f, "lesser_2");
        this.setSkillPosition(playerClass, "lesser_1", 10.0f, 0.0f, "lesser_3");
        this.setSkillPosition(playerClass, "lesser_2", 10.0f, 0.0f, "lesser_4");
        this.setSkillPosition(playerClass, "lesser_4", 12.0f, 90.0f, "lesser_5");
        this.connectSkills(playerClass, "lesser_5", "lesser_3");
        this.setSkillPosition(playerClass, "lesser_5", 10.0f, 0.0f, "lesser_6");
        this.setSkillPosition(playerClass, "lesser_6", 10.0f, 0.0f, "mastery");
        this.setSkillPosition(playerClass, "defensive_6", 10.0f, -90.0f, "crit_1");
        this.setSkillPosition(playerClass, "offensive_6", 10.0f, 90.0f, "crit_2");
        this.setSkillPosition(playerClass, "crit_2", 10.0f, 90.0f, "crit_notable_1");
        this.connectSkills(playerClass, "crit_1", "crit_notable_1");
        this.setSkillPosition(playerClass, "offensive_notable_1", 8.0f, -120.0f, "offensive_9");
        this.setSkillBranchPosition(playerClass, "offensive_9", 10, "offensive", -30.0f, 0.0f, 10, 13);
        for (int i = 2; i <= 6; ++i) {
            this.setSkillPosition(playerClass, "offensive_13", 12.0f, (float)(90 + i * 60), "offensive_notable_" + i);
        }
    }

    protected void connectClassTrees() {
        this.connectSkillsBetweenClasses("healing_2", "offensive_crafting_2");
        this.connectSkillsBetweenClasses("crafting_3", "crafting_2");
        this.connectSkillsBetweenClasses("defensive_notable_1", "offensive_9");
    }

    private void setSkillsAttributeModifiers() {
        this.addSkillAttributeModifier("alchemist_class", (Attribute)SkillTreeAttributes.BREWED_POTIONS_DURATION.get(), 0.4, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillBranchAttributeModifier("alchemist_defensive_crafting", (Attribute)SkillTreeAttributes.CHANCE_TO_BREW_STRONGER_BENEFICIAL_POTION.get(), 0.1, AttributeModifier.Operation.MULTIPLY_BASE, 1, 7);
        this.addSkillBranchAttributeModifier("alchemist_offensive_crafting", (Attribute)SkillTreeAttributes.CHANCE_TO_BREW_STRONGER_HARMFUL_POTION.get(), 0.1, AttributeModifier.Operation.MULTIPLY_BASE, 1, 7);
        this.addSkillBranchAttributeModifier("alchemist_defensive", (Attribute)SkillTreeAttributes.EVASION_CHANCE.get(), 0.01, AttributeModifier.Operation.MULTIPLY_BASE, 1, 8);
        this.addSkillBranchAttributeModifier("alchemist_offensive", (Attribute)SkillTreeAttributes.DAMAGE_AGAINST_POISONED.get(), 0.1, AttributeModifier.Operation.MULTIPLY_BASE, 1, 13);
        this.addSkillAttributeModifier("alchemist_defensive_notable_1", (Attribute)SkillTreeAttributes.EVASION_UNDER_POTION_EFFECT.get(), 0.1, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("alchemist_offensive_notable_1", (Attribute)SkillTreeAttributes.DAMAGE_AGAINST_POISONED.get(), 0.4, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillBranchAttributeModifier("alchemist_life", (Attribute)SkillTreeAttributes.MAXIMUM_LIFE_UNDER_POTION_EFFECT.get(), 2.0, AttributeModifier.Operation.ADDITION, 1, 2);
        this.addSkillAttributeModifier("alchemist_life_notable_1", (Attribute)SkillTreeAttributes.MAXIMUM_LIFE_UNDER_POTION_EFFECT.get(), 6.0, AttributeModifier.Operation.ADDITION);
        this.addSkillBranchAttributeModifier("alchemist_speed", (Attribute)SkillTreeAttributes.ATTACK_SPEED_UNDER_POTION_EFFECT.get(), 0.05, AttributeModifier.Operation.MULTIPLY_BASE, 1, 2);
        this.addSkillAttributeModifier("alchemist_speed_notable_1", (Attribute)SkillTreeAttributes.ATTACK_SPEED_UNDER_POTION_EFFECT.get(), 0.15, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillBranchAttributeModifier("alchemist_lesser", (Attribute)SkillTreeAttributes.BREWED_POTIONS_DURATION.get(), 0.05, AttributeModifier.Operation.MULTIPLY_BASE, 1, 6);
        this.addSkillAttributeModifier("alchemist_mastery", (Attribute)SkillTreeAttributes.CHANCE_TO_BREW_STRONGER_POTION.get(), 1.0, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillBranchAttributeModifier("alchemist_crit", (Attribute)SkillTreeAttributes.CRIT_CHANCE_AGAINST_POISONED.get(), 0.05, AttributeModifier.Operation.MULTIPLY_BASE, 1, 2);
        this.addSkillAttributeModifier("alchemist_crit_notable_1", (Attribute)SkillTreeAttributes.CRIT_DAMAGE_AGAINST_POISONED.get(), 0.2, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillBranchAttributeModifier("alchemist_crafting", (Attribute)SkillTreeAttributes.CHANCE_TO_BREW_STRONGER_POTION.get(), 0.05, AttributeModifier.Operation.MULTIPLY_BASE, 1, 3);
        this.addSkillAttributeModifier("alchemist_defensive_crafting_keystone_1", (Attribute)SkillTreeAttributes.CHANCE_TO_BREW_STRONGER_BENEFICIAL_POTION.get(), 1.3, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("alchemist_offensive_crafting_keystone_1", (Attribute)SkillTreeAttributes.CHANCE_TO_BREW_STRONGER_HARMFUL_POTION.get(), 0.3, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("alchemist_offensive_crafting_keystone_1", (Attribute)SkillTreeAttributes.CAN_POISON_WEAPONS.get(), 1.0, AttributeModifier.Operation.ADDITION);
        this.addSkillBranchAttributeModifier("alchemist_healing", (Attribute)SkillTreeAttributes.LIFE_PER_HIT.get(), 0.5, AttributeModifier.Operation.ADDITION, 1, 2);
        this.addSkillAttributeModifier("alchemist_healing_notable_1", (Attribute)SkillTreeAttributes.LIFE_PER_HIT_UNDER_POTION_EFFECT.get(), 1.0, AttributeModifier.Operation.ADDITION);
        this.addSkillAttributeModifier("alchemist_crafting_notable_1", (Attribute)SkillTreeAttributes.CAN_MIX_POTIONS.get(), 1.0, AttributeModifier.Operation.ADDITION);
        this.addSkillAttributeModifier("alchemist_defensive_keystone_1", (Attribute)SkillTreeAttributes.EVASION_PER_POTION_EFFECT.get(), 0.02, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("alchemist_offensive_keystone_1", (Attribute)SkillTreeAttributes.DAMAGE_PER_POTION_EFFECT.get(), 0.1, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("alchemist_offensive_notable_2", (Attribute)SkillTreeAttributes.DAMAGE_WITH_POISONED_WEAPON.get(), 0.2, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("alchemist_offensive_notable_3", (Attribute)SkillTreeAttributes.PROJECTILE_DAMAGE_AGAINST_POISONED.get(), 0.2, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("alchemist_offensive_notable_4", (Attribute)SkillTreeAttributes.SPLASH_POTION_DAMAGE.get(), 0.2, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("alchemist_offensive_notable_5", (Attribute)SkillTreeAttributes.DAMAGE_UNDER_POTION_EFFECT.get(), 0.2, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("alchemist_offensive_notable_6", (Attribute)SkillTreeAttributes.DAMAGE_PER_ADAMITE_IN_WEAPON.get(), 0.05, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("hunter_class", (Attribute)SkillTreeAttributes.DOUBLE_LOOT_CHANCE.get(), 0.15, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillBranchAttributeModifier("hunter_defensive_crafting", (Attribute)SkillTreeAttributes.CRAFTED_ARMOR_EVASION.get(), 0.01, AttributeModifier.Operation.MULTIPLY_BASE, 1, 7);
        this.addSkillBranchAttributeModifier("hunter_offensive_crafting", (Attribute)SkillTreeAttributes.CRAFTED_RANGED_WEAPON_ATTACK_SPEED.get(), 0.04, AttributeModifier.Operation.MULTIPLY_BASE, 1, 7);
        this.addSkillBranchAttributeModifier("hunter_defensive", (Attribute)SkillTreeAttributes.EVASION_CHANCE.get(), 0.01, AttributeModifier.Operation.MULTIPLY_BASE, 1, 8);
        this.addSkillBranchAttributeModifier("hunter_offensive", (Attribute)SkillTreeAttributes.PROJECTILE_DAMAGE.get(), 0.1, AttributeModifier.Operation.MULTIPLY_BASE, 1, 13);
        this.addSkillAttributeModifier("hunter_defensive_notable_1", (Attribute)SkillTreeAttributes.EVASION_CHANCE_WHEN_WOUNDED.get(), 0.1, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("hunter_offensive_notable_1", (Attribute)SkillTreeAttributes.PROJECTILE_DAMAGE.get(), 0.2, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillBranchAttributeModifier("hunter_life", (Attribute)SkillTreeAttributes.MAXIMUM_LIFE_PER_EVASION.get(), 0.05, AttributeModifier.Operation.ADDITION, 1, 2);
        this.addSkillAttributeModifier("hunter_life_notable_1", (Attribute)SkillTreeAttributes.MAXIMUM_LIFE_PER_EVASION.get(), 0.1, AttributeModifier.Operation.ADDITION);
        this.addSkillBranchAttributeModifier("hunter_speed", (Attribute)SkillTreeAttributes.ATTACK_SPEED_WITH_RANGED_WEAPON.get(), 0.05, AttributeModifier.Operation.MULTIPLY_BASE, 1, 2);
        this.addSkillAttributeModifier("hunter_speed_notable_1", (Attribute)SkillTreeAttributes.ATTACK_SPEED_WITH_RANGED_WEAPON.get(), 0.1, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillBranchAttributeModifier("hunter_lesser", (Attribute)SkillTreeAttributes.DOUBLE_LOOT_CHANCE.get(), 0.05, AttributeModifier.Operation.MULTIPLY_BASE, 1, 6);
        this.addSkillAttributeModifier("hunter_mastery", (Attribute)SkillTreeAttributes.TRIPLE_LOOT_CHANCE.get(), 0.05, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillBranchAttributeModifier("hunter_crit", (Attribute)SkillTreeAttributes.PROJECTILE_CRIT_CHANCE.get(), 0.05, AttributeModifier.Operation.MULTIPLY_BASE, 1, 2);
        this.addSkillAttributeModifier("hunter_crit_notable_1", (Attribute)SkillTreeAttributes.PROJECTILE_CRIT_DAMAGE.get(), 0.2, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillBranchAttributeModifier("hunter_crafting", (Attribute)SkillTreeAttributes.CHANCE_TO_RETRIEVE_ARROWS.get(), 0.05, AttributeModifier.Operation.MULTIPLY_BASE, 1, 3);
        this.addSkillAttributeModifier("hunter_defensive_crafting_keystone_1", (Attribute)SkillTreeAttributes.CRAFTED_HELMETS_ADDITIONAL_GEMSTONE_SLOTS.get(), 1.0, AttributeModifier.Operation.ADDITION);
        this.addSkillAttributeModifier("hunter_offensive_crafting_keystone_1", (Attribute)SkillTreeAttributes.CRAFTED_RANGED_WEAPON_ADDITIONAL_SOCKETS.get(), 1.0, AttributeModifier.Operation.ADDITION);
        this.addSkillBranchAttributeModifier("hunter_healing", (Attribute)SkillTreeAttributes.LIFE_PER_HIT.get(), 0.5, AttributeModifier.Operation.ADDITION, 1, 2);
        this.addSkillAttributeModifier("hunter_healing_notable_1", (Attribute)SkillTreeAttributes.LIFE_PER_PROJECTILE_HIT.get(), 1.0, AttributeModifier.Operation.ADDITION);
        this.addSkillAttributeModifier("hunter_crafting_notable_1", (Attribute)SkillTreeAttributes.CHANCE_TO_RETRIEVE_ARROWS.get(), 0.1, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("hunter_defensive_keystone_1", (Attribute)SkillTreeAttributes.ARMOR_PER_EVASION.get(), 0.25, AttributeModifier.Operation.ADDITION);
        this.addSkillAttributeModifier("hunter_offensive_keystone_1", (Attribute)SkillTreeAttributes.DAMAGE_PER_DISTANCE.get(), 0.05, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("hunter_offensive_notable_2", (Attribute)SkillTreeAttributes.BOW_DAMAGE.get(), 0.2, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("hunter_offensive_notable_3", (Attribute)SkillTreeAttributes.TIPPED_ARROW_DAMAGE.get(), 0.2, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("hunter_offensive_notable_4", (Attribute)SkillTreeAttributes.TRIDENT_DAMAGE.get(), 0.2, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("hunter_offensive_notable_5", (Attribute)SkillTreeAttributes.ARROW_DAMAGE.get(), 0.1, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("hunter_offensive_notable_6", (Attribute)SkillTreeAttributes.CROSSBOW_DAMAGE.get(), 0.2, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("miner_class", (Attribute)SkillTreeAttributes.MINING_SPEED.get(), 0.15, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillBranchAttributeModifier("miner_defensive_crafting", (Attribute)SkillTreeAttributes.GEM_POWER_IN_ARMOR.get(), 0.1, AttributeModifier.Operation.MULTIPLY_BASE, 1, 7);
        this.addSkillBranchAttributeModifier("miner_offensive_crafting", (Attribute)SkillTreeAttributes.GEM_POWER_IN_WEAPON.get(), 0.1, AttributeModifier.Operation.MULTIPLY_BASE, 1, 7);
        this.addSkillBranchAttributeModifier("miner_defensive", Attributes.f_22284_, 1.0, AttributeModifier.Operation.ADDITION, 1, 8);
        this.addSkillBranchAttributeModifier("miner_offensive", (Attribute)SkillTreeAttributes.DAMAGE_WITH_GEM_IN_WEAPON.get(), 0.1, AttributeModifier.Operation.MULTIPLY_BASE, 1, 13);
        this.addSkillAttributeModifier("miner_defensive_notable_1", (Attribute)SkillTreeAttributes.ARMOR_PER_GEM_IN_HELMET.get(), 2.0, AttributeModifier.Operation.ADDITION);
        this.addSkillAttributeModifier("miner_offensive_notable_1", (Attribute)SkillTreeAttributes.DAMAGE_WITH_GEM_IN_WEAPON.get(), 0.25, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillBranchAttributeModifier("miner_life", (Attribute)SkillTreeAttributes.MAXIMUM_LIFE_PER_GEM_IN_HELMET.get(), 1.0, AttributeModifier.Operation.ADDITION, 1, 2);
        this.addSkillAttributeModifier("miner_life_notable_1", (Attribute)SkillTreeAttributes.MAXIMUM_LIFE_PER_GEM_IN_ARMOR.get(), 1.0, AttributeModifier.Operation.ADDITION);
        this.addSkillBranchAttributeModifier("miner_speed", (Attribute)SkillTreeAttributes.ATTACK_SPEED_WITH_GEM_IN_WEAPON.get(), 0.05, AttributeModifier.Operation.MULTIPLY_BASE, 1, 2);
        this.addSkillAttributeModifier("miner_speed_notable_1", (Attribute)SkillTreeAttributes.ATTACK_SPEED_PER_GEM_IN_WEAPON.get(), 0.05, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillBranchAttributeModifier("miner_lesser", (Attribute)SkillTreeAttributes.MINING_SPEED.get(), 0.05, AttributeModifier.Operation.MULTIPLY_BASE, 1, 6);
        this.addSkillAttributeModifier("miner_mastery", (Attribute)SkillTreeAttributes.MAXIMUM_SOCKETS.get(), 1.0, AttributeModifier.Operation.ADDITION);
        this.addSkillBranchAttributeModifier("miner_crit", (Attribute)SkillTreeAttributes.CRIT_CHANCE_PER_GEM_IN_WEAPON.get(), 0.02, AttributeModifier.Operation.MULTIPLY_BASE, 1, 2);
        this.addSkillAttributeModifier("miner_crit_notable_1", (Attribute)SkillTreeAttributes.CRIT_DAMAGE_PER_GEM_IN_WEAPON.get(), 0.1, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillBranchAttributeModifier("miner_crafting", (Attribute)SkillTreeAttributes.GEM_DROP_CHANCE.get(), 0.01, AttributeModifier.Operation.MULTIPLY_BASE, 1, 3);
        this.addSkillAttributeModifier("miner_defensive_crafting_keystone_1", (Attribute)SkillTreeAttributes.GEM_POWER_IN_ARMOR.get(), 0.3, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("miner_defensive_crafting_keystone_1", (Attribute)SkillTreeAttributes.MAXIMUM_CHESTPLATE_SOCKETS.get(), 1.0, AttributeModifier.Operation.ADDITION);
        this.addSkillAttributeModifier("miner_offensive_crafting_keystone_1", (Attribute)SkillTreeAttributes.GEM_POWER_IN_WEAPON.get(), 0.3, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("miner_offensive_crafting_keystone_1", (Attribute)SkillTreeAttributes.MAXIMUM_WEAPON_SOCKETS.get(), 1.0, AttributeModifier.Operation.ADDITION);
        this.addSkillBranchAttributeModifier("miner_healing", (Attribute)SkillTreeAttributes.LIFE_REGENERATION.get(), 0.5, AttributeModifier.Operation.ADDITION, 1, 2);
        this.addSkillAttributeModifier("miner_healing_notable_1", (Attribute)SkillTreeAttributes.LIFE_REGENERATION_PER_GEM_IN_HELMET.get(), 0.5, AttributeModifier.Operation.ADDITION);
        this.addSkillAttributeModifier("miner_crafting_notable_1", (Attribute)SkillTreeAttributes.GEM_DROP_CHANCE.get(), 0.02, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("miner_defensive_keystone_1", (Attribute)SkillTreeAttributes.ARMOR_PER_GEM_IN_CHESTPLATE.get(), 5.0, AttributeModifier.Operation.ADDITION);
        this.addSkillAttributeModifier("miner_offensive_keystone_1", (Attribute)SkillTreeAttributes.DAMAGE_PER_GEM_IN_WEAPON.get(), 0.15, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("miner_offensive_notable_2", (Attribute)SkillTreeAttributes.DAMAGE_WITH_DIFFERENT_WEAPON_GEMS.get(), 0.4, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("miner_offensive_notable_3", (Attribute)SkillTreeAttributes.MELEE_DAMAGE_PER_GEM_IN_WEAPON.get(), 0.05, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("miner_offensive_notable_4", (Attribute)SkillTreeAttributes.DAMAGE_PER_IRISCITE_IN_WEAPON.get(), 0.15, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("miner_offensive_notable_5", (Attribute)SkillTreeAttributes.PROJECTILE_DAMAGE_PER_GEM_IN_WEAPON.get(), 0.05, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("miner_offensive_notable_6", (Attribute)SkillTreeAttributes.DAMAGE_WITH_SAME_WEAPON_GEMS.get(), 0.2, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("blacksmith_class", (Attribute)SkillTreeAttributes.CRAFTED_EQUIPMENT_DURABILITY.get(), 0.25, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillBranchAttributeModifier("blacksmith_defensive_crafting", (Attribute)SkillTreeAttributes.CRAFTED_ARMOR_DEFENCE.get(), 0.15, AttributeModifier.Operation.MULTIPLY_BASE, 1, 7);
        this.addSkillBranchAttributeModifier("blacksmith_offensive_crafting", (Attribute)SkillTreeAttributes.CRAFTED_MELEE_WEAPON_DAMAGE_BONUS.get(), 1.0, AttributeModifier.Operation.ADDITION, 1, 7);
        this.addSkillBranchAttributeModifier("blacksmith_defensive", Attributes.f_22284_, 1.0, AttributeModifier.Operation.ADDITION, 1, 8);
        this.addSkillBranchAttributeModifier("blacksmith_offensive", (Attribute)SkillTreeAttributes.DAMAGE_WITH_SHIELD.get(), 0.1, AttributeModifier.Operation.MULTIPLY_BASE, 1, 13);
        this.addSkillAttributeModifier("blacksmith_defensive_notable_1", Attributes.f_22284_, 10.0, AttributeModifier.Operation.ADDITION);
        this.addSkillAttributeModifier("blacksmith_offensive_notable_1", (Attribute)SkillTreeAttributes.DAMAGE_WITH_SHIELD.get(), 0.25, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillBranchAttributeModifier("blacksmith_life", (Attribute)SkillTreeAttributes.MAXIMUM_LIFE_PER_BOOTS_ARMOR.get(), 0.5, AttributeModifier.Operation.ADDITION, 1, 2);
        this.addSkillAttributeModifier("blacksmith_life_notable_1", (Attribute)SkillTreeAttributes.MAXIMUM_LIFE_PER_BOOTS_ARMOR.get(), 1.0, AttributeModifier.Operation.ADDITION);
        this.addSkillBranchAttributeModifier("blacksmith_speed", (Attribute)SkillTreeAttributes.ATTACK_SPEED_WITH_SHIELD.get(), 0.05, AttributeModifier.Operation.MULTIPLY_BASE, 1, 2);
        this.addSkillAttributeModifier("blacksmith_speed_notable_1", (Attribute)SkillTreeAttributes.ATTACK_SPEED_WITH_SHIELD.get(), 0.1, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillBranchAttributeModifier("blacksmith_lesser", (Attribute)SkillTreeAttributes.CRAFTED_EQUIPMENT_DURABILITY.get(), 0.05, AttributeModifier.Operation.MULTIPLY_BASE, 1, 6);
        this.addSkillAttributeModifier("blacksmith_mastery", (Attribute)SkillTreeAttributes.CHANCE_TO_CRAFT_TOUGHER_ARMOR.get(), 1.0, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillBranchAttributeModifier("blacksmith_crit", (Attribute)SkillTreeAttributes.CRIT_CHANCE_WITH_SHIELD.get(), 0.05, AttributeModifier.Operation.MULTIPLY_BASE, 1, 2);
        this.addSkillAttributeModifier("blacksmith_crit_notable_1", (Attribute)SkillTreeAttributes.CRIT_DAMAGE_WITH_SHIELD.get(), 0.25, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillBranchAttributeModifier("blacksmith_crafting", (Attribute)SkillTreeAttributes.CRAFTED_SHIELDS_ARMOR_BONUS.get(), 1.0, AttributeModifier.Operation.ADDITION, 1, 3);
        this.addSkillAttributeModifier("blacksmith_defensive_crafting_keystone_1", (Attribute)SkillTreeAttributes.CRAFTED_ARMOR_DEFENCE.get(), 0.45, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("blacksmith_offensive_crafting_keystone_1", (Attribute)SkillTreeAttributes.CRAFTED_MELEE_WEAPON_ATTACK_SPEED.get(), 0.25, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillBranchAttributeModifier("blacksmith_healing", (Attribute)SkillTreeAttributes.LIFE_REGENERATION.get(), 0.5, AttributeModifier.Operation.ADDITION, 1, 2);
        this.addSkillAttributeModifier("blacksmith_healing_notable_1", (Attribute)SkillTreeAttributes.LIFE_REGENERATION_WITH_SHIELD.get(), 1.0, AttributeModifier.Operation.ADDITION);
        this.addSkillAttributeModifier("blacksmith_crafting_notable_1", (Attribute)SkillTreeAttributes.CRAFTED_SHIELDS_ARMOR_BONUS.get(), 2.0, AttributeModifier.Operation.ADDITION);
        this.addSkillAttributeModifier("blacksmith_defensive_keystone_1", (Attribute)SkillTreeAttributes.CHESTPLATE_ARMOR.get(), 1.0, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("blacksmith_offensive_keystone_1", (Attribute)SkillTreeAttributes.ATTACK_DAMAGE_PER_ARMOR.get(), 0.15, AttributeModifier.Operation.ADDITION);
        this.addSkillAttributeModifier("blacksmith_offensive_notable_2", (Attribute)SkillTreeAttributes.SWORD_DAMAGE.get(), 0.25, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("blacksmith_offensive_notable_3", (Attribute)SkillTreeAttributes.MELEE_DAMAGE_WITH_SHIELD.get(), 0.2, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("blacksmith_offensive_notable_4", (Attribute)SkillTreeAttributes.TRIDENT_DAMAGE.get(), 0.25, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("blacksmith_offensive_notable_5", (Attribute)SkillTreeAttributes.PROJECTILE_DAMAGE_WITH_SHIELD.get(), 0.2, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("blacksmith_offensive_notable_6", (Attribute)SkillTreeAttributes.AXE_DAMAGE.get(), 0.2, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("enchanter_class", (Attribute)SkillTreeAttributes.ENCHANTMENT_LEVEL_REQUIREMENT_REDUCTION.get(), 0.3, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillBranchAttributeModifier("enchanter_defensive_crafting", (Attribute)SkillTreeAttributes.CHANCE_TO_APPLY_BETTER_ARMOR_ENCHANTMENT.get(), 0.1, AttributeModifier.Operation.MULTIPLY_BASE, 1, 7);
        this.addSkillBranchAttributeModifier("enchanter_offensive_crafting", (Attribute)SkillTreeAttributes.CHANCE_TO_APPLY_BETTER_WEAPON_ENCHANTMENT.get(), 0.1, AttributeModifier.Operation.MULTIPLY_BASE, 1, 7);
        this.addSkillBranchAttributeModifier("enchanter_defensive", (Attribute)SkillTreeAttributes.BLOCK_CHANCE.get(), 0.01, AttributeModifier.Operation.MULTIPLY_BASE, 1, 8);
        this.addSkillBranchAttributeModifier("enchanter_offensive", (Attribute)SkillTreeAttributes.DAMAGE_WITH_ENCHANTED_WEAPON.get(), 0.1, AttributeModifier.Operation.MULTIPLY_BASE, 1, 13);
        this.addSkillAttributeModifier("enchanter_defensive_notable_1", (Attribute)SkillTreeAttributes.BLOCK_CHANCE_WITH_ENCHANTED_SHIELD.get(), 0.1, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("enchanter_offensive_notable_1", (Attribute)SkillTreeAttributes.DAMAGE_WITH_ENCHANTED_WEAPON.get(), 0.2, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillBranchAttributeModifier("enchanter_life", (Attribute)SkillTreeAttributes.MAXIMUM_LIFE_WITH_ENCHANTED_ITEM.get(), 2.0, AttributeModifier.Operation.ADDITION, 1, 2);
        this.addSkillAttributeModifier("enchanter_life_notable_1", (Attribute)SkillTreeAttributes.MAXIMUM_LIFE_PER_ARMOR_ENCHANTMENT.get(), 1.0, AttributeModifier.Operation.ADDITION);
        this.addSkillBranchAttributeModifier("enchanter_speed", (Attribute)SkillTreeAttributes.ATTACK_SPEED_WITH_ENCHANTED_WEAPON.get(), 0.05, AttributeModifier.Operation.MULTIPLY_BASE, 1, 2);
        this.addSkillAttributeModifier("enchanter_speed_notable_1", (Attribute)SkillTreeAttributes.ATTACK_SPEED_WITH_ENCHANTED_WEAPON.get(), 0.1, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillBranchAttributeModifier("enchanter_lesser", (Attribute)SkillTreeAttributes.ENCHANTMENT_LEVEL_REQUIREMENT_REDUCTION.get(), 0.05, AttributeModifier.Operation.MULTIPLY_BASE, 1, 6);
        this.addSkillAttributeModifier("enchanter_mastery", (Attribute)SkillTreeAttributes.CHANCE_TO_APPLY_BETTER_ENCHANTMENT.get(), 1.0, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillBranchAttributeModifier("enchanter_crit", (Attribute)SkillTreeAttributes.CRIT_CHANCE_WITH_ENCHANTED_WEAPON.get(), 0.05, AttributeModifier.Operation.MULTIPLY_BASE, 1, 2);
        this.addSkillAttributeModifier("enchanter_crit_notable_1", (Attribute)SkillTreeAttributes.CRIT_DAMAGE_PER_WEAPON_ENCHANTMENT.get(), 0.05, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillBranchAttributeModifier("enchanter_crafting", (Attribute)SkillTreeAttributes.FREE_ENCHANTMENT_CHANCE.get(), 0.05, AttributeModifier.Operation.MULTIPLY_BASE, 1, 3);
        this.addSkillAttributeModifier("enchanter_defensive_crafting_keystone_1", (Attribute)SkillTreeAttributes.CHANCE_TO_APPLY_BETTER_ARMOR_ENCHANTMENT.get(), 0.4, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("enchanter_offensive_crafting_keystone_1", (Attribute)SkillTreeAttributes.CHANCE_TO_APPLY_BETTER_WEAPON_ENCHANTMENT.get(), 0.4, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillBranchAttributeModifier("enchanter_healing", (Attribute)SkillTreeAttributes.LIFE_ON_BLOCK.get(), 0.5, AttributeModifier.Operation.ADDITION, 1, 2);
        this.addSkillAttributeModifier("enchanter_healing_notable_1", (Attribute)SkillTreeAttributes.LIFE_ON_BLOCK_PER_SHIELD_ENCHANTMENT.get(), 0.5, AttributeModifier.Operation.ADDITION);
        this.addSkillAttributeModifier("enchanter_crafting_notable_1", (Attribute)SkillTreeAttributes.FREE_ENCHANTMENT_CHANCE.get(), 0.1, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("enchanter_defensive_keystone_1", (Attribute)SkillTreeAttributes.BLOCK_CHANCE_PER_SHIELD_ENCHANTMENT.get(), 0.05, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("enchanter_offensive_keystone_1", (Attribute)SkillTreeAttributes.DAMAGE_PER_WEAPON_ENCHANTMENT_LEVEL.get(), 0.05, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("enchanter_offensive_notable_2", (Attribute)SkillTreeAttributes.ENCHANTED_SWORD_DAMAGE.get(), 0.25, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("enchanter_offensive_notable_3", (Attribute)SkillTreeAttributes.ENCHANTED_BOW_DAMAGE.get(), 0.2, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("enchanter_offensive_notable_4", (Attribute)SkillTreeAttributes.ENCHANTED_TRIDENT_DAMAGE.get(), 0.25, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("enchanter_offensive_notable_5", (Attribute)SkillTreeAttributes.ENCHANTED_CROSSBOW_DAMAGE.get(), 0.2, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("enchanter_offensive_notable_6", (Attribute)SkillTreeAttributes.ENCHANTED_AXE_DAMAGE.get(), 0.2, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("cook_class", (Attribute)SkillTreeAttributes.COOKED_FOOD_SATURATION.get(), 0.2, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillBranchAttributeModifier("cook_defensive_crafting", (Attribute)SkillTreeAttributes.COOKED_FOOD_HEALING_PER_SATURATION.get(), 0.05, AttributeModifier.Operation.MULTIPLY_BASE, 1, 7);
        this.addSkillBranchAttributeModifier("cook_offensive_crafting", (Attribute)SkillTreeAttributes.COOKED_FOOD_DAMAGE_PER_SATURATION.get(), 0.01, AttributeModifier.Operation.MULTIPLY_BASE, 1, 7);
        this.addSkillBranchAttributeModifier("cook_defensive", (Attribute)SkillTreeAttributes.BLOCK_CHANCE.get(), 0.01, AttributeModifier.Operation.MULTIPLY_BASE, 1, 8);
        this.addSkillBranchAttributeModifier("cook_offensive", (Attribute)SkillTreeAttributes.DAMAGE_IF_NOT_HUNGRY.get(), 0.1, AttributeModifier.Operation.MULTIPLY_BASE, 1, 13);
        this.addSkillAttributeModifier("cook_defensive_notable_1", (Attribute)SkillTreeAttributes.BLOCK_CHANCE_IF_NOT_HUNGRY.get(), 0.1, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("cook_offensive_notable_1", (Attribute)SkillTreeAttributes.DAMAGE_IF_NOT_HUNGRY.get(), 0.25, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillBranchAttributeModifier("cook_life", (Attribute)SkillTreeAttributes.MAXIMUM_LIFE_IF_NOT_HUNGRY.get(), 2.0, AttributeModifier.Operation.ADDITION, 1, 2);
        this.addSkillAttributeModifier("cook_life_notable_1", (Attribute)SkillTreeAttributes.MAXIMUM_LIFE_PER_SATISFIED_HUNGER.get(), 0.5, AttributeModifier.Operation.ADDITION);
        this.addSkillBranchAttributeModifier("cook_speed", (Attribute)SkillTreeAttributes.ATTACK_SPEED_IF_NOT_HUNGRY.get(), 0.05, AttributeModifier.Operation.MULTIPLY_BASE, 1, 2);
        this.addSkillAttributeModifier("cook_speed_notable_1", (Attribute)SkillTreeAttributes.ATTACK_SPEED_IF_NOT_HUNGRY.get(), 0.15, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillBranchAttributeModifier("cook_lesser", (Attribute)SkillTreeAttributes.COOKED_FOOD_SATURATION.get(), 0.05, AttributeModifier.Operation.MULTIPLY_BASE, 1, 6);
        this.addSkillAttributeModifier("cook_mastery", (Attribute)SkillTreeAttributes.COOKED_FOOD_SATURATION.get(), 0.5, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillBranchAttributeModifier("cook_crit", (Attribute)SkillTreeAttributes.CRIT_CHANCE_IF_NOT_HUNGRY.get(), 0.05, AttributeModifier.Operation.MULTIPLY_BASE, 1, 2);
        this.addSkillAttributeModifier("cook_crit_notable_1", (Attribute)SkillTreeAttributes.CRIT_DAMAGE_PER_SATISFIED_HUNGER.get(), 0.03, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillBranchAttributeModifier("cook_crafting", (Attribute)SkillTreeAttributes.COOKED_FOOD_LIFE_REGENERATION.get(), 0.5, AttributeModifier.Operation.ADDITION, 1, 3);
        this.addSkillAttributeModifier("cook_defensive_crafting_keystone_1", (Attribute)SkillTreeAttributes.COOKED_FOOD_HEALING_PER_SATURATION.get(), 0.25, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("cook_offensive_crafting_keystone_1", (Attribute)SkillTreeAttributes.COOKED_FOOD_CRITICAL_DAMAGE_PER_SATURATION.get(), 0.03, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillBranchAttributeModifier("cook_healing", (Attribute)SkillTreeAttributes.LIFE_ON_BLOCK.get(), 0.5, AttributeModifier.Operation.ADDITION, 1, 2);
        this.addSkillAttributeModifier("cook_healing_notable_1", (Attribute)SkillTreeAttributes.LIFE_ON_BLOCK_IF_NOT_HUNGRY.get(), 1.0, AttributeModifier.Operation.ADDITION);
        this.addSkillAttributeModifier("cook_crafting_notable_1", (Attribute)SkillTreeAttributes.COOKED_FOOD_LIFE_REGENERATION.get(), 1.5, AttributeModifier.Operation.ADDITION);
        this.addSkillAttributeModifier("cook_defensive_keystone_1", (Attribute)SkillTreeAttributes.BLOCK_CHANCE_PER_SATISFIED_HUNGER.get(), 0.01, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("cook_offensive_keystone_1", (Attribute)SkillTreeAttributes.DAMAGE_PER_SATISFIED_HUNGER.get(), 0.03, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("cook_offensive_notable_2", (Attribute)SkillTreeAttributes.MELEE_DAMAGE_IF_NOT_HUNGRY.get(), 0.15, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("cook_offensive_notable_3", (Attribute)SkillTreeAttributes.AXE_DAMAGE.get(), 0.15, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("cook_offensive_notable_4", (Attribute)SkillTreeAttributes.TRIDENT_DAMAGE.get(), 0.25, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("cook_offensive_notable_5", (Attribute)SkillTreeAttributes.SWORD_DAMAGE.get(), 0.2, AttributeModifier.Operation.MULTIPLY_BASE);
        this.addSkillAttributeModifier("cook_offensive_notable_6", (Attribute)SkillTreeAttributes.PROJECTILE_DAMAGE_IF_NOT_HUNGRY.get(), 0.2, AttributeModifier.Operation.MULTIPLY_BASE);
    }

    private void addSkillBranchAttributeModifier(String branchName, Attribute attribute, double amount, AttributeModifier.Operation operation, int from, int to) {
        for (int node = from; node <= to; ++node) {
            this.addSkillAttributeModifier(branchName + "_" + node, attribute, amount, operation);
        }
    }

    private void addSkillAttributeModifier(String skillName, Attribute attribute, double amount, AttributeModifier.Operation operation) {
        this.getSkill(skillName).addAttributeBonus(attribute, new AttributeModifier(UUID.randomUUID(), "Passive Skill Bonus", amount, operation));
    }

    public void addSkillBranch(String playerClass, String branchName, String iconName, int nodeSize, int from, int to) {
        for (int node = from; node <= to; ++node) {
            this.addSkill(playerClass, branchName + "_" + node, iconName, nodeSize);
        }
    }

    private void connectSkillsBetweenClasses(String from, String to) {
        for (int classId = 0; classId < this.playerClasses.length - 1; ++classId) {
            this.connectSkills(this.playerClasses[classId] + "_" + from, this.playerClasses[classId + 1] + "_" + to);
        }
        this.connectSkills(this.playerClasses[5] + "_" + from, this.playerClasses[0] + "_" + to);
    }

    private void setSkillBranchPosition(String playerClass, String initialNodeName, int distanceBetweenNodes, String branchName, float initialRotation, float rotationPerNode, int from, int to) {
        Object branchNode = initialNodeName;
        for (int node = from; node <= to; ++node) {
            this.setSkillPosition(playerClass, (String)branchNode, (float)distanceBetweenNodes, initialRotation + (float)(node - from) * rotationPerNode, branchName + "_" + node);
            branchNode = branchName + "_" + node;
        }
    }

    private void setSkillPosition(String playerClass, @Nullable String previousSkillName, float distance, float angle, String skillName) {
        this.setSkillPosition(this.getClassId(playerClass), playerClass + "_" + previousSkillName, distance, angle, playerClass + "_" + skillName);
    }

    private void setSkillPosition(int classId, @Nullable String previousSkillName, float distance, float angle, String skillName) {
        angle *= (float)Math.PI / 180;
        angle += this.getClassBranchRotation(classId);
        PassiveSkill previousSkill = previousSkillName == null ? null : this.getSkill(previousSkillName);
        PassiveSkill skill = this.getSkill(skillName);
        float centerX = 0.0f;
        float centerY = 0.0f;
        int buttonSize = skill.getButtonSize();
        distance += (float)buttonSize / 2.0f;
        if (previousSkill != null) {
            int previousButtonRadius = previousSkill.getButtonSize() / 2;
            distance += (float)previousButtonRadius;
            centerX = previousSkill.getPositionX() + previousButtonRadius;
            centerY = previousSkill.getPositionY() + previousButtonRadius;
        }
        float skillX = centerX + Mth.m_14031_((float)angle) * distance - (float)buttonSize / 2.0f;
        float skillY = centerY + Mth.m_14089_((float)angle) * distance - (float)buttonSize / 2.0f;
        skill.setPosition(Math.round(skillX), Math.round(skillY));
        if (previousSkill != null) {
            previousSkill.connect(skill);
        }
    }

    protected int getClassId(String playerClass) {
        return Arrays.asList(this.playerClasses).indexOf(playerClass);
    }

    public float getClassBranchRotation(int classId) {
        return (float)classId * (float)Math.PI * 2.0f / 6.0f;
    }

    private PassiveSkill getSkill(String skillName) {
        return this.getSkills().get(this.getSkillId(skillName));
    }

    private void connectSkills(String skillName1, String skillName2) {
        this.getSkill(skillName1).connect(this.getSkill(skillName2));
    }

    private void connectSkills(String playerClass, String skillName1, String skillName2) {
        this.getSkill(playerClass + "_" + skillName1).connect(this.getSkill(playerClass + "_" + skillName2));
    }

    private ResourceLocation getSkillId(String skillName) {
        return new ResourceLocation("skilltree", skillName);
    }

    private void addSkill(String playerClass, String skillName, String iconName, int buttonSize) {
        this.addSkill(playerClass + "_" + skillName, playerClass + "_" + iconName, buttonSize);
    }

    private void addSkill(String skillName, String iconName, int buttonSize) {
        ResourceLocation skillId = new ResourceLocation("skilltree", skillName);
        ResourceLocation treeId = new ResourceLocation("skilltree", "tree");
        String backgroundName = buttonSize == 24 ? "keystone" : (buttonSize == 20 ? "notable" : "lesser");
        ResourceLocation backgroundTexture = new ResourceLocation("skilltree", "textures/icons/background/" + backgroundName + ".png");
        ResourceLocation iconTexture = new ResourceLocation("skilltree", "textures/icons/" + iconName + ".png");
        this.data.put(skillId, new PassiveSkill(skillId, treeId, buttonSize, backgroundTexture, iconTexture, skillName.endsWith("class")));
    }

    public void m_213708_(CachedOutput cachedOutput) throws IOException {
        this.addSkills();
        this.shapeSkillTree();
        this.setSkillsAttributeModifiers();
        for (PassiveSkill skill : this.data.values()) {
            this.save(cachedOutput, skill);
        }
    }

    private void save(CachedOutput cachedOutput, PassiveSkill skill) throws IOException {
        Path path = this.dataGenerator.m_123916_().resolve("data/" + skill.getId().m_135827_() + "/skills/" + skill.getId().m_135815_() + ".json");
        JsonObject json = skill.writeToJson();
        DataProvider.m_236072_((CachedOutput)cachedOutput, (JsonElement)json, (Path)path);
    }

    public Map<ResourceLocation, PassiveSkill> getSkills() {
        return this.data;
    }

    public String m_6055_() {
        return "Skills Provider";
    }
}

