/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.enchantment;

import daripher.skilltree.init.SkillTreeAttributes;
import java.util.List;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentInstance;

public class EnchantmentHelper {
    public static void amplifyEnchantments(List<EnchantmentInstance> enchantments, RandomSource random, Player player) {
        for (int i = 0; i < enchantments.size(); ++i) {
            EnchantmentInstance enchantment = enchantments.get(i);
            EnchantmentInstance amplifiedEnchantment = EnchantmentHelper.amplifyEnchantment(enchantment, random, player);
            enchantments.set(i, amplifiedEnchantment);
        }
    }

    private static EnchantmentInstance amplifyEnchantment(EnchantmentInstance enchantment, RandomSource random, Player player) {
        double amplificationChance = EnchantmentHelper.getEnchantmentAmplificationChance(enchantment, player);
        if (amplificationChance == 0.0) {
            return enchantment;
        }
        int levelBonus = (int)amplificationChance;
        amplificationChance -= (double)levelBonus;
        int enchantmentLevel = enchantment.f_44948_ + levelBonus;
        if ((double)random.m_188501_() < amplificationChance) {
            ++enchantmentLevel;
        }
        return new EnchantmentInstance(enchantment.f_44947_, enchantmentLevel);
    }

    private static double getEnchantmentAmplificationChance(EnchantmentInstance enchantment, Player player) {
        double amplificationChance = EnchantmentHelper.getBaseEnchantmentAmplificationChance(player);
        EnchantmentCategory category = enchantment.f_44947_.f_44672_;
        if (EnchantmentHelper.isArmorEnchantment(category)) {
            amplificationChance += EnchantmentHelper.getArmorEnchantmentAmplificationChance(player);
        }
        if (EnchantmentHelper.isWeaponEnchantment(category)) {
            amplificationChance += EnchantmentHelper.getWeaponEnchantmentAmplificationChance(player);
        }
        return amplificationChance;
    }

    public static int reduceLevelRequirement(int levelRequirement, Player player) {
        double reduction = EnchantmentHelper.getLevelRequirementReduction(player);
        if (reduction == 0.0) {
            return levelRequirement;
        }
        return EnchantmentHelper.reduceRequirement(levelRequirement, reduction);
    }

    private static int reduceRequirement(int cost, double reduction) {
        if (cost == 0) {
            return cost;
        }
        if ((cost = (int)((double)cost * (1.0 - reduction))) < 1) {
            cost = 1;
        }
        return cost;
    }

    private static double getLevelRequirementReduction(Player player) {
        double reduction = player.m_21133_((Attribute)SkillTreeAttributes.ENCHANTMENT_LEVEL_REQUIREMENT_REDUCTION.get()) - 1.0;
        double roundReduction = (double)Math.round(reduction * 100.0) / 100.0;
        return roundReduction;
    }

    private static double getWeaponEnchantmentAmplificationChance(Player player) {
        return player.m_21133_((Attribute)SkillTreeAttributes.CHANCE_TO_APPLY_BETTER_WEAPON_ENCHANTMENT.get()) - 1.0;
    }

    private static double getArmorEnchantmentAmplificationChance(Player player) {
        return player.m_21133_((Attribute)SkillTreeAttributes.CHANCE_TO_APPLY_BETTER_ARMOR_ENCHANTMENT.get()) - 1.0;
    }

    private static double getBaseEnchantmentAmplificationChance(Player player) {
        return player.m_21133_((Attribute)SkillTreeAttributes.CHANCE_TO_APPLY_BETTER_ENCHANTMENT.get()) - 1.0;
    }

    private static boolean isWeaponEnchantment(EnchantmentCategory enchantmentCategory) {
        return enchantmentCategory == EnchantmentCategory.WEAPON || enchantmentCategory == EnchantmentCategory.BOW || enchantmentCategory == EnchantmentCategory.CROSSBOW;
    }

    private static boolean isArmorEnchantment(EnchantmentCategory enchantmentCategory) {
        return enchantmentCategory == EnchantmentCategory.ARMOR || enchantmentCategory == EnchantmentCategory.ARMOR_FEET || enchantmentCategory == EnchantmentCategory.ARMOR_LEGS || enchantmentCategory == EnchantmentCategory.ARMOR_HEAD;
    }
}

