/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.gem;

import daripher.skilltree.compat.apotheosis.ApotheosisCompatibility;
import daripher.skilltree.config.Config;
import daripher.skilltree.gem.GemHelper;
import daripher.skilltree.init.SkillTreeAttributes;
import daripher.skilltree.item.ItemHelper;
import daripher.skilltree.item.gem.GemItem;
import daripher.skilltree.util.TooltipHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="skilltree")
public class GemBonusHandler {
    private static final Map<EquipmentSlot, String[]> MODIFIER_IDS = new HashMap<EquipmentSlot, String[]>();

    @SubscribeEvent
    public static void applyGemstoneBonuses(ItemAttributeModifierEvent event) {
        if (!ItemHelper.canInsertGem(event.getItemStack())) {
            return;
        }
        int gemstoneSlot = 0;
        while (GemHelper.hasGem(event.getItemStack(), gemstoneSlot)) {
            GemBonusHandler.applyGemstoneAttributeModifier(event, gemstoneSlot);
            ++gemstoneSlot;
        }
    }

    @SubscribeEvent
    public static void addGemstoneTooltips(ItemTooltipEvent event) {
        if (!ItemHelper.canInsertGem(event.getItemStack())) {
            return;
        }
        event.getToolTip().add(Component.m_237119_());
        int gemstoneSlot = 0;
        while (GemHelper.hasGem(event.getItemStack(), gemstoneSlot)) {
            GemBonusHandler.addGemstoneTooltip(event, gemstoneSlot);
            ++gemstoneSlot;
        }
        GemBonusHandler.addEmptySocketsTooltip(event);
    }

    @SubscribeEvent
    public static void dropGemFromOre(BlockEvent.BreakEvent event) {
        boolean hasSilkTouch;
        Player player = event.getPlayer();
        if (player.m_7500_()) {
            return;
        }
        Level level = player.m_9236_();
        if (level.f_46443_) {
            return;
        }
        double dropChance = Config.COMMON_CONFIG.getGemDropChance();
        if ((dropChance += player.m_21133_((Attribute)SkillTreeAttributes.GEM_DROP_CHANCE.get()) - 1.0) == 0.0) {
            return;
        }
        BlockPos blockPos = event.getPos();
        boolean isOre = level.m_8055_(blockPos).m_204336_(Tags.Blocks.ORES);
        if (!isOre) {
            return;
        }
        if ((double)player.m_217043_().m_188501_() >= dropChance) {
            return;
        }
        boolean usingCorrectTool = ForgeHooks.isCorrectToolForDrops((BlockState)event.getState(), (Player)player);
        if (!usingCorrectTool) {
            return;
        }
        boolean bl = hasSilkTouch = player.m_21205_().getEnchantmentLevel(Enchantments.f_44985_) > 0;
        if (hasSilkTouch) {
            return;
        }
        if (ModList.get().isLoaded("apotheosis") && ApotheosisCompatibility.ISNTANCE.adventureModuleEnabled()) {
            ApotheosisCompatibility.ISNTANCE.dropGemFromOre(player, (ServerLevel)level, blockPos);
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        LootTable lootTable = serverLevel.m_7654_().m_129898_().m_79217_(new ResourceLocation("skilltree", "gems"));
        LootContext lootContext = new LootContext.Builder(serverLevel).m_78972_(LootContextParams.f_81461_, (Object)event.getState()).m_78972_(LootContextParams.f_81460_, (Object)new Vec3((double)event.getPos().m_123341_(), (double)event.getPos().m_123342_(), (double)event.getPos().m_123343_())).m_78972_(LootContextParams.f_81463_, (Object)player.m_21205_()).m_78963_(player.m_36336_()).m_78975_(LootContextParamSets.f_81421_);
        lootTable.m_230922_(lootContext).forEach(item -> Block.m_49840_((Level)level, (BlockPos)blockPos, (ItemStack)item));
    }

    private static void applyGemstoneAttributeModifier(ItemAttributeModifierEvent event, int gemstoneSlot) {
        ItemStack itemStack = event.getItemStack();
        EquipmentSlot itemSlot = ItemHelper.getSlotForItem(itemStack);
        if (itemSlot != event.getSlotType()) {
            return;
        }
        Triple<Attribute, Double, AttributeModifier.Operation> attributeBonus = GemItem.getAttributeBonus(itemStack, gemstoneSlot);
        Attribute attribute = (Attribute)attributeBonus.getLeft();
        AttributeModifier attributeModifier = GemBonusHandler.getAttributeModifier(gemstoneSlot, attributeBonus, event.getSlotType());
        event.addModifier(attribute, attributeModifier);
    }

    public static void addEmptySocketsTooltip(ItemTooltipEvent event) {
        if (!ItemHelper.canInsertGem(event.getItemStack())) {
            return;
        }
        int emptySockets = GemHelper.getEmptySockets(event.getItemStack(), event.getEntity());
        for (int i = 0; i < emptySockets; ++i) {
            event.getToolTip().add(Component.m_237115_((String)"gem.socket").m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    private static void addGemstoneTooltip(ItemTooltipEvent event, int gemstoneSlot) {
        ItemStack itemStack = event.getItemStack();
        GemItem gemstoneItem = GemHelper.getGem(itemStack, gemstoneSlot);
        Triple gemstoneBonus = GemItem.getAttributeBonus(itemStack, gemstoneSlot);
        if (gemstoneSlot > 0) {
            for (int i = gemstoneSlot - 1; i >= 0; --i) {
                if (!GemBonusHandler.areGemstonesAndBonusesSame(itemStack, gemstoneItem, gemstoneBonus, i)) continue;
                return;
            }
        }
        GemBonusHandler.removeTooltip(event.getToolTip(), TooltipHelper.getAttributeBonusTooltip(gemstoneBonus));
        int sameGemstonesCount = 1;
        for (int i = gemstoneSlot + 1; i < 4; ++i) {
            if (!GemBonusHandler.areGemstonesAndBonusesSame(itemStack, gemstoneItem, gemstoneBonus, i)) continue;
            Triple<Attribute, Double, AttributeModifier.Operation> secondBonus = GemItem.getAttributeBonus(itemStack, i);
            GemBonusHandler.removeTooltip(event.getToolTip(), TooltipHelper.getAttributeBonusTooltip(secondBonus));
            double summedAmounts = (Double)gemstoneBonus.getMiddle() + (Double)secondBonus.getMiddle();
            gemstoneBonus = Triple.of((Object)((Attribute)gemstoneBonus.getLeft()), (Object)summedAmounts, (Object)((AttributeModifier.Operation)gemstoneBonus.getRight()));
            ++sameGemstonesCount;
        }
        MutableComponent gemstoneBonusTooltip = TooltipHelper.getAttributeBonusTooltip(gemstoneBonus);
        MutableComponent gemstoneName = gemstoneItem.getName(new ItemStack((ItemLike)gemstoneItem));
        if (sameGemstonesCount > 1) {
            gemstoneName.m_130946_(" x" + sameGemstonesCount);
        }
        gemstoneName.m_130946_(":");
        gemstoneName = gemstoneItem.applyGemstoneColorStyle(gemstoneName);
        event.getToolTip().add(gemstoneName);
        event.getToolTip().add(gemstoneBonusTooltip);
    }

    private static void removeTooltip(List<Component> tooltips, MutableComponent tooltip) {
        Iterator<Component> tooltipsIterator = tooltips.iterator();
        while (tooltipsIterator.hasNext()) {
            if (!tooltipsIterator.next().equals(tooltip)) continue;
            tooltipsIterator.remove();
            break;
        }
    }

    protected static boolean areGemstonesAndBonusesSame(@NotNull ItemStack itemStack, GemItem gemstoneItem, Triple<Attribute, Double, AttributeModifier.Operation> gemstoneBonus, int gemstoneSlot) {
        if (GemHelper.getGem(itemStack, gemstoneSlot) != gemstoneItem) {
            return false;
        }
        return GemBonusHandler.isSameBonus(gemstoneBonus, GemItem.getAttributeBonus(itemStack, gemstoneSlot));
    }

    private static boolean isSameBonus(Triple<Attribute, Double, AttributeModifier.Operation> first, Triple<Attribute, Double, AttributeModifier.Operation> second) {
        if (first.equals(second)) {
            return true;
        }
        return first.getLeft() == second.getLeft() && first.getRight() == second.getRight();
    }

    public static AttributeModifier getAttributeModifier(int gemstoneSlot, Triple<Attribute, Double, AttributeModifier.Operation> attributeBonus, EquipmentSlot equipmentSlot) {
        Double amount = (Double)attributeBonus.getMiddle();
        AttributeModifier.Operation operation = (AttributeModifier.Operation)attributeBonus.getRight();
        UUID modifierId = UUID.fromString(MODIFIER_IDS.get(equipmentSlot)[gemstoneSlot]);
        return new AttributeModifier(modifierId, "Gemstone Bonus", amount.doubleValue(), operation);
    }

    static {
        MODIFIER_IDS.put(EquipmentSlot.CHEST, new String[]{"13518502-5211-480b-a847-028791de292a", "fa4135ee-69d1-4e6d-9f12-d26a34f694ff", "9d89442a-2b8b-4512-91e5-a56b2e4673eb", "d17a0be7-0d41-4b58-9a23-30996eda86d7"});
        MODIFIER_IDS.put(EquipmentSlot.FEET, new String[]{"1829e876-fa03-42d3-8ad2-db138f4e7380", "2e040afb-c978-4906-bdfd-f909fd2813a1", "67276182-31f2-48df-b308-f4fe2d8d2560", "1d690ba4-716b-4071-a8e0-141ef403f945"});
        MODIFIER_IDS.put(EquipmentSlot.HEAD, new String[]{"cd455ae0-b90a-42ef-b014-e4585b8316a6", "0bdbc590-353c-4b94-8c31-0b8611f13371", "1a3f8247-7efc-4a85-b5be-896833374920", "816bff45-9044-4610-9585-c48526b71fac"});
        MODIFIER_IDS.put(EquipmentSlot.LEGS, new String[]{"d5cd2cf4-b0f7-448c-afee-4f3772b36c52", "c82520e3-e1c2-49f2-b56d-6ce8823558ec", "25d82da0-d30a-4e53-98bb-c22717b0b289", "de9d7b3d-e8d2-4e3b-8125-2ec83b3a0d63"});
        MODIFIER_IDS.put(EquipmentSlot.MAINHAND, new String[]{"99c5a016-4224-4395-8f21-3a200f02325b", "80e663e7-fb40-4b72-8774-34ee86ba2635", "bfb3aa0b-3853-4fa0-a996-5bc3a861891a", "12ac91c2-a41b-4073-9e8e-572453d9463d"});
        MODIFIER_IDS.put(EquipmentSlot.OFFHAND, new String[]{"e53552dd-4468-41e9-bae8-b8a23c3bcce1", "ff4c3814-1c62-4de9-966b-3f8381f2faf4", "30fc1b4e-84ca-4ca3-a64e-1ce02cf3a49b", "f443fe93-8c93-4433-b3a9-aa6bb15bc0eb"});
    }
}

