/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.gem;

import com.mojang.logging.LogUtils;
import daripher.skilltree.compat.apotheosis.ApotheosisCompatibility;
import daripher.skilltree.init.SkillTreeAttributes;
import daripher.skilltree.item.ItemHelper;
import daripher.skilltree.item.gem.GemItem;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class GemHelper {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected static final String GEMS_TAG = "GEMSTONES";
    protected static final String GEM_TAG = "GEMSTONE";
    protected static final String ATTRIBUTE_TAG = "ATTRIBUTE";
    protected static final String AMOUNT_TAG = "AMOUNT";
    protected static final String OPERATION_TAG = "OPERATION";
    protected static final String ADDITIONAL_GEMS_TAG = "ADDITIONAL_GEMSTONES";

    public static boolean hasGem(ItemStack itemStack, int gemSlot) {
        if (ModList.get().isLoaded("apotheosis") && ApotheosisCompatibility.ISNTANCE.adventureModuleEnabled()) {
            return false;
        }
        if (!itemStack.m_41782_()) {
            return false;
        }
        if (!itemStack.m_41783_().m_128441_(GEMS_TAG)) {
            return false;
        }
        ListTag gemsTagList = GemHelper.getGemsListTag(itemStack);
        if (gemsTagList.size() <= gemSlot) {
            return false;
        }
        return gemsTagList.get(gemSlot) != null;
    }

    public static void insertGem(Player player, ItemStack itemStack, GemItem gem, int gemSlot, double gemPower) {
        Triple<Attribute, Double, AttributeModifier.Operation> gemBonus;
        CompoundTag gemTag = null;
        ListTag gemsTagList = GemHelper.getGemsListTag(itemStack);
        if (gemsTagList.size() > gemSlot) {
            gemTag = gemsTagList.m_128728_(gemSlot);
        }
        if (gemTag == null) {
            gemTag = new CompoundTag();
        }
        if ((gemBonus = gem.getGemBonus(player, itemStack)) == null) {
            LOGGER.error("Cannot insert gem into {}", (Object)itemStack.m_41720_());
            LOGGER.error("Slot: {}", (Object)Player.m_147233_((ItemStack)itemStack));
            return;
        }
        Attribute attribute = (Attribute)gemBonus.getLeft();
        String attributeId = ForgeRegistries.ATTRIBUTES.getKey((Object)attribute).toString();
        double amount = (Double)gemBonus.getMiddle() * (1.0 + gemPower);
        String operation = ((AttributeModifier.Operation)gemBonus.getRight()).toString();
        String gemId = ForgeRegistries.ITEMS.getKey((Object)gem).toString();
        gemTag.m_128359_(GEM_TAG, gemId);
        gemTag.m_128359_(ATTRIBUTE_TAG, attributeId);
        gemTag.m_128347_(AMOUNT_TAG, amount);
        gemTag.m_128359_(OPERATION_TAG, operation);
        gemsTagList.add(gemSlot, (Tag)gemTag);
        itemStack.m_41783_().m_128365_(GEMS_TAG, (Tag)gemsTagList);
    }

    public static void removeGems(ItemStack itemStack) {
        itemStack.m_41783_().m_128473_(GEMS_TAG);
    }

    public static Triple<Attribute, Double, AttributeModifier.Operation> getAttributeBonus(ItemStack itemStack, int socket) {
        CompoundTag gemstoneTag = (CompoundTag)GemHelper.getGemsListTag(itemStack).get(socket);
        String attributeId = gemstoneTag.m_128461_(ATTRIBUTE_TAG);
        Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(attributeId));
        double amount = gemstoneTag.m_128459_(AMOUNT_TAG);
        AttributeModifier.Operation operation = AttributeModifier.Operation.valueOf((String)gemstoneTag.m_128461_(OPERATION_TAG));
        return Triple.of((Object)attribute, (Object)amount, (Object)operation);
    }

    public static GemItem getGem(ItemStack itemStack, int socket) {
        if (ModList.get().isLoaded("apotheosis") && ApotheosisCompatibility.ISNTANCE.adventureModuleEnabled()) {
            return null;
        }
        if (!GemHelper.hasGem(itemStack, socket)) {
            return null;
        }
        CompoundTag gemTag = (CompoundTag)GemHelper.getGemsListTag(itemStack).get(socket);
        String gemId = gemTag.m_128461_(GEM_TAG);
        Item gem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(gemId));
        if (!(gem instanceof GemItem)) {
            return null;
        }
        return (GemItem)gem;
    }

    public static void setAdditionalSocket(ItemStack itemStack) {
        itemStack.m_41784_().m_128379_(ADDITIONAL_GEMS_TAG, true);
    }

    public static boolean hasAdditionalSocket(ItemStack itemStack) {
        return itemStack.m_41782_() && itemStack.m_41783_().m_128441_(ADDITIONAL_GEMS_TAG);
    }

    public static int getGemsCount(ItemStack itemStack) {
        if (ModList.get().isLoaded("apotheosis")) {
            return ApotheosisCompatibility.ISNTANCE.getGemsCount(itemStack);
        }
        if (itemStack.m_41619_()) {
            return 0;
        }
        int gemsCount = 0;
        int socket = 0;
        while (GemHelper.hasGem(itemStack, socket)) {
            ++gemsCount;
            ++socket;
        }
        return gemsCount;
    }

    public static int getGemsCount(ItemStack itemStack, Item gem) {
        if (ModList.get().isLoaded("apotheosis")) {
            return 0;
        }
        if (itemStack.m_41619_()) {
            return 0;
        }
        int gemsCount = 0;
        int socket = 0;
        while (GemHelper.hasGem(itemStack, socket)) {
            if (GemHelper.getGem(itemStack, socket) == gem) {
                ++gemsCount;
            }
            ++socket;
        }
        return gemsCount;
    }

    public static boolean hasOnlyDifferentGems(ItemStack itemStack) {
        if (ModList.get().isLoaded("apotheosis")) {
            return false;
        }
        if (!GemHelper.hasGem(itemStack, 0)) {
            return false;
        }
        HashSet gems = new HashSet();
        int socket = 0;
        while (GemHelper.hasGem(itemStack, socket)) {
            GemItem gem = GemHelper.getGem(itemStack, socket);
            if (gems.contains((Object)gem)) {
                return false;
            }
            ++socket;
        }
        return true;
    }

    public static boolean hasOnlySameGems(ItemStack itemStack) {
        if (ModList.get().isLoaded("apotheosis")) {
            return false;
        }
        if (!GemHelper.hasGem(itemStack, 0)) {
            return false;
        }
        int socket = 1;
        while (GemHelper.hasGem(itemStack, socket)) {
            if (GemHelper.getGem(itemStack, socket) != GemHelper.getGem(itemStack, 0)) {
                return false;
            }
            ++socket;
        }
        return true;
    }

    public static int getEmptySockets(@NotNull ItemStack itemStack, @Nullable Player player) {
        int sockets;
        if (ModList.get().isLoaded("apotheosis") && ApotheosisCompatibility.ISNTANCE.adventureModuleEnabled()) {
            return 0;
        }
        int emptySockets = sockets = GemHelper.getMaximumSockets(itemStack, player);
        for (int socket = 0; socket < sockets; ++socket) {
            if (!GemHelper.hasGem(itemStack, socket)) continue;
            --emptySockets;
        }
        return emptySockets;
    }

    public static int getMaximumSockets(@NotNull ItemStack itemStack, @Nullable Player player) {
        if (ModList.get().isLoaded("apotheosis") && ApotheosisCompatibility.ISNTANCE.adventureModuleEnabled()) {
            return 0;
        }
        int sockets = 1;
        if (GemHelper.hasAdditionalSocket(itemStack)) {
            ++sockets;
        }
        if (player == null) {
            return sockets;
        }
        sockets += (int)player.m_21133_((Attribute)SkillTreeAttributes.MAXIMUM_SOCKETS.get());
        if (ItemHelper.isChestplate(itemStack)) {
            sockets += (int)player.m_21133_((Attribute)SkillTreeAttributes.MAXIMUM_CHESTPLATE_SOCKETS.get());
        }
        if (ItemHelper.isWeapon(itemStack)) {
            sockets += (int)player.m_21133_((Attribute)SkillTreeAttributes.MAXIMUM_WEAPON_SOCKETS.get());
        }
        return sockets;
    }

    protected static ListTag getGemsListTag(ItemStack itemStack) {
        return itemStack.m_41784_().m_128437_(GEMS_TAG, (int)new CompoundTag().m_7060_());
    }
}

