/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.item;

import daripher.skilltree.compat.apotheosis.ApotheosisCompatibility;
import daripher.skilltree.config.Config;
import daripher.skilltree.util.PotionHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemHelper {
    private static final String DEFENCE_BONUS_TAG = "DefenceBonus";
    private static final String EVASION_BONUS_TAG = "EvasionBonus";
    private static final String DAMAGE_BONUS_TAG = "DamageBonus";
    private static final String ATTACK_SPEED_BONUS_TAG = "AttackSpeedBonus";
    private static final String TOUGHNESS_BONUS_TAG = "ToughnessBonus";
    private static final String DURABILITY_BONUS_TAG = "DurabilityBonus";
    private static final String POISONS_TAG = "Poisons";

    public static void setDefenceBonus(ItemStack itemStack, double bonus) {
        itemStack.m_41784_().m_128347_(DEFENCE_BONUS_TAG, bonus);
    }

    public static boolean hasDefenceBonus(ItemStack itemStack) {
        return itemStack.m_41782_() && itemStack.m_41783_().m_128441_(DEFENCE_BONUS_TAG);
    }

    public static double getDefenceBonus(ItemStack itemStack) {
        return itemStack.m_41783_().m_128459_(DEFENCE_BONUS_TAG);
    }

    public static void setEvasionBonus(ItemStack itemStack, double bonus) {
        itemStack.m_41784_().m_128347_(EVASION_BONUS_TAG, bonus);
    }

    public static boolean hasEvasionBonus(ItemStack itemStack) {
        return itemStack.m_41782_() && itemStack.m_41783_().m_128441_(EVASION_BONUS_TAG);
    }

    public static double getEvasionBonus(ItemStack itemStack) {
        return itemStack.m_41783_().m_128459_(EVASION_BONUS_TAG);
    }

    public static void setToughnessBonus(ItemStack itemStack, double bonus) {
        itemStack.m_41784_().m_128347_(TOUGHNESS_BONUS_TAG, bonus);
    }

    public static boolean hasToughnessBonus(ItemStack itemStack) {
        return itemStack.m_41782_() && itemStack.m_41783_().m_128441_(TOUGHNESS_BONUS_TAG);
    }

    public static double getToughnessBonus(ItemStack itemStack) {
        return itemStack.m_41783_().m_128459_(TOUGHNESS_BONUS_TAG);
    }

    public static void setDamageBonus(ItemStack itemStack, double bonus) {
        itemStack.m_41784_().m_128347_(DAMAGE_BONUS_TAG, bonus);
    }

    public static boolean hasDamageBonus(ItemStack itemStack) {
        return itemStack.m_41782_() && itemStack.m_41783_().m_128441_(DAMAGE_BONUS_TAG);
    }

    public static double getDamageBonus(ItemStack itemStack) {
        return itemStack.m_41783_().m_128459_(DAMAGE_BONUS_TAG);
    }

    public static void setAttackSpeedBonus(ItemStack itemStack, double bonus) {
        itemStack.m_41784_().m_128347_(ATTACK_SPEED_BONUS_TAG, bonus);
    }

    public static boolean hasAttackSpeedBonus(ItemStack itemStack) {
        return itemStack.m_41782_() && itemStack.m_41783_().m_128441_(ATTACK_SPEED_BONUS_TAG);
    }

    public static double getAttackSpeedBonus(ItemStack itemStack) {
        return itemStack.m_41783_().m_128459_(ATTACK_SPEED_BONUS_TAG);
    }

    public static void setDurabilityBonus(ItemStack itemStack, double bonus) {
        itemStack.m_41784_().m_128347_(DURABILITY_BONUS_TAG, bonus);
    }

    public static boolean hasDurabilityBonus(ItemStack itemStack) {
        return itemStack.m_41782_() && itemStack.m_41783_().m_128441_(DURABILITY_BONUS_TAG);
    }

    public static double getDurabilityBonus(ItemStack itemStack) {
        return itemStack.m_41783_().m_128459_(DURABILITY_BONUS_TAG);
    }

    public static void applyBaseModifierBonus(ItemAttributeModifierEvent event, Attribute attribute, Function<Double, Double> amountModifier) {
        Collection modifiers = event.getOriginalModifiers().get((Object)attribute);
        modifiers.forEach(modifier -> {
            event.removeModifier(attribute, modifier);
            modifier = new AttributeModifier(modifier.m_22209_(), modifier.m_22214_(), ((Double)amountModifier.apply(modifier.m_22218_())).doubleValue(), modifier.m_22217_());
            event.addModifier(attribute, modifier);
        });
    }

    public static boolean canInsertGem(ItemStack itemStack) {
        if (ModList.get().isLoaded("apotheosis") && ApotheosisCompatibility.ISNTANCE.adventureModuleEnabled()) {
            return false;
        }
        List<? extends String> blacklist = Config.COMMON_CONFIG.getBlacklistedGemstoneContainers();
        if (blacklist.contains("*:*")) {
            return false;
        }
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_());
        if (blacklist.contains(itemId.toString())) {
            return false;
        }
        String itemNamespace = itemId.m_135827_();
        if (blacklist.contains(itemNamespace + ":*")) {
            return false;
        }
        return ItemHelper.isEquipment(itemStack);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isPoison(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (!(item instanceof PotionItem)) return false;
        PotionItem potion = (PotionItem)item;
        if (!PotionHelper.isHarmfulPotion(itemStack)) return false;
        return true;
    }

    public static boolean isPotion(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof PotionItem;
    }

    public static void setPoisons(ItemStack result, ItemStack poisonStack) {
        List effects = PotionUtils.m_43547_((ItemStack)poisonStack);
        ListTag poisonsTag = new ListTag();
        for (MobEffectInstance effect : effects) {
            CompoundTag effectTag = effect.m_19555_(new CompoundTag());
            poisonsTag.add((Object)effectTag);
        }
        result.m_41784_().m_128365_(POISONS_TAG, (Tag)poisonsTag);
    }

    public static boolean hasPoisons(ItemStack itemStack) {
        return itemStack.m_41782_() && itemStack.m_41783_().m_128441_(POISONS_TAG);
    }

    public static List<MobEffectInstance> getPoisons(ItemStack itemStack) {
        ListTag poisonsTag = itemStack.m_41783_().m_128437_(POISONS_TAG, 10);
        ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
        for (Tag tag : poisonsTag) {
            MobEffectInstance effect = MobEffectInstance.m_19560_((CompoundTag)((CompoundTag)tag));
            effects.add(effect);
        }
        return effects;
    }

    public static EquipmentSlot getSlotForItem(ItemStack itemStack) {
        EquipmentSlot slot = Player.m_147233_((ItemStack)itemStack);
        if (ItemHelper.isMeleeWeapon(itemStack) && slot == EquipmentSlot.OFFHAND) {
            slot = EquipmentSlot.MAINHAND;
        }
        return slot;
    }

    public static boolean isArmor(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof ArmorItem || itemStack.m_204117_(Tags.Items.ARMORS);
    }

    public static boolean isShield(ItemStack itemStack) {
        if (itemStack.canPerformAction(ToolActions.SHIELD_BLOCK)) {
            return true;
        }
        return itemStack.m_41720_() instanceof ShieldItem || itemStack.m_204117_(Tags.Items.TOOLS_SHIELDS);
    }

    public static boolean isMeleeWeapon(ItemStack itemStack) {
        return ItemHelper.isSword(itemStack) || ItemHelper.isAxe(itemStack) || ItemHelper.isTrident(itemStack);
    }

    public static boolean isRangedWeapon(ItemStack itemStack) {
        return ItemHelper.isCrossbow(itemStack) || ItemHelper.isBow(itemStack) || ItemHelper.isTrident(itemStack);
    }

    public static boolean isCrossbow(ItemStack itemStack) {
        if (ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()).toString().equals("tetra:modular_crossbow")) {
            return true;
        }
        return itemStack.m_41720_() instanceof CrossbowItem || itemStack.m_204117_(Tags.Items.TOOLS_CROSSBOWS);
    }

    public static boolean isBow(ItemStack itemStack) {
        if (ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()).toString().equals("tetra:modular_bow")) {
            return true;
        }
        return itemStack.m_41720_() instanceof BowItem || itemStack.m_204117_(Tags.Items.TOOLS_BOWS);
    }

    public static boolean isTrident(ItemStack itemStack) {
        if (ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()).toString().equals("tetra:modular_single")) {
            return true;
        }
        return itemStack.m_41720_() instanceof TridentItem || itemStack.m_204117_(Tags.Items.TOOLS_TRIDENTS);
    }

    public static boolean isAxe(ItemStack itemStack) {
        if (itemStack.canPerformAction(ToolActions.AXE_DIG)) {
            return true;
        }
        return itemStack.m_41720_() instanceof AxeItem || itemStack.m_204117_(Tags.Items.TOOLS_AXES);
    }

    public static boolean isSword(ItemStack itemStack) {
        if (ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()).toString().equals("tetra:modular_sword")) {
            return true;
        }
        if (itemStack.canPerformAction(ToolActions.SWORD_DIG)) {
            return true;
        }
        if (itemStack.canPerformAction(ToolActions.SWORD_SWEEP)) {
            return true;
        }
        return itemStack.m_41720_() instanceof SwordItem || itemStack.m_204117_(Tags.Items.TOOLS_SWORDS);
    }

    public static boolean isWeapon(ItemStack itemStack) {
        return ItemHelper.isMeleeWeapon(itemStack) || ItemHelper.isRangedWeapon(itemStack);
    }

    public static boolean isHelmet(ItemStack itemStack) {
        ArmorItem armor;
        Item item = itemStack.m_41720_();
        if (item instanceof ArmorItem && (armor = (ArmorItem)item).m_40402_() == EquipmentSlot.HEAD) {
            return true;
        }
        return itemStack.m_204117_(Tags.Items.ARMORS_HELMETS);
    }

    public static boolean isChestplate(ItemStack itemStack) {
        ArmorItem armor;
        Item item = itemStack.m_41720_();
        if (item instanceof ArmorItem && (armor = (ArmorItem)item).m_40402_() == EquipmentSlot.CHEST) {
            return true;
        }
        return itemStack.m_204117_(Tags.Items.ARMORS_CHESTPLATES);
    }

    public static boolean isLeggings(ItemStack itemStack) {
        ArmorItem armor;
        Item item = itemStack.m_41720_();
        if (item instanceof ArmorItem && (armor = (ArmorItem)item).m_40402_() == EquipmentSlot.LEGS) {
            return true;
        }
        return itemStack.m_204117_(Tags.Items.ARMORS_LEGGINGS);
    }

    public static boolean isBoots(ItemStack itemStack) {
        ArmorItem armor;
        Item item = itemStack.m_41720_();
        if (item instanceof ArmorItem && (armor = (ArmorItem)item).m_40402_() == EquipmentSlot.FEET) {
            return true;
        }
        return itemStack.m_204117_(Tags.Items.ARMORS_BOOTS);
    }

    public static boolean isPickaxe(ItemStack itemStack) {
        if (itemStack.canPerformAction(ToolActions.PICKAXE_DIG)) {
            return true;
        }
        return itemStack.m_41720_() instanceof PickaxeItem || itemStack.m_204117_(Tags.Items.TOOLS_PICKAXES);
    }

    public static boolean isFood(ItemStack itemStack) {
        return itemStack.getFoodProperties(null) != null;
    }

    public static boolean isEquipment(ItemStack stack) {
        return ItemHelper.isWeapon(stack) || ItemHelper.isArmor(stack) || ItemHelper.isShield(stack) || ItemHelper.isPickaxe(stack);
    }
}

