/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.item.gem;

import daripher.skilltree.compat.apotheosis.ApotheosisCompatibility;
import daripher.skilltree.gem.GemHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.tuple.Triple;

public abstract class GemItem
extends Item {
    private final int color;

    public GemItem(int color) {
        super(new Item.Properties().m_41491_(CreativeModeTab.f_40759_));
        this.color = color;
    }

    public MutableComponent getName(ItemStack itemStack) {
        MutableComponent name = Component.m_237119_().m_7220_(super.m_7626_(itemStack));
        MutableComponent coloredName = (MutableComponent)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> this.applyGemstoneColorStyle(name));
        return coloredName == null ? name : coloredName;
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent applyGemstoneColorStyle(MutableComponent name) {
        return name.m_130948_(Style.f_131099_.m_178520_(this.color));
    }

    public void m_7373_(ItemStack itemStack, Level level, List<Component> components, TooltipFlag tooltipFlag) {
        components.add((Component)Component.m_237119_());
        if (ModList.get().isLoaded("apotheosis") && ApotheosisCompatibility.ISNTANCE.adventureModuleEnabled()) {
            components.add((Component)Component.m_237115_((String)"gem.disabled").m_130940_(ChatFormatting.RED));
            return;
        }
        MutableComponent slotsTooltip = Component.m_237115_((String)"gem.slots").m_130948_(Style.f_131099_.m_178520_(720650));
        components.add((Component)slotsTooltip);
        this.appenBonusesTooltip(components);
    }

    public boolean canInsertInto(Player currentPlayer, ItemStack baseItem, int gemstoneSlot) {
        return !GemHelper.hasGem(baseItem, gemstoneSlot);
    }

    public void insertInto(Player player, ItemStack itemStack, int gemSlot, double gemPower) {
        GemHelper.insertGem(player, itemStack, this, gemSlot, gemPower);
    }

    public static Triple<Attribute, Double, AttributeModifier.Operation> getAttributeBonus(ItemStack itemStack, int gemstoneSlot) {
        if (!GemHelper.hasGem(itemStack, gemstoneSlot)) {
            return null;
        }
        Triple<Attribute, Double, AttributeModifier.Operation> attributeBonus = GemHelper.getAttributeBonus(itemStack, gemstoneSlot);
        return attributeBonus;
    }

    @Nullable
    public abstract Triple<Attribute, Double, AttributeModifier.Operation> getGemBonus(Player var1, ItemStack var2);

    protected abstract void appenBonusesTooltip(List<Component> var1);
}

