/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.item.gem;

import daripher.skilltree.api.PSTPlayer;
import daripher.skilltree.init.SkillTreeItems;
import daripher.skilltree.item.gem.GemItem;
import daripher.skilltree.item.gem.SimpleGemItem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.Triple;

public class IrisciteItem
extends GemItem {
    private static final List<Triple<Attribute, Double, AttributeModifier.Operation>> GEM_BONUSES_CACHE = new ArrayList<Triple<Attribute, Double, AttributeModifier.Operation>>();

    public IrisciteItem() {
        super(0);
    }

    @Override
    public Triple<Attribute, Double, AttributeModifier.Operation> getGemBonus(Player player, ItemStack itemStack) {
        RandomSource random = this.createInsertionRandomSource(player, itemStack);
        if (GEM_BONUSES_CACHE.isEmpty()) {
            SkillTreeItems.REGISTRY.getEntries().stream().map(RegistryObject::get).filter(SimpleGemItem.class::isInstance).map(SimpleGemItem.class::cast).map(SimpleGemItem::getBonuses).forEach(GEM_BONUSES_CACHE::addAll);
        }
        return GEM_BONUSES_CACHE.get(random.m_188503_(GEM_BONUSES_CACHE.size()));
    }

    protected RandomSource createInsertionRandomSource(Player player, ItemStack itemStack) {
        RandomSource random = RandomSource.m_216327_();
        int randomSeed = ((PSTPlayer)player).getIrisciteSeed();
        int itemSlot = Player.m_147233_((ItemStack)itemStack).ordinal();
        random.m_188584_((long)(randomSeed + itemSlot));
        return random;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent applyGemstoneColorStyle(MutableComponent component) {
        char[] characters;
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return Component.m_237119_().m_7220_((Component)component);
        }
        MutableComponent styledComponent = Component.m_237119_();
        float hue = (float)(player.f_19797_ % 360) / 360.0f;
        for (char character : characters = component.getString().toCharArray()) {
            int color = Color.getHSBColor(hue, 0.6f, 1.0f).getRGB();
            MutableComponent characterComponent = Component.m_237113_((String)("" + character));
            Style colorStyle = Style.f_131099_.m_178520_(color);
            MutableComponent coloredCharacter = characterComponent.m_130948_(colorStyle);
            styledComponent.m_7220_((Component)coloredCharacter);
            hue += 0.05f;
        }
        return styledComponent;
    }

    @Override
    protected void appenBonusesTooltip(List<Component> components) {
        MutableComponent slotTooltip = Component.m_237115_((String)"gem.slot.anything").m_130940_(ChatFormatting.GOLD);
        MutableComponent bonusTooltip = Component.m_237115_((String)(this.m_5524_() + ".tooltip")).m_130940_(ChatFormatting.BLUE);
        components.add((Component)slotTooltip.m_7220_((Component)bonusTooltip));
    }
}

